#include "Telltales_Lib.h"
#include "Telltales_user.h"
#include "TYW_stdint.h"
#include "RTE_GPIO.h"
#include "Line_in.h"
#include "Line_In_user.h"
#include "Analog_Signals.h"
#include "TCA6416.h"
#include "Configuration.h"
#include "Flash_synchronizer.h"
#include "Brake_Pressure_Service.h"

uint16_t Get_Wet_Brake_Pressure_status_R(void);
static DataBrakeCalcStruct P_DataBrakePressureCalc;
uint16_t Brake_Pressure_Flash_status;
uint16_t Brake_Wet_Pressure_Flash_status;
uint32_t brake_voltage_current = 0u;
static uint32_t Avg_brake_voltage = 0u;
uint32_t Wet_brake_voltage_current = 0u;
static uint32_t Wet_Avg_brake_voltage = 0;
static uint16_t led_wetbrake_state_old = 0u;  // 原状态：0闪烁或白灯，1红灯
static uint16_t led_brake_state_old = 0u;  // 原状态：0白灯或者闪烁，1红灯，2红灯，5硬线接低电平红灯

/*上电初始化*/
void Data_Brake_Pressure_Service_KL30_Init(void)
{
    P_DataBrakePressureCalc.Last_R = 0u;
    P_DataBrakePressureCalc.Last_V = 0u;
    P_DataBrakePressureCalc.DstSeg_R = 0u;
    P_DataBrakePressureCalc.DstSeg_V = 0u;
}
/*上电初始化*/
void Data_Brake_Pressure_Service_Wakeup_Init(void)
{
    P_DataBrakePressureCalc.Last_R = 0u;
    P_DataBrakePressureCalc.Last_V = 0u;
    P_DataBrakePressureCalc.DstSeg_R = 0u;
    P_DataBrakePressureCalc.DstSeg_V = 0u;
}

/*制动压力报警*/
/*0灭，1亮，0xff闪烁,2白灯*/
uint16_t Get_Brake_Pressure_Service(void)
{
    uint16_t LED_STATE = 2u;
    static uint16_t led_brake_state_old1 = 0u; // 原状态：0白灯或红灯，1闪烁
    static uint32_t brake_voltage = 0u;        // 制动电压
    static uint32_t brake_resistance = 0u;     // 制动电阻
    uint32_t brake_resistance_current = 0u;
    static uint32_t Avg_brake_resistance = 0u;
    static uint16_t timerA = 0u;
    static uint16_t timer = 0u;                                 // 红灯5s判定
    uint32_t disposition_H = (Get_Barometric_Threshold_High()); // 高阈值
    uint32_t disposition_L = (Get_Barometric_Threshold_Low());  // 低阈值
    static uint16_t Brake_pressureValid = 1u;                   // 电压有效判断0无效，1有效
    static uint16_t Brake_pressureValid_H = 0u;                 // 电阻有效判断H_L都为1有效，H_L为都为0无电阻输入，H_L为0_2或2_0无效
    static uint16_t Brake_pressureValid_L = 0u;
    uint32_t Data_Brake_Pressure_V = 0u;
    uint32_t Data_Brake_Pressure_R = 0u;
    /*** 气压上升表格 ***/
    static uint16_t DataBrake_PressureTable_Up[2] =
        /*显示段：|    0     |    1     |*/
        {45, 86};

    /*** 气压下降表格 ***/
    static uint16_t DataBrake_PressureTable_Dn[2] =
        /*显示段：|    0     |    1     |*/
        {40, 81};

    DataBrake_PressureTable_Up[0] = disposition_L + 5; // 配置的阈值赋值给数组
    DataBrake_PressureTable_Up[1] = disposition_H;
    DataBrake_PressureTable_Dn[0] = disposition_L;
    DataBrake_PressureTable_Dn[1] = disposition_H - 5;

    /*获取5次平均值*/
    brake_voltage_current = ADC_Read_Signal(ADC_CH_BRAKEAIRPRESSURE_VOLTAGE);
    Avg_brake_voltage += brake_voltage_current;
    brake_resistance_current = ADC_Read_Signal(ADC_CH_BRAKE_AIRPRESSURE);
    Avg_brake_resistance += brake_resistance_current;
    timerA++;
    if (timerA >= 5)
    {
        timerA = 0;
        Avg_brake_resistance /= 5;
        Avg_brake_voltage /= 5;
        brake_resistance = Avg_brake_resistance;
        brake_voltage = Avg_brake_voltage;
        Avg_brake_resistance = 0;
        Avg_brake_voltage = 0;
    }
    Data_Brake_Pressure_V = Brake_Pressure_Acquisition(brake_voltage);               // 制动气压电压换算成气压
    Data_Brake_Pressure_R = Brake_Pressure_Acquisition_Resistance(brake_resistance); // 制动气压电阻换算成气压
    if (brake_voltage >= 500)                                                        // 判断是电压否处于错误状态
    {
        Brake_pressureValid_H = 0;
        Brake_pressureValid_L = 0;
        if (brake_voltage >= 4800)
        {
            Brake_pressureValid = 0;
        }
        else if (brake_voltage > 4600)
        {
        }
        else
        {
            Brake_pressureValid = 1;
        }
    }
    else if (brake_voltage > 200)
    {
    }
    else // 判断是电阻否处于错误状态
    {
        Brake_pressureValid = 0;
        if ((brake_resistance == 0) || (brake_resistance == 0xFFFF) || (brake_resistance == 0x9999))
        {
            Brake_pressureValid_H = 0;
            Brake_pressureValid_L = 0;
        }
        else if (brake_resistance >= 3500)
        {
            Brake_pressureValid_H = 0;
            Brake_pressureValid_L = 2;
        }
        else if (brake_resistance > 3000)
        {
            if (Brake_pressureValid_L == 0)
            {
                Brake_pressureValid_L = 1;
            }
        }
        else if (brake_resistance >= 80)
        {
            Brake_pressureValid_H = 1;
            Brake_pressureValid_L = 1;
        }
        else if (brake_resistance > 20)
        {
            if (Brake_pressureValid_H == 0)
            {
                Brake_pressureValid_H = 1;
            }
        }
        else
        {
            Brake_pressureValid_H = 2;
            Brake_pressureValid_L = 0;
        }
    }

    if ((Brake_pressureValid == 0) && (brake_voltage <= 200))
    {
    }
    else if (Brake_pressureValid == 0)
    {
        LED_STATE = FLASH_SYNC_1Hz;
        led_brake_state_old1 = 1;
        led_brake_state_old = 0;
    }

    if ((Brake_pressureValid_H == 2 && Brake_pressureValid_L == 0) ||
        (Brake_pressureValid_H == 0 && Brake_pressureValid_L == 2))
    {
        LED_STATE = FLASH_SYNC_1Hz;
        led_brake_state_old1 = 1;
        led_brake_state_old = 0;
    }
    else
    {
        if (led_brake_state_old1 == 1)
        {
            LED_STATE = FLASH_SYNC_1Hz;
        }
    }
    if (Line_In_Get_Status(LINE_IN_BRAKEPRESSURE) != 1) // 判断硬线
    {
        if ((brake_voltage == 0) && ((brake_resistance == 0) || (brake_resistance == 0xFFFF))) // 硬线无效输入且电压电阻无输入
        {
            LED_STATE = FLASH_SYNC_1Hz;
            led_brake_state_old1 = 1;
            led_brake_state_old = 0;
        }
    }

    if (Brake_pressureValid) // 电压输入有效
    {
        if (Data_Brake_Pressure_V > P_DataBrakePressureCalc.Last_V) // 新电量高于前次电量,查上升表
        {
            while (P_DataBrakePressureCalc.DstSeg_V < 2)
            {
                if (Data_Brake_Pressure_V < DataBrake_PressureTable_Up[P_DataBrakePressureCalc.DstSeg_V])
                    break;
                P_DataBrakePressureCalc.DstSeg_V++;
            }
        }
        else if (Data_Brake_Pressure_V < P_DataBrakePressureCalc.Last_V) // 新电量低于前次电量,查下降表
        {
            while (P_DataBrakePressureCalc.DstSeg_V)
            {
                if (Data_Brake_Pressure_V > DataBrake_PressureTable_Dn[P_DataBrakePressureCalc.DstSeg_V - 1])
                    break;
                P_DataBrakePressureCalc.DstSeg_V--;
            }
        }

        P_DataBrakePressureCalc.Last_V = Data_Brake_Pressure_V;
    }
    if (brake_voltage > 200)
    {
        if (P_DataBrakePressureCalc.DstSeg_V != 1) // 红灯
        {
            if (led_brake_state_old == 1u)
            {
            }
            else
            {
                timer = 0;
            }
            if (timer >= 100)
            {
                LED_STATE = 1u;
                led_brake_state_old = 1u;
                led_brake_state_old1 = 0;
            }
            else
            {
                timer++;
                led_brake_state_old = 1u;
            }
        }
        else
        {
            if (P_DataBrakePressureCalc.DstSeg_V == 1) // 白灯
            {
                LED_STATE = 2u;
                led_brake_state_old = 0;
                led_brake_state_old1 = 0;
            }
        }
    }

    if ((Brake_pressureValid == 0) && ((Brake_pressureValid_H == 1) || (Brake_pressureValid_L == 1))) // 输入电压无效，电阻有效
    {
        if (Data_Brake_Pressure_R > P_DataBrakePressureCalc.Last_R) // 新电量高于前次电量,查上升表
        {
            while (P_DataBrakePressureCalc.DstSeg_R < 2)
            {
                if (Data_Brake_Pressure_R < DataBrake_PressureTable_Up[P_DataBrakePressureCalc.DstSeg_R])
                    break;
                P_DataBrakePressureCalc.DstSeg_R++;
            }
        }
        else if (Data_Brake_Pressure_R < P_DataBrakePressureCalc.Last_R) // 新电量低于前次电量,查下降表
        {
            while (P_DataBrakePressureCalc.DstSeg_R)
            {
                if (Data_Brake_Pressure_R > DataBrake_PressureTable_Dn[P_DataBrakePressureCalc.DstSeg_R - 1])
                    break;
                P_DataBrakePressureCalc.DstSeg_R--;
            }
        }

        P_DataBrakePressureCalc.Last_R = Data_Brake_Pressure_R;
    }
    if (brake_voltage <= 200 &&
        ((Brake_pressureValid_H == 1) ||
         (Brake_pressureValid_L == 1)))
    {
        if (P_DataBrakePressureCalc.DstSeg_R != 1) // 红灯
        {
            if (led_brake_state_old == 2u)
            {
            }
            else
            {
                timer = 0;
            }
            if (timer >= 100)
            {
                LED_STATE = 1u;
                led_brake_state_old = 2u;
                led_brake_state_old1 = 0;
            }
            else
            {
                timer++;
                led_brake_state_old = 3u;
            }
        }
        else
        {
            if (P_DataBrakePressureCalc.DstSeg_R == 1) // 白灯
            {
                LED_STATE = 2u;
                led_brake_state_old = 0;
                led_brake_state_old1 = 0;
            }
        }
    }

    if (Line_In_Get_Status(LINE_IN_BRAKEPRESSURE) == 1) // 判断硬线
    {
        if (led_brake_state_old1 != 1) // 判断是否为闪烁状态
        {
            if (led_brake_state_old == 5u)
            {
            }
            else
            {
                timer = 0;
            }
            if (timer >= 100)
            {
                LED_STATE = 1u;
                led_brake_state_old = 5u;
            }
            else
            {
                timer++;
                led_brake_state_old = 5u;
            }
        }
    }

    if (led_brake_state_old1 == 1) // 闪烁外发
    {
        Brake_Pressure_Flash_status = 1;
    }
    else
    {
        Brake_Pressure_Flash_status = 0;
    }

    return LED_STATE;
}
/*制动压力报警闪烁标志位*/
/*0有效状态，1闪烁*/
uint16_t Get_Brake_Pressure_status(void)
{
    return Brake_Pressure_Flash_status;
}

/*制动压力报警*/
/*湿式制动*/
/*0灭，1亮，0xff闪烁,2白灯*/
uint16_t Get_Wet_Brake_Pressure_Service(void)
{
    uint16_t LED_STATE = 2u;
    static uint16_t led_wetbrake_state_old1 = 0u; // 原状态：0红灯或白灯，1闪烁
    static uint32_t Wet_brake_voltage = 0u;       // 湿式电压
    static uint16_t timerA = 0;
    static uint16_t timer = 0;
    static uint16_t timerY = 0;
    uint32_t Wet_disposition_L = (Wet_Get_Barometric_Threshold_Low());
    static uint16_t Wet_Brake_pressureValid = 1u;

    /*获取5次平均值*/
    Wet_brake_voltage_current = ADC_Read_Signal(ADC_CH_WETBRAKE_VOLTAGE);
    Wet_Avg_brake_voltage += Wet_brake_voltage_current;
    timerA++;
    if (timerA >= 5)
    {
        timerA = 0;
        Wet_Avg_brake_voltage /= 5;
        Wet_brake_voltage = Wet_Avg_brake_voltage;
        Wet_Avg_brake_voltage = 0;
    }

    if (Wet_brake_voltage >= 500)
    {
        if (Wet_brake_voltage >= 4800)
        {
            Wet_Brake_pressureValid = 0;
        }
        else if (Wet_brake_voltage > 4600)
        {
        }
        else
        {
            Wet_Brake_pressureValid = 1;
        }
    }
    else if (Wet_brake_voltage > 200)
    {
    }
    else
    {
        Wet_Brake_pressureValid = 0;
    }

    if (Wet_Brake_pressureValid == 0)
    {
        LED_STATE = FLASH_SYNC_1Hz;
        led_wetbrake_state_old1 = 1;
        led_wetbrake_state_old = 0;
        timer = 0;
    }
    else
    {
        if (led_wetbrake_state_old1 == 1)
        {
            LED_STATE = FLASH_SYNC_1Hz;
        }
    }

    if (Wet_Brake_pressureValid)
    {
        if (Wet_Brake_Pressure_Acquisition(Wet_brake_voltage) >= Wet_disposition_L + 5) // 115bar时
        {
            LED_STATE = 2u;
            led_wetbrake_state_old1 = 0;
            if (Line_In_Get_Status(LINE_IN_BRAKEPRESSURE) != 1)
            {
                led_wetbrake_state_old = 0u;
                timer = 0;
            }
        }
        else if (Wet_Brake_Pressure_Acquisition(Wet_brake_voltage) > Wet_disposition_L) // 110bar
        {
            if (led_wetbrake_state_old == 1)
            {
                if (timer >= 100)
                {
                    LED_STATE = 1u;
                    led_wetbrake_state_old = 1u;
                    led_wetbrake_state_old1 = 0;
                }
                else
                {
                    timer++;
                    led_wetbrake_state_old = 1u;
                }
            }
            else
            {
                LED_STATE = 2u;
                led_wetbrake_state_old1 = 0;
                if (Line_In_Get_Status(LINE_IN_BRAKEPRESSURE) != 1)
                {
                    led_wetbrake_state_old = 0u;
                    timer = 0;
                }
            }
        }
        else
        {
            if (timer >= 100)
            {
                LED_STATE = 1u;
                led_wetbrake_state_old = 1u;
                led_wetbrake_state_old1 = 0;
            }
            else
            {
                timer++;
                led_wetbrake_state_old = 1u;
            }
        }
    }

    if (Line_In_Get_Status(LINE_IN_BRAKEPRESSURE) == 1) // 硬线输入
    {
        if (led_wetbrake_state_old1 != 1) // 判断是否为闪烁状态
        {

            if (timerY >= 100)
            {
                LED_STATE = 1u;
                led_wetbrake_state_old = 1u;
            }
            else
            {
                timerY++;
                led_wetbrake_state_old = 1u;
            }
        }
        else
        {
            timerY = 0;
        }
    }
    else
    {
        timerY = 0;
    }

    if (led_wetbrake_state_old1 == 1) // 闪烁外发
    {
        Brake_Wet_Pressure_Flash_status = 1;
    }
    else
    {
        Brake_Wet_Pressure_Flash_status = 0;
    }

    return LED_STATE;
}

/*制动压力报警闪烁标志位*/
/*湿式制动*/
/*0非闪烁状态，1闪烁*/
Tellib_uint16_t Get_Wet_Brake_Pressure_status(void)
{
    return Brake_Wet_Pressure_Flash_status;
}

/*制动压力报警红灯标志位*/
/*0其他状态，1红灯*/
uint16_t Get_Wet_Brake_Pressure_status_R(void)
{
    uint16_t Red_Brake_Pressure_Flash_status = 0;
    if(led_brake_state_old == 1 || led_brake_state_old == 2 || led_brake_state_old == 5 || led_wetbrake_state_old == 1)
    {
        Red_Brake_Pressure_Flash_status = 1;
    }
    else
    {
       Red_Brake_Pressure_Flash_status = 0; 
    }
    return Red_Brake_Pressure_Flash_status;
}
