#ifndef _CAN_APP_TX_H_
#define _CAN_APP_TX_H_

#include "TYW_stdint.h"



typedef union
{
    uint8_t Msg [ 8 ];
    struct
    {
        uint8_t Res0        : 8;
        uint8_t Res1        : 8;
        uint8_t Res2        : 8;
        uint8_t Res3        : 8;
        uint8_t Res4        : 8;
        uint8_t Res5        : 8;
        uint8_t IC_VSpeed_L : 8;
        uint8_t IC_VSpeed_H : 8;
    } Sig;
} CANMsg0CFE6C17Union;

typedef union
{
	uint8_t Msg [ 8 ];
    struct 
    {
        uint8_t                                 :8;
        uint8_t                                 :8;
        uint8_t                                 :8;
        uint8_t                                 :8;
        uint8_t                                 :8;
        uint8_t                                 :8;
        uint8_t IP_TachographVehicleSpeed_L     :8;
        uint8_t IP_TachographVehicleSpeed_H     :8;
    } Sig;
} CANMsg0CFE6CEEUnion;

typedef union
{
	uint8_t Msg [ 8 ];
    struct 
    {
        uint8_t IP_PGN_A            :8;
        uint8_t IP_PGN_B            :8;
        uint8_t IP_PGN_C            :8;
    } Sig;
} CANMsg18EA0017Union;

typedef union
{
	uint8_t Msg [ 8 ];
    struct 
    {
        uint8_t IP_PGN_A            :8;
        uint8_t IP_PGN_B            :8;
        uint8_t IP_PGN_C            :8;
    } Sig;
} CANMsg18EA0021Union;

typedef union
{
	uint8_t Msg [ 8 ];
    struct 
    {
        uint8_t                                     :8;
        uint8_t IP_HydraulicOilTemperature          :8;
    } Sig;
    
} CANMsg18FEFB17Union;

typedef union
{
	uint8_t Msg [ 8 ];
    struct 
    {
        uint8_t IP_Odometer_A                       : 8;
        uint8_t IP_Odometer_B                       : 8;
        uint8_t IP_Odometer_C                       : 8;
        uint8_t IP_Odometer_D                       : 8;
        uint8_t IP_AirPressureWarning               : 1;
        uint8_t IP_EngineOilPressureWarning         : 1;
        uint8_t IP_CoolantTemperatureHigh           : 2;
        uint8_t IP_EldingLevelLow                   : 2;
        uint8_t IP_TransmissionOilTemperatureHigh   : 2;
        uint8_t IP_ParkingBrake                     : 1;
        uint8_t IP_AirFilterBlocked                 : 1;
        uint8_t IP_AxleOilTemperature               : 1;
        uint8_t IP_TransmissionOilPressureWarning   : 1;
        uint8_t IP_PowerCutoff                      : 1;
        uint8_t IP_TransmissionOilFilter            : 1;
        uint8_t IP_FuelFilterBlocked                : 1;
        uint8_t IP_HydraulicOilTemperature          : 1;
        uint8_t IP_AxleFilterBlocked                : 1;
        uint8_t IP_WaterInFuelPreheating            : 1;
        uint8_t IP_HydraulicOilFilterBlocked        : 1;
        uint8_t IP_RadiatingOilFilterBlocked        : 1;
        uint8_t IP_TransmissionFailure              : 1;
        uint8_t IP_EngineStop                       : 1;
        uint8_t IP_CoolingFanReversal               : 1;
        uint8_t IP_ExhaustedGasTemperatureHigh      : 1;
        uint8_t IP_EmergencySteering                : 1;
        uint8_t IP_RegenerationIndicator            : 1;
        uint8_t IP_ForbiddenRegenerationIndicator   : 1;
        uint8_t IP_DEFResistanceHigh                : 1;
        uint8_t IP_AxleDifferentialLocked           : 1;
        uint8_t IP_AutoShiftGear                    : 1;
        uint8_t IP_Seatbelt                         : 1;
        uint8_t IP_CoolantLevelLow                  : 1;
    } Sig;
} CANMsg18FEB117Union;

typedef union
{
	uint8_t Msg [ 8 ];
    struct 
    {
        uint8_t                                     : 8;
        uint8_t IP_EldingLevelPercent               : 8;
        uint8_t IP_WetBrake                         : 8;
        uint8_t IP_AirPressure                      : 8;
        uint8_t IP_TransmissionOilTemperature_L     : 8;
        uint8_t IP_TransmissionOilTemperature_H     : 8;
    } Sig;
} CANMsg18057F17Union;



#endif
