#include "COM_CAN.h"
#include "TYW_stdint.h"
#include "CAN_CH0_CAN_Communication_Matrix.h"
#include "RTE_CAN.h"
#include "CAN_CFG.h"
#include "RSCAN.h"
#include <string.h>
#include "Common_Interface.h"

#pragma alignvar(8)
uint32_t pRXBuff [ CAN_RX_MSG_Block * CAN_CH0_ID_TOTAL_MAX ];
#pragma alignvar(8u)
uint32_t pTXBuff[CAN_TX_MSG_Block * CAN_CH0_ID_SEND_TOTAL];

void COM_CAN_Init(void)
{
    /*CAN APP BUFFER INIT*/
    memset(pRXBuff, 0, sizeof(pRXBuff));
    memset(pTXBuff, 0, sizeof(pTXBuff));
    CAN_CH0_CanMsgOp.CAN_MSG_Analysis = ( st_CANMsgStruct * )pRXBuff;
    CAN_CH0_CanMsgTxOp.CanMsg = ( st_CAN_SendOperation * )pTXBuff;
    Can_RX_BuffInit(&CAN_CH0_CanMsgOp, CAN_CH0_CAN_MSG_CONST_ARRAY, CAN_CH0_ID_TOTAL_MAX);
    Can_TX_BuffInit(&CAN_CH0_CanMsgTxOp, CAN_CH0_CANSendAttr, CAN_CH0_ID_SEND_TOTAL, COM_APP_Process);
}

void COM_RX_Process(void)
{
    CanMSg_XMS_Analysis(&CAN_CH0_CanMsgOp, 5u);
}
void COM_CAN_OPEN(void)
{
    CAN_TX_SetEnable(&CAN_CH0_CanMsgTxOp, CAN_N_TX_Enable);
    CAN_RX_SetEnable(&CAN_CH0_CanMsgOp, CAN_N_RX_Enable);
}

void COM_TX_Process(void)
{
    if ( Common_Get_IG_Sts( ) == COMMON_POWER_ON )
    {
        CAN_TX_SetEnable(&CAN_CH0_CanMsgTxOp, CAN_N_TX_Enable);
    }
    else
    {
        CAN_TX_SetEnable(&CAN_CH0_CanMsgTxOp, CAN_N_TX_Disable);
    }

    Can_Write_Fun(&CAN_CH0_CanMsgTxOp, 50u);
}
uint8_t COM_APP_Process(st_CAN_Msg *Msg)
{

    CAN_Frame_st_t m_msg;
    uint8_t        ret  = 0U;
    uint8_t        i    = 0U;
    m_msg.u32CANID      = Msg->MsgID;
    m_msg.u8CANFrameIDE = Msg->MsgStd;
    m_msg.u8CANLEN      = Msg->MsgDLC;

    for ( i = 0; i < m_msg.u8CANLEN; i++ )
    {
        m_msg.unCANData.u8CANData [ i ] = Msg->Msg [ i ];
    }
    ret = RSCAN0_CH4_Set_TXBUF_Data((RSCAN_Channel_Buf_en_t)(Msg->MsgPro), &m_msg);

    return ret;
}