#ifndef _DISPLAY_H_
#define _DISPLAY_H_

#include "TYW_stdint.h"

typedef struct
{
    uint16_t Goal;
    uint16_t OilTemperatureCurrent;
    uint16_t Time;
} TransmissionOilTemperature;
typedef struct
{
    uint16_t Goal;
    uint16_t BatteryVoltageCurrent;
    uint16_t Time;
} BatteryVoltage;
typedef struct
{
    uint16_t Voltage;
    uint16_t Status;
} Battery;

typedef struct
{
    uint16_t Goal;
    uint16_t UreaLevelCurrent;
    uint16_t Time;
} UreaLevel;
typedef struct
{
    uint16_t Goal;
    uint16_t OilPressureCurrent;
    uint16_t Time;
} OilPressure;
typedef struct
{
    uint16_t Goal;
    uint16_t FuelCurrent;
    uint16_t Time;
} Fuel;

typedef struct
{
    uint16_t Goal;
    uint16_t BrakeCurrent;
    uint16_t Time;
} BrakePressure;

typedef struct
{
    uint16_t Goal;
    uint16_t WetBrakeCurrent;
    uint16_t Time;
} WetBrakeStruct;


typedef struct
{
    uint16_t Goal;
    uint16_t HyOilTemCurrent;
    uint16_t Time;
} HydraulicOilTemperature;

typedef struct
{
    uint16_t Goal;
    uint16_t TransmisOilPreCurrent;
    uint16_t Time;
} TransmissionOilPressuree;

extern Fuel FuelCtrl;
extern OilPressure OilPressureCtrl;
extern TransmissionOilPressuree TransdraulicLevelCtrl;
extern BrakePressure BrakeCtrl;
extern HydraulicOilTemperature HydraulicLevelCtrl;
extern uint8_t Errostatus;  // 制动气压表0有效状态，1错误状态

void Display_KL30_Init(void);/*上电初始化*/
void Display_Wakeup_Init(void);/*上电初始化*/
void Display_KL15_Init(void);/*上电初始化*/
void Display_Transmission_Oil_Temperature_Gauge(void); //左侧小表头-变速箱油温表
void Display_Battery_Voltage_Gauge(void);  //电池电压表
uint32_t Get_Transmission_Oil_Temperature_Display(void);//获取左侧小表头-变速箱油温数值
uint32_t Get_Battery_Voltage_Display(void);//获取电池电压表数值
Battery Get_Battery_Voltage(void); //获取电池电压表数显
uint8_t Get_Display_Environment_Temperature(void); //获取环境温度表数显
uint8_t Get_Display_Urea_Level(void); //获取尿素液位
uint8_t Get_Fuel_Level(void);  //获取燃油液位
uint16_t Get_Display_Oil_Pressure(void); //获取机油压力
uint16_t Get_Display_Brake_Pressure(void); //获取制动压力表（左侧小表头）
uint16_t Get_Display_Wet_Brake(void); //获取湿式制动表显示
uint32_t Get_TOT_Fuel_Consumption(void); //获取总计油耗
uint32_t Get_Instantaneous_Fuel_Consumption(void); //获取瞬时油耗
uint32_t Get_Hydraulic_Oil_Temperature(void);//获取液压油温表数显
uint32_t Get_Transmission_Oil_Pressure_Display(void);//获取变速箱油压表数显
uint32_t Get_Display_Tire_Pressure(void);//胎压表（数显）
uint16_t Get_Display_Brake_Pressure_WrongS_Status(void);//获取制动气压表错误状态
void Fuel_Level(void);  //燃油液位
void Display_Brake_Pressure(void);  //制动气压
void Display_Oil_Pressure(void);  //机油压力
void Display_Battery_Voltage(void);  //电池电压表数显
void DisplayEnvironmentTemperature(void);  //环境温度
void Display_Urea_Level(void);  //尿素液位
void Display_Tire_Pressure(void);  //胎压数显
void Display_Wet_Brake(void); //湿式制动表
void TOT_Fuel_Consumption(void); //总计油耗
void Instantaneous_Fuel_Consumption(void); //瞬时油耗
void Display_Hydraulic_Oil_Temperature(void);//液压油温表
void Display_Transmission_Oil_Pressure(void);//变速箱油压表
void DisplayService(void);
void IC_Ctrl_2F(uint8_t Object, uint8_t Data);
void IC_Ctrl_Right(uint8_t Object, uint8_t Command);
void Display_Data_Init(void);
void Display_Data_Wakeup_Init(void);
void Animation(void);
void Animation_CB10ms(void);
void SET_LED_AUTO_TEST(void);
void Display_Factory_Ctrl(void);
void Display_Factory_Release(void);
uint8_t Get_Display_Factory(void);
uint16_t Get_AnimationStep_Timer(void);
#endif
