#include "CAN_CH0_CAN_Communication_Matrix.h"
#include "Services_Mileage_User.h"
#include "Services_Mileage.h"
#include "Popup_Message_List.h"
#include "Common_Interface.h"
#include "Popup_Scheduler.h"
#include "Popup_List.h"
#include "DisplaySch.h"
#include "Data_Gear.h"
#include "EOL_Para.h"
#include "Key.h"
#include "Popups.h"
#include "Telltales_user.h"

#pragma ghs section  bss = ".myNonInitArea"
UE_CtrlInfo_Struct_t UE_CtrlInfo;
#pragma ghs section  bss = default

static uint16_t DynamicPopupID       = POPUP_NONE;
static uint16_t UnlocSignalBackup    = 0;
static uint16_t PopupListOFF [ 128 ] = {0};
static uint8_t  PopupNumOFF          = 0;
static uint8_t  PopupCusorOFF        = 0;
static uint8_t  TelStatusBkp         = 0u;
static uint8_t  NaviStatusBkp        = 0u;
static uint8_t  PopupCurPage         = 0u;
static uint8_t SERVICE_TIME;
uint8_t LongTermClrFlg;

static void HMI_Main_Service(void);
static void HMI_Clear_KEY_Trip(void);

void Display_Schedule_KL30_Init(void)
{
    UE_CtrlInfo.HMI_Sys_Type                    = Disp_PowerOff;
    UE_CtrlInfo.HMI_MidOFF_Type                 = WinOFF_Car;
    UE_CtrlInfo.HMI_Alway_Type                  = WinAlway_Init;
    UE_CtrlInfo.HMI_Alway2_Type                 = WinAlway_Init;
    UE_CtrlInfo.HMI_KEYInfo.u8KEY_Enable        = 0u;
    UE_CtrlInfo.HMI_TIMER.u32StartAnim_Timer    = 0u;
    UE_CtrlInfo.HMI_TIMER.u32WelAnim_Timer      = 0u;
    UE_CtrlInfo.HMI_TIMER.u32StandyAnim_Timer   = 0u;
    UE_CtrlInfo.HMI_TIMER.u32SelfCheck_Timer    = DisplaySelfCheckTime;
    UE_CtrlInfo.HMI_TIMER.u32Standby_Timer      = 0u;
    UE_CtrlInfo.HMI_TIMER.u32Menu_Timer         = 0u;
    UE_CtrlInfo.HMI_TIMER.u32PowerOffAnim_Timer = 0u;
    UE_CtrlInfo.HMI_TIMER.u32SperialODO_Timer   = 0u;
    UE_CtrlInfo.HMI_TIMER.u32Tel_Timer          = 0u;
    UE_CtrlInfo.HMI_TIMER.u32Charge_Timer       = 0u;
    UE_CtrlInfo.HMI_TIMER.u32StandbyWait_Timer  = 0u;
    UE_CtrlInfo.HMI_TIMER.u32CarEnter_Timer     = 0u;
    UE_CtrlInfo.HMI_DriverDoorStatus            = 0u;
    UE_CtrlInfo.HMI_LockSts                     = 0u;
    UE_CtrlInfo.HMI_SleepStatus                 = 1u;
    UE_CtrlInfo.HMI_HUType                      = 0u;
    UE_CtrlInfo.HMI_MediaStatus                 = 0u;
    UE_CtrlInfo.HMI_NaviStatus                  = 0u;
    DynamicPopupID                              = POPUP_NONE;
    UnlocSignalBackup                           = 0;
    PopupCusorOFF                               = 0;
    PopupCurPage                                = 0u;
    TelStatusBkp                                = 0u;
    NaviStatusBkp                               = 0u;
    UE_CtrlInfo.HMI_Main_Type                = Disp_Max;
    UE_CtrlInfo.HMI_Menu_Current             = MAX_MenuPage;
    UE_CtrlInfo.HMI_DriveInfo_Current        = Disp_ODODis;
    LongTermClrFlg = 1;
}

void Display_Schedule_Wakeup_Init(void)
{
    UE_CtrlInfo.HMI_Sys_Type                    = Disp_PowerOff;
    UE_CtrlInfo.HMI_MidOFF_Type                 = WinOFF_Car;
    UE_CtrlInfo.HMI_KEYInfo.u8KEY_Enable        = 0u;
    UE_CtrlInfo.HMI_TIMER.u32StartAnim_Timer    = 0u;
    UE_CtrlInfo.HMI_TIMER.u32WelAnim_Timer      = 0u;
    UE_CtrlInfo.HMI_TIMER.u32StandyAnim_Timer   = 0u;
    UE_CtrlInfo.HMI_TIMER.u32SelfCheck_Timer    = DisplaySelfCheckTime;
    UE_CtrlInfo.HMI_TIMER.u32Standby_Timer      = 0u;
    UE_CtrlInfo.HMI_TIMER.u32Menu_Timer         = 0u;
    UE_CtrlInfo.HMI_TIMER.u32PowerOffAnim_Timer = 0u;
    UE_CtrlInfo.HMI_TIMER.u32SperialODO_Timer   = 0u;
    UE_CtrlInfo.HMI_TIMER.u32Tel_Timer          = 0u;
    UE_CtrlInfo.HMI_TIMER.u32Charge_Timer       = 0u;
    UE_CtrlInfo.HMI_TIMER.u32StandbyWait_Timer  = 0u;
    UE_CtrlInfo.HMI_TIMER.u32CarEnter_Timer     = 0u;
    UE_CtrlInfo.HMI_DriverDoorStatus            = 0u;
    UE_CtrlInfo.HMI_LockSts                     = 0u;
    UE_CtrlInfo.HMI_SleepStatus                 = 1u;
    UE_CtrlInfo.HMI_HUType                      = 0u;
    UE_CtrlInfo.HMI_MediaStatus                 = 0u;
    UE_CtrlInfo.HMI_NaviStatus                  = 0u;
    DynamicPopupID                              = POPUP_NONE;
    UnlocSignalBackup                           = 0;
    PopupCusorOFF                               = 0;
    PopupCurPage                                = 0u;
    TelStatusBkp                                = 0u;
    NaviStatusBkp                               = 0u;
    UE_CtrlInfo.HMI_Main_Type                = Disp_Max;
    UE_CtrlInfo.HMI_Menu_Current             = MAX_MenuPage;
    LongTermClrFlg = 0;
}

void Display_Schedule_Service(void)
{
    uint16_t PopupID           = POPUP_NONE;
    uint16_t PopupMsgID        = POPUP_MSG_NONE;
    uint8_t  UnlockTrigger     = 0u;
    uint8_t  PopupPage         = 0u;
    static uint8_t Time_100ms  = 0u;

    UE_CtrlInfo.HMI_PowerStatus = Common_Get_IG_Sts( );

    switch ( UE_CtrlInfo.HMI_Sys_Type )
    {
        case Disp_PowerOff:
            if(UE_CtrlInfo.HMI_PowerStatus == COMMON_POWER_ON)
            {
                Time_100ms++;
                if (Time_100ms >= 20)
                {
                    Time_100ms = 0;
                    UE_CtrlInfo.HMI_TIMER.u32StartAnim_Timer = 0u;
                    UE_CtrlInfo.HMI_SleepStatus              = 0u;
                    UnlocSignalBackup                        = 0u;
                    UE_CtrlInfo.HMI_TIMER.u32SelfCheck_Timer = 0u;
                    UE_CtrlInfo.HMI_Sys_Type                 = Disp_SelfCheck;
                }
            }
            else
            {
                Time_100ms = 0;
            }
            break;

        case Disp_SelfCheck:
            if ( UE_CtrlInfo.HMI_PowerStatus == COMMON_POWER_ON )
            {
                if (UE_CtrlInfo.HMI_TIMER.u32SelfCheck_Timer < DisplaySelfCheckTime)
                {
                    UE_CtrlInfo.HMI_TIMER.u32SelfCheck_Timer++;
                }
                else
                {
                    UE_CtrlInfo.HMI_TIMER.u32SelfCheck_Timer = DisplaySelfCheckTime;
                    UE_CtrlInfo.HMI_Sys_Type                 = Disp_SelfCheckFinish;
                }

            }
            else
            {
                UE_CtrlInfo.HMI_Sys_Type                  = Disp_PowerOff;
                UE_CtrlInfo.HMI_TIMER.u32SelfCheck_Timer  = DisplaySelfCheckTime;
            }
            break;

        case Disp_SelfCheckFinish:
            if ( UE_CtrlInfo.HMI_PowerStatus == COMMON_POWER_ON )
            {
                HMI_Main_Service( );
            }
            else
            {
                UE_CtrlInfo.HMI_Sys_Type                  = Disp_PowerOff;
                UE_CtrlInfo.HMI_KEYInfo.u8KEY_Enable      = 0u;
            }
            break;

        default:
            break;
    }

}

/*键值设置*/
void HMI_Set_KEY_Trip(uint8_t u8KeyVal)
{
    UE_CtrlInfo.HMI_KEYInfo.u8KEY_Enable = u8KeyVal;
}

uint8_t Get_HMI_KEY_Control(void)
{
    return UE_CtrlInfo.HMI_KEYInfo.u8KEY_Enable;
}




static void HMI_Main_Service(void)
{
    // if ( UE_CtrlInfo.HMI_Main_Type != Disp_Menu )
    {
        if ( UE_CtrlInfo.HMI_KEYInfo.u8KEY_Enable == KEY_EVENT_LONG_PRESS )
        {
            UE_CtrlInfo.HMI_Main_Type           = Disp_Menu;
            if(UE_CtrlInfo.HMI_DriveInfo_Current == Disp_TripDis)
            {
                UE_CtrlInfo.HMI_Menu_Current        = Disp_Trip;
            }
            else if(UE_CtrlInfo.HMI_DriveInfo_Current == Disp_AvgEnergyDis)
            {
                UE_CtrlInfo.HMI_Menu_Current        = Disp_AvgEnergy;
            }
            UE_CtrlInfo.HMI_TIMER.u32Menu_Timer = DisplayMenuTime;
        }
        else if ( UE_CtrlInfo.HMI_KEYInfo.u8KEY_Enable == KEY_EVENT_SHORT_PRESS )
        {
            UE_CtrlInfo.HMI_Menu_Current        = MAX_MenuPage;
            UE_CtrlInfo.HMI_DriveInfo_Current++;
            if ( UE_CtrlInfo.HMI_DriveInfo_Current >= MAX_DriveInfoPage )
            {
                UE_CtrlInfo.HMI_DriveInfo_Current = Disp_ODODis;
            }
            UE_CtrlInfo.HMI_DriveInfo_Last = Disp_ODODis;
            HMI_Clear_KEY_Trip( );
        }
    }
    // else
    {
        // if ( UE_CtrlInfo.HMI_TIMER.u32Menu_Timer != 0u )
        {
            if ( UE_CtrlInfo.HMI_Menu_Current == Disp_Trip )
            {
                if ( UE_CtrlInfo.HMI_KEYInfo.u8KEY_Enable == KEY_EVENT_LONG_PRESS )
                {
                    HMI_Clear_KEY_Trip( );
                    Data_Clear_Trip(EM_TRIP_A);
                }
            }
            else if(UE_CtrlInfo.HMI_Menu_Current == Disp_AvgEnergy)
            {
                if(UE_CtrlInfo.HMI_KEYInfo.u8KEY_Enable == KEY_EVENT_LONG_PRESS)
                {
                    HMI_Clear_KEY_Trip( );
                    LongTermClrFlg = 1;
                }
            }
        }
    }
}

uint8_t Get_HMI_DriveInfo_Type(void)
{
    return UE_CtrlInfo.HMI_DriveInfo_Current;
}

uint8_t Get_LongTermClrFlg_Clear(void)
{
    return LongTermClrFlg;
}
void Set_LongTermClrFlg_Clear(uint8_t m_Long)
{
    LongTermClrFlg = m_Long;
}




/*清键值*/
static void HMI_Clear_KEY_Trip(void)
{
    UE_CtrlInfo.HMI_KEYInfo.u8KEY_Enable = 0u;
}

uint32_t Get_HMI_SelfCheck_Timer(void)
{
    uint32_t SelfCheckTime = 0;

    SelfCheckTime = UE_CtrlInfo.HMI_TIMER.u32SelfCheck_Timer * 10;

    return SelfCheckTime;
}

uint32_t Get_MenuInto_Item(void)
{
    return UE_CtrlInfo.HMI_Menu_Type;
}

enDispSys_Type_t Get_HMI_Sys_Type(void)
{
    return UE_CtrlInfo.HMI_Sys_Type;
}
