#include "EOL_Para.h"
#include "UDS_Common.h"
#pragma ghs section bss = ".myNonInitArea"
_EOL_0300           EOL_0300;
_EOL_0301           EOL_0301;
#pragma ghs section bss = default

void EOL_0300_InitVal(void)
{
    EOL0300ToDFlashInfo.Flag = 0x7AA7A55Au;
    EOL0300ToDFlashInfo.DID_0300[0] = 0x01;
    EOL0300ToDFlashInfo.DID_0300[1] = 0x01;
    EOL0300ToDFlashInfo.DID_0300[2] = 0x01;
    EOL0300ToDFlashInfo.DID_0300[3] = 0x01;
    EOL0300ToDFlashInfo.DID_0300[4] = 0x00;
    EOL0300ToDFlashInfo.DID_0300[5] = 0x00;
    EOL0300ToDFlashInfo.DID_0300[6] = 0x01;
    EOL0300ToDFlashInfo.DID_0300[7] = 0x00;
    EOL0300ToDFlashInfo.DID_0300[8] = 0x00;
    EOL0300ToDFlashInfo.DID_0300[9] = 0x01;
    EOL0300ToDFlashInfo.DID_0300[10] = 0x00;
    EOL0300ToDFlashInfo.DID_0300[11] = 0x64;
    EOL0300ToDFlashInfo.DID_0300[12] = 0x01;
    EOL0300ToDFlashInfo.DID_0300[13] = 0xF4;
    EOL0300ToDFlashInfo.DID_0300[14] = 0x00;
    EOL0300ToDFlashInfo.DID_0300[15] = 0x12;
    EOL0300ToDFlashInfo.DID_0300[16] = 0x00;
    EOL0300ToDFlashInfo.DID_0300[17] = 0x00;
    EOL0300ToDFlashInfo.DID_0300[18] = 0x4B;
    EOL0300ToDFlashInfo.DID_0300[19] = 0xA4;
    EOL0300ToDFlashInfo.DID_0300[20] = 0x00;
    EOL0300ToDFlashInfo.DID_0300[21] = 0xC3;
    EOL0300ToDFlashInfo.DID_0300[22] = 0x6E;
    EOL0300ToDFlashInfo.DID_0300[23] = 0x91;
    EOL0300ToDFlashInfo.DID_0300[24] = 0xAA;
    EOL0300ToDFlashInfo.DID_0300[25] = 0x82;
    EOL0300ToDFlashInfo.DID_0300[26] = 0x0A;
    EOL0300ToDFlashInfo.DID_0300[27] = 0x01;
    EOL0300ToDFlashInfo.DID_0300[28] = 0x01;
    EOL0300ToDFlashInfo.DID_0300[29] = 0x01;
    EOL0300ToDFlashInfo.DID_0300[40] = 0x01;
    EOL0300ToDFlashInfo.DID_0300[41] = 0x00;
    EOL0300ToDFlashInfo.DID_0300[42] = 0x00;
    EOL0300ToDFlashInfo.DID_0300[43] = 0x64;
    EOL0300ToDFlashInfo.DID_0300[44] = 0x00;
    EOL0300ToDFlashInfo.DID_0300[45] = 0xD7;
    EOL0300ToDFlashInfo.DID_0300[46] = 0x0A;
    EOL0300ToDFlashInfo.DID_0300[47] = 0xBE;
    EOL0300ToDFlashInfo.DID_0300[48] = 0x00;
    EOL0300ToDFlashInfo.DID_0300[49] = 0x00;
    EOL0300ToDFlashInfo.DID_0300[50] = 0x01;
    EOL0300ToDFlashInfo.DID_0300[51] = 0x90;
    EOL0300ToDFlashInfo.DID_0300[52] = 0x02;
    EOL0300ToDFlashInfo.DID_0300[53] = 0x58;
    EOL0300ToDFlashInfo.DID_0300[54] = 0x04;
    EOL0300ToDFlashInfo.DID_0300[55] = 0xE2;
    EOL0300ToDFlashInfo.DID_0300[56] = 0x00;
    EOL0300ToDFlashInfo.DID_0300[57] = 0xC8;
    EOL0300ToDFlashInfo.DID_0300[58] = 0x01;
    EOL0300ToDFlashInfo.DID_0300[59] = 0x2C;
    EOL0300ToDFlashInfo.DID_0300[60] = 0x01;
    EOL0300ToDFlashInfo.DID_0300[61] = 0x01;
    EOL0300ToDFlashInfo.DID_0300[62] = 0x01;
    EOL0300ToDFlashInfo.DID_0300[63] = 0x00;
    EOL0300ToDFlashInfo.DID_0300[64] = 0x00;
    EOL0300ToDFlashInfo.DID_0300[65] = 0x01;
    EOL0300ToDFlashInfo.DID_0300[66] = 0x04;
    EOL0300ToDFlashInfo.DID_0300[67] = 0x02;
    EOL0300ToDFlashInfo.DID_0300[68] = 0x02;
    EOL0300ToDFlashInfo.DID_0300[69] = 0x01;
    EOL0300ToDFlashInfo.DID_0300[70] = 0x01;
    EOL0300ToDFlashInfo.DID_0300[71] = 0x00;
    EOL0300ToDFlashInfo.DID_0300[72] = 0x00;
    EOL0300ToDFlashInfo.DID_0300[73] = 0x00;
    EOL0300ToDFlashInfo.DID_0300[74] = 0x00;
    EOL0300ToDFlashInfo.DID_0300[75] = 0x00;
    EOL0300ToDFlashInfo.DID_0300[76] = 0x00;
    EOL0300ToDFlashInfo.DID_0300[77] = 0x00;
    EOL0300ToDFlashInfo.DID_0300[78] = 0x00;
    EOL0300ToDFlashInfo.DID_0300[79] = 0x00;
    EOL0300ToDFlashInfo.DID_0300[80] = 0x00;
    EOL0300ToDFlashInfo.DID_0300[81] = 0x00;
    EOL0300ToDFlashInfo.DID_0300[82] = 0x00;
    EOL0300ToDFlashInfo.DID_0300[83] = 0x00;
    EOL0300ToDFlashInfo.DID_0300[84] = 0x01;
    EOL0300ToDFlashInfo.DID_0300[85] = 0x00;
    EOL0300ToDFlashInfo.DID_0300[86] = 0x00;
    EOL0300ToDFlashInfo.DID_0300[87] = 0x00;
    EOL0300ToDFlashInfo.DID_0300[88] = 0x00;
    EOL0300ToDFlashInfo.DID_0300[89] = 0x00;

}

void EOL_0301_InitVal(void)
{
    EOL0301ToDFlashInfo.Flag = 0x7AA7A55Au;
    EOL0301ToDFlashInfo.DID_0301[0]=0x71;
    EOL0301ToDFlashInfo.DID_0301[1]=0xDA;
    EOL0301ToDFlashInfo.DID_0301[2]=0x34;
    EOL0301ToDFlashInfo.DID_0301[3]=0x5B;
    EOL0301ToDFlashInfo.DID_0301[4]=0x1B;
    EOL0301ToDFlashInfo.DID_0301[5]=0x64;
    EOL0301ToDFlashInfo.DID_0301[6]=0x0F;
    EOL0301ToDFlashInfo.DID_0301[7]=0x07;
    EOL0301ToDFlashInfo.DID_0301[8]=0x08;
    EOL0301ToDFlashInfo.DID_0301[9]=0xC4;
    EOL0301ToDFlashInfo.DID_0301[10]=0x08;
    EOL0301ToDFlashInfo.DID_0301[11]=0xC4;
    EOL0301ToDFlashInfo.DID_0301[12]=0x08;
    EOL0301ToDFlashInfo.DID_0301[13]=0xC4;
    EOL0301ToDFlashInfo.DID_0301[14]=0x00;
    EOL0301ToDFlashInfo.DID_0301[15]=0x50;
    EOL0301ToDFlashInfo.DID_0301[16]=0x00;
    EOL0301ToDFlashInfo.DID_0301[17]=0x64;
    EOL0301ToDFlashInfo.DID_0301[18]=0x00;
    EOL0301ToDFlashInfo.DID_0301[19]=0x78;
    EOL0301ToDFlashInfo.DID_0301[20]=0x00;
    EOL0301ToDFlashInfo.DID_0301[21]=0x8C;
    EOL0301ToDFlashInfo.DID_0301[22]=0x00;
    EOL0301ToDFlashInfo.DID_0301[23]=0xA0;
    EOL0301ToDFlashInfo.DID_0301[24]=0x00;
    EOL0301ToDFlashInfo.DID_0301[25]=0xA0;
    EOL0301ToDFlashInfo.DID_0301[26]=0x00;
    EOL0301ToDFlashInfo.DID_0301[27]=0xA0;
    EOL0301ToDFlashInfo.DID_0301[28]=0x00;
    EOL0301ToDFlashInfo.DID_0301[29]=0x00;
    EOL0301ToDFlashInfo.DID_0301[30]=0x0C;
    EOL0301ToDFlashInfo.DID_0301[31]=0xE4;
    EOL0301ToDFlashInfo.DID_0301[32]=0x16;
    EOL0301ToDFlashInfo.DID_0301[33]=0x44;
    EOL0301ToDFlashInfo.DID_0301[34]=0x23;
    EOL0301ToDFlashInfo.DID_0301[35]=0x8C;
    EOL0301ToDFlashInfo.DID_0301[36]=0x30;
    EOL0301ToDFlashInfo.DID_0301[37]=0xC0;
    EOL0301ToDFlashInfo.DID_0301[38]=0x44;
    EOL0301ToDFlashInfo.DID_0301[39]=0xC0;
    EOL0301ToDFlashInfo.DID_0301[40]=0x46;
    EOL0301ToDFlashInfo.DID_0301[41]=0x50;
    EOL0301ToDFlashInfo.DID_0301[42]=0x00;
    EOL0301ToDFlashInfo.DID_0301[43]=0x00;
    EOL0301ToDFlashInfo.DID_0301[44]=0x04;
    EOL0301ToDFlashInfo.DID_0301[45]=0xE2;
    EOL0301ToDFlashInfo.DID_0301[46]=0x09;
    EOL0301ToDFlashInfo.DID_0301[47]=0xC4;
    EOL0301ToDFlashInfo.DID_0301[48]=0x13;
    EOL0301ToDFlashInfo.DID_0301[49]=0x88;
    EOL0301ToDFlashInfo.DID_0301[50]=0x1D;
    EOL0301ToDFlashInfo.DID_0301[51]=0x4C;
    EOL0301ToDFlashInfo.DID_0301[52]=0x27;
    EOL0301ToDFlashInfo.DID_0301[53]=0x10;
    EOL0301ToDFlashInfo.DID_0301[54]=0x27;
    EOL0301ToDFlashInfo.DID_0301[55]=0x10;
    EOL0301ToDFlashInfo.DID_0301[56]=0x71;
    EOL0301ToDFlashInfo.DID_0301[57]=0xD3;
    EOL0301ToDFlashInfo.DID_0301[58]=0x5E;
    EOL0301ToDFlashInfo.DID_0301[59]=0xA9;
    EOL0301ToDFlashInfo.DID_0301[60]=0x30;
    EOL0301ToDFlashInfo.DID_0301[61]=0x0C;
    EOL0301ToDFlashInfo.DID_0301[62]=0x1A;
    EOL0301ToDFlashInfo.DID_0301[63]=0x79;
    EOL0301ToDFlashInfo.DID_0301[64]=0x0F;
    EOL0301ToDFlashInfo.DID_0301[65]=0x99;
    EOL0301ToDFlashInfo.DID_0301[66]=0x09;
    EOL0301ToDFlashInfo.DID_0301[67]=0xAF;
    EOL0301ToDFlashInfo.DID_0301[68]=0x09;
    EOL0301ToDFlashInfo.DID_0301[69]=0xAF;
    EOL0301ToDFlashInfo.DID_0301[70]=0x00;
    EOL0301ToDFlashInfo.DID_0301[71]=0x69;
    EOL0301ToDFlashInfo.DID_0301[72]=0x00;
    EOL0301ToDFlashInfo.DID_0301[73]=0x6E;
    EOL0301ToDFlashInfo.DID_0301[74]=0x00;
    EOL0301ToDFlashInfo.DID_0301[75]=0x82;
    EOL0301ToDFlashInfo.DID_0301[76]=0x00;
    EOL0301ToDFlashInfo.DID_0301[77]=0xA0;
    EOL0301ToDFlashInfo.DID_0301[78]=0x00;
    EOL0301ToDFlashInfo.DID_0301[79]=0xAA;
    EOL0301ToDFlashInfo.DID_0301[80]=0x00;
    EOL0301ToDFlashInfo.DID_0301[81]=0xBE;
    EOL0301ToDFlashInfo.DID_0301[82]=0x00;
    EOL0301ToDFlashInfo.DID_0301[83]=0xBE;
    EOL0301ToDFlashInfo.DID_0301[84]=0x03;
    EOL0301ToDFlashInfo.DID_0301[85]=0xE8;
    EOL0301ToDFlashInfo.DID_0301[86]=0x12;
    EOL0301ToDFlashInfo.DID_0301[87]=0xC0;
    EOL0301ToDFlashInfo.DID_0301[88]=0x23;
    EOL0301ToDFlashInfo.DID_0301[89]=0x28;
    EOL0301ToDFlashInfo.DID_0301[90]=0x30;
    EOL0301ToDFlashInfo.DID_0301[91]=0x70;
    EOL0301ToDFlashInfo.DID_0301[92]=0x3C;
    EOL0301ToDFlashInfo.DID_0301[93]=0xF0;
    EOL0301ToDFlashInfo.DID_0301[94]=0x47;
    EOL0301ToDFlashInfo.DID_0301[95]=0xE0;
    EOL0301ToDFlashInfo.DID_0301[96]=0x47;
    EOL0301ToDFlashInfo.DID_0301[97]=0xE0;
    EOL0301ToDFlashInfo.DID_0301[98]=0x00;
    EOL0301ToDFlashInfo.DID_0301[99]=0x00;
    EOL0301ToDFlashInfo.DID_0301[100]=0x00;
    EOL0301ToDFlashInfo.DID_0301[101]=0xC8;
    EOL0301ToDFlashInfo.DID_0301[102]=0x01;
    EOL0301ToDFlashInfo.DID_0301[103]=0x90;
    EOL0301ToDFlashInfo.DID_0301[104]=0x02;
    EOL0301ToDFlashInfo.DID_0301[105]=0x58;
    EOL0301ToDFlashInfo.DID_0301[106]=0x03;
    EOL0301ToDFlashInfo.DID_0301[107]=0x20;
    EOL0301ToDFlashInfo.DID_0301[108]=0x03;
    EOL0301ToDFlashInfo.DID_0301[109]=0xE8;
    EOL0301ToDFlashInfo.DID_0301[110]=0x03;
    EOL0301ToDFlashInfo.DID_0301[111]=0xE8;
    EOL0301ToDFlashInfo.DID_0301[112]=0x01;
    EOL0301ToDFlashInfo.DID_0301[113]=0xF4;
    EOL0301ToDFlashInfo.DID_0301[114]=0x04;
    EOL0301ToDFlashInfo.DID_0301[115]=0x14;
    EOL0301ToDFlashInfo.DID_0301[116]=0x06;
    EOL0301ToDFlashInfo.DID_0301[117]=0x34;
    EOL0301ToDFlashInfo.DID_0301[118]=0x08;
    EOL0301ToDFlashInfo.DID_0301[119]=0x55;
    EOL0301ToDFlashInfo.DID_0301[120]=0x0A;
    EOL0301ToDFlashInfo.DID_0301[121]=0x75;
    EOL0301ToDFlashInfo.DID_0301[122]=0x0C;
    EOL0301ToDFlashInfo.DID_0301[123]=0x95;
    EOL0301ToDFlashInfo.DID_0301[124]=0x0C;
    EOL0301ToDFlashInfo.DID_0301[125]=0x95;
    EOL0301ToDFlashInfo.DID_0301[126]=0x00;
    EOL0301ToDFlashInfo.DID_0301[127]=0x00;
    EOL0301ToDFlashInfo.DID_0301[128]=0x00;
    EOL0301ToDFlashInfo.DID_0301[129]=0xC8;
    EOL0301ToDFlashInfo.DID_0301[130]=0x01;
    EOL0301ToDFlashInfo.DID_0301[131]=0x90;
    EOL0301ToDFlashInfo.DID_0301[132]=0x02;
    EOL0301ToDFlashInfo.DID_0301[133]=0x58;
    EOL0301ToDFlashInfo.DID_0301[134]=0x03;
    EOL0301ToDFlashInfo.DID_0301[135]=0x20;
    EOL0301ToDFlashInfo.DID_0301[136]=0x03;
    EOL0301ToDFlashInfo.DID_0301[137]=0xE8;
    EOL0301ToDFlashInfo.DID_0301[138]=0x03;
    EOL0301ToDFlashInfo.DID_0301[139]=0xE8;
    EOL0301ToDFlashInfo.DID_0301[140]=0x00;
    EOL0301ToDFlashInfo.DID_0301[141]=0x00;
    EOL0301ToDFlashInfo.DID_0301[142]=0x03;
    EOL0301ToDFlashInfo.DID_0301[143]=0xE8;
    EOL0301ToDFlashInfo.DID_0301[144]=0x07;
    EOL0301ToDFlashInfo.DID_0301[145]=0xD0;
    EOL0301ToDFlashInfo.DID_0301[146]=0x0B;
    EOL0301ToDFlashInfo.DID_0301[147]=0xB8;
    EOL0301ToDFlashInfo.DID_0301[148]=0x0F;
    EOL0301ToDFlashInfo.DID_0301[149]=0xA0;
    EOL0301ToDFlashInfo.DID_0301[150]=0x13;
    EOL0301ToDFlashInfo.DID_0301[151]=0x88;
    EOL0301ToDFlashInfo.DID_0301[152]=0x13;
    EOL0301ToDFlashInfo.DID_0301[153]=0x88;
    EOL0301ToDFlashInfo.DID_0301[154]=0x00;
    EOL0301ToDFlashInfo.DID_0301[155]=0x00;
    EOL0301ToDFlashInfo.DID_0301[156]=0x0F;
    EOL0301ToDFlashInfo.DID_0301[157]=0xA0;
    EOL0301ToDFlashInfo.DID_0301[158]=0x1F;
    EOL0301ToDFlashInfo.DID_0301[159]=0x40;
    EOL0301ToDFlashInfo.DID_0301[160]=0x2E;
    EOL0301ToDFlashInfo.DID_0301[161]=0xE0;
    EOL0301ToDFlashInfo.DID_0301[162]=0x3E;
    EOL0301ToDFlashInfo.DID_0301[163]=0x80;
    EOL0301ToDFlashInfo.DID_0301[164]=0x4E;
    EOL0301ToDFlashInfo.DID_0301[165]=0x20;
    EOL0301ToDFlashInfo.DID_0301[166]=0x4E;
    EOL0301ToDFlashInfo.DID_0301[167]=0x20;
    EOL0301ToDFlashInfo.DID_0301[168]=0x00;
    EOL0301ToDFlashInfo.DID_0301[169]=0x64;
    EOL0301ToDFlashInfo.DID_0301[170]=0x03;
    EOL0301ToDFlashInfo.DID_0301[171]=0x52;
    EOL0301ToDFlashInfo.DID_0301[172]=0x06;
    EOL0301ToDFlashInfo.DID_0301[173]=0x40;
    EOL0301ToDFlashInfo.DID_0301[174]=0x09;
    EOL0301ToDFlashInfo.DID_0301[175]=0x2E;
    EOL0301ToDFlashInfo.DID_0301[176]=0x0C;
    EOL0301ToDFlashInfo.DID_0301[177]=0x1C;
    EOL0301ToDFlashInfo.DID_0301[178]=0x0F;
    EOL0301ToDFlashInfo.DID_0301[179]=0x0A;
    EOL0301ToDFlashInfo.DID_0301[180]=0x0F;
    EOL0301ToDFlashInfo.DID_0301[181]=0x0A;
    EOL0301ToDFlashInfo.DID_0301[182]=0x00;
    EOL0301ToDFlashInfo.DID_0301[183]=0x00;
    EOL0301ToDFlashInfo.DID_0301[184]=0x01;
    EOL0301ToDFlashInfo.DID_0301[185]=0xF4;
    EOL0301ToDFlashInfo.DID_0301[186]=0x03;
    EOL0301ToDFlashInfo.DID_0301[187]=0xE8;
    EOL0301ToDFlashInfo.DID_0301[188]=0x05;
    EOL0301ToDFlashInfo.DID_0301[189]=0xDC;
    EOL0301ToDFlashInfo.DID_0301[190]=0x07;
    EOL0301ToDFlashInfo.DID_0301[191]=0xD0;
    EOL0301ToDFlashInfo.DID_0301[192]=0x09;
    EOL0301ToDFlashInfo.DID_0301[193]=0xC4;
    EOL0301ToDFlashInfo.DID_0301[194]=0x09;
    EOL0301ToDFlashInfo.DID_0301[195]=0xC4;
    EOL0301ToDFlashInfo.DID_0301[196]=0x00;
    EOL0301ToDFlashInfo.DID_0301[197]=0x00;
    EOL0301ToDFlashInfo.DID_0301[198]=0x00;
    EOL0301ToDFlashInfo.DID_0301[199]=0x00;
    EOL0301ToDFlashInfo.DID_0301[200]=0x00;
    EOL0301ToDFlashInfo.DID_0301[201]=0x00;
    EOL0301ToDFlashInfo.DID_0301[202]=0x00;
    EOL0301ToDFlashInfo.DID_0301[203]=0x00;
    EOL0301ToDFlashInfo.DID_0301[204]=0x00;
    EOL0301ToDFlashInfo.DID_0301[205]=0x00;
    EOL0301ToDFlashInfo.DID_0301[206]=0x00;
    EOL0301ToDFlashInfo.DID_0301[207]=0x00;
    EOL0301ToDFlashInfo.DID_0301[208]=0x00;
    EOL0301ToDFlashInfo.DID_0301[209]=0x00;
    EOL0301ToDFlashInfo.DID_0301[210]=0x00;
    EOL0301ToDFlashInfo.DID_0301[211]=0x00;
    EOL0301ToDFlashInfo.DID_0301[212]=0x00;
    EOL0301ToDFlashInfo.DID_0301[213]=0x00;
    EOL0301ToDFlashInfo.DID_0301[214]=0x00;
    EOL0301ToDFlashInfo.DID_0301[215]=0x00;
    EOL0301ToDFlashInfo.DID_0301[216]=0x00;
    EOL0301ToDFlashInfo.DID_0301[217]=0x00;
    EOL0301ToDFlashInfo.DID_0301[218]=0x00;
    EOL0301ToDFlashInfo.DID_0301[219]=0x00;
    EOL0301ToDFlashInfo.DID_0301[220]=0x00;
    EOL0301ToDFlashInfo.DID_0301[221]=0x00;
    EOL0301ToDFlashInfo.DID_0301[222]=0x00;
    EOL0301ToDFlashInfo.DID_0301[223]=0x00;

}

void EOL_Set0300(uint8_t EOL [], uint8_t len)
{
    uint8_t i;

    if ( len == 90u )
    {
        for ( i = 0u; i < sizeof(EOL_0300); i++ )
        {
            EOL_0300.Data [ i ] = EOL [ i ];
        }
    }
}

void EOL_Set0301(uint8_t EOL [], uint8_t len)
{
    uint8_t i;

    if ( len == 224u )
    {
        for ( i = 0u; i < sizeof(EOL_0301); i++ )
        {
            EOL_0301.Data [ i ] = EOL [ i ];
        }
    }
}

_EOL_0300 EOL_Get0300(void)
{
    return EOL_0300;
}

_EOL_0301 EOL_Get0301(void)
{
    return EOL_0301;
}

/*0300*/
/*BYTE0
 *0: LS 低有效
 *1: HS 高有效
 */
uint8_t Val_EOL_0300_Power_Cutoff(void)
{
    return (EOL_0300.Data [ 0u ] >> 0u) & 0xFFu;
}

/*BYTE1*/
uint8_t Val_EOL_0300_Netural(void)
{
    return (EOL_0300.Data [ 1u ] >> 0u) & 0xFFu;
}

/*BYTE2*/
uint8_t Val_EOL_0300_Transmission_Failure(void)
{
    return (EOL_0300.Data [ 2u ] >> 0u) & 0xFFu;
}

/*BYTE3*/
uint8_t Val_EOL_0300_Auto_Shift_Gear(void)
{
    return (EOL_0300.Data [ 3u ] >> 0u) & 0xFFu;
}

/*BYTE4*/
uint8_t Val_EOL_0300_Transmission_Oil_Filte(void)
{
    return (EOL_0300.Data [ 4u ] >> 0u) & 0xFFu;
}

/*BYTE5*/
uint8_t Val_EOL_0300_Engine_Preheating(void)
{
    return (EOL_0300.Data [ 5u ] >> 0u) & 0xFFu;
}

/*BYTE6*/
uint8_t Val_EOL_0300_Failure_Warning(void)
{
    return (EOL_0300.Data [ 6u ] >> 0u) & 0xFFu;
}

/*BYTE7*/
uint8_t Val_EOL_0300_Parking_Brake(void)
{
    return (EOL_0300.Data [ 7u ] >> 0u) & 0xFFu;
}

/*BYTE8
 *0: Chinese 中文
 *1: English 英语
 *2: Russian 俄语
 *3: Portuguese 葡萄牙语
*/
uint8_t Val_EOL_0300_IC_Language_Configuration(void)
{
    return (EOL_0300.Data [ 8u ] >> 0u) & 0xFFu;
}

/*BYTE9*/
uint8_t Val_EOL_0300_Maintenance_Service_Enable_Configuration(void)
{
    return (EOL_0300.Data [ 9u ] >> 0u) & 0xFFu;
}

/*BYTE10 ~ BYTE11
 *首保时间配置
 *Range 范围: 1 ~ 3000 h
 *Resolution 分辨率: 1 h
*/
uint16_t Val_EOL_0300_First_Maintenance_Time_Configuration(void)
{
    uint16_t Value = 0;
    Value = EOL_0300.Data [ 10u ];
    Value = Value << 8u;
    Value = Value | EOL_0300.Data [ 11u ];
    return Value;
}

/*BYTE12 ~ BYTE13
 *续保间隔时间配置
 *Range 范围: 1 ~ 3000 h
 *Resolution 分辨率: 1 h
*/
uint16_t Val_EOL_0300_Renewal_Maintenance_Interval_Time_Configuration(void)
{
    uint16_t Value = 0;
    Value = EOL_0300.Data [ 12u ];
    Value = Value << 8u;
    Value = Value | EOL_0300.Data [ 13u ];
    return Value;
}

/*BYTE14 ~ BYTE15
 *机油压力低阈值配置
 *Range 范围: 0.04 ~ 2621.4 bar
 *Resolution 分辨率: 4 kpa / bit
*/
uint16_t Val_EOL_0300_Engine_Oil_Pressure_Low_Threshold_Configuration(void)
{
    uint16_t Value = 0;
    Value = EOL_0300.Data [ 14u ];
    Value = Value << 8u;
    Value = Value | EOL_0300.Data [ 15u ];
    return Value;
}

/*BYTE16 ~ BYTE19
 *K值配置
 *Range 范围: 1 ~ 1,300,000
 *Resolution 分辨率: 1
*/
uint32_t Val_EOL_0300_K_Value_Configuration(void)
{
    uint32_t Value = 0;
    uint8_t i;
    for(i = 0;i < 4;i++)
    {
        Value = Value << 8u;
        Value = Value | EOL_0300.Data [ 16u + i ];
    }
    return Value;
}

/*BYTE20 ~ BYTE21
 *机油压力高阈值配置
 *Range 范围: 0.04 ~ 2621.4 bar
 *Resolution 分辨率: 4 kpa / bit
*/
uint16_t Val_EOL_0300_Engine_Oil_Pressure_High_Threshold_Configuration(void)
{
    uint16_t Value = 0;
    Value = EOL_0300.Data [ 20u ];
    Value = Value << 8u;
    Value = Value | EOL_0300.Data [ 21u ];
    return Value;
}

/*BYTE22
 *车速误差系数配置
 *Range 范围: 0.01 ~ 2.55
 *Resolution 分辨率: 0.01
 *Value in EEPROM: Data * 100
 *在EEPROM里的值：数据 * 100
*/
uint8_t Val_EOL_0300_Vehicle_Speed_Error_Factor_Configufation(void)
{
    return (EOL_0300.Data [ 22u ] >> 0u) & 0xFFu;
}

/*BYTE23
 *水温高阈值配置
 *Range 范围: -40 ~ 215 ℃
 *Resolution 分辨率: 1 ℃ ,   - 40 offset 偏移
*/
uint8_t Val_EOL_0300_Coolant_Temperature_High_Threshold_Configuration(void)
{
    return (EOL_0300.Data [ 23u ] >> 0u) & 0xFFu;
}

/*BYTE24
 *变速箱油温高阈值配置
 *Range 范围: -50 ~ 205 ℃
 *Resolution 分辨率: 1 ℃ ,   - 50 offset 偏移
*/
uint8_t Val_EOL_0300_Transmission_Oil_Temperature_High_Threshold_Configuration(void)
{
    return (EOL_0300.Data [ 24u ] >> 0u) & 0xFFu;
}

/*BYTE25
 *液压油温高阈值配置
 *Range 范围: -40 ~ 215 ℃
 *Resolution 分辨率: 1 ℃ ,   - 40 offset 偏移
*/
uint8_t Val_EOL_0300_Hydraulic_Oil_Temperature_High_Threshold_Configuration(void)
{
    return (EOL_0300.Data [ 25u ] >> 0u) & 0xFFu;
}

/*BYTE26
 *尿素液位低阈值配置
 *Range 范围: 1 ~ 100 %
 *Resolution 分辨率: 1 %
*/
uint8_t Val_EOL_0300_AdBlue_Level_Low_Threshold_Configuration(void)
{
    return (EOL_0300.Data [ 26u ] >> 0u) & 0xFFu;
}

/*BYTE27
 *发动机运行时间计时方式配 置(Remark: This item can also be configurated via menu opeation
 备注：此项也可以通过菜单 操作配置) 
 *0: Ignition On 点火打开
 *1: Engine Running 发动机运行
 *2: CAN Signal CAN信号
*/
uint8_t Val_EOL_0300_Engine_Running_Time_Counting_Method_Configuration(void)
{
    return (EOL_0300.Data [ 27u ] >> 0u) & 0xFFu;
}

/*BYTE28
 *总计里程使能配置 
 *0: Disable 不使能
 *1: Enable 使能 
*/
uint8_t Val_EOL_0300_Odometer_Enable_Configuration(void)
{
    return (EOL_0300.Data [ 28u ] >> 0u) & 0xFFu;
}

/*BYTE29
 *车速使能配置
 *0: Disable 不使能
 *1: Enable 使能 
*/
uint8_t Val_EOL_0300_Vehicle_Speed_Enable_Configuration(void)
{
    return (EOL_0300.Data [ 29u ] >> 0u) & 0xFFu;
}

/*BYTE30
 *变速箱挡位使能配置
 *0: Disable 不使能
 *1: Enable 使能 
*/
uint8_t Val_EOL_0300_Transmission_Gear_Enable_Configuration(void)
{
    return (EOL_0300.Data [ 30u ] >> 0u) & 0xFFu;
}

/*BYTE31
 *最小电流使能配置
 *0: Disable 不使能
 *1: Enable 使能 
*/
uint8_t Val_EOL_0300_Minimum_Current_Enable_Configuration(void)
{
    return (EOL_0300.Data [ 31u ] >> 0u) & 0xFFu;
}

/*BYTE32 ~ BYTE33
 *制动气压低阈值配置
 *Range 范围: 0.04 ~ 2621.4 bar
 *Resolution 分辨率: 4 kpa / bit
*/
uint16_t Val_EOL_0300_Air_Pressure_Low_Threshold_Configuration(void)
{
    uint16_t Value = 0;
    Value = EOL_0300.Data [ 32u ];
    Value = Value << 8u;
    Value = Value | EOL_0300.Data [ 33u ];
    return Value;
}

/*BYTE34 ~ BYTE35
 *制动气压高阈值配置
 *Range 范围: 0.04 ~ 2621.4 bar
 *Resolution 分辨率: 4 kpa / bit
*/
uint16_t Val_EOL_0300_Air_Pressure_High_Threshold_Configuration(void)
{
    uint16_t Value = 0;
    Value = EOL_0300.Data [ 34u ];
    Value = Value << 8u;
    Value = Value | EOL_0300.Data [ 35u ];
    return Value;
}

/*BYTE36 ~ BYTE37
 *湿式制动低阈值配置
 *Range 范围: 0.04 ~ 2621.4 bar
 *Resolution 分辨率: 4 kpa / bit
*/
uint16_t Val_EOL_0300_Wet_Brake_Low_Threshold_Configuration(void)
{
    uint16_t Value = 0;
    Value = EOL_0300.Data [ 36u ];
    Value = Value << 8u;
    Value = Value | EOL_0300.Data [ 37u ];
    return Value;
}

/*BYTE38 ~ BYTE39
 *湿式制动高阈值配置
 *Range 范围: 0.04 ~ 2621.4 bar
 *Resolution 分辨率: 4 kpa / bit
*/
uint16_t Val_EOL_0300_Wet_Brake_High_Threshold_Configuration(void)
{
    uint16_t Value = 0;
    Value = EOL_0300.Data [ 38u ];
    Value = Value << 8u;
    Value = Value | EOL_0300.Data [ 39u ];
    return Value;
}

/*BYTE40 ~ BYTE41
 *变速箱油压低阈值配置
 *Range 范围: 0.04 ~ 2621.4 bar
 *Resolution 分辨率: 4 kpa / bit
*/
uint16_t Val_EOL_0300_Transmission_Oil_Pressure_Low_Threshold_Configuration(void)
{
    uint16_t Value = 0;
    Value = EOL_0300.Data [ 40u ];
    Value = Value << 8u;
    Value = Value | EOL_0300.Data [ 41u ];
    return Value;
}

/*BYTE42 ~ BYTE43
 *变速箱油压高阈值配置
 *Range 范围: 0.04 ~ 2621.4 bar
 *Resolution 分辨率: 4 kpa / bit
*/
uint16_t Val_EOL_0300_Transmission_Oil_Pressure_High_Threshold_Configuration(void)
{
    uint16_t Value = 0;
    Value = EOL_0300.Data [ 42u ];
    Value = Value << 8u;
    Value = Value | EOL_0300.Data [ 43u ];
    return Value;
}

/*BYTE44 ~ BYTE45
 *燃料液位低阈值配置
 *Range 范围:  0.01 ~ 100 %
 *Resolution 分辨率: 0.01 %
 *Value in EEPROM: Data * 10000
 *在EEPROM里的值：数据 * 10000
*/
uint16_t Val_EOL_0300_Elding_Level_Low_Threshold_Configuration(void)
{
    uint16_t Value = 0;
    Value = EOL_0300.Data [ 44u ];
    Value = Value << 8u;
    Value = Value | EOL_0300.Data [ 45u ];
    return Value;
}

/*BYTE46 ~ BYTE47
 *电池电压低阈值配置
 *Range 范围:  16.0 ~ 32.0 V
 *Resolution 分辨率:  0.1 V
 *Value in EEPROM: Data * 10
 *在EEPROM里的值：数据 * 10
*/
uint16_t Val_EOL_0300_Battery_Voltage_Low_Threshold_Configuration(void)
{
    uint16_t Value = 0;
    Value = EOL_0300.Data [ 46u ];
    Value = Value << 8u;
    Value = Value | EOL_0300.Data [ 47u ];
    return Value;
}

/*BYTE48 ~ BYTE49
 *电池电压高阈值配
 *Range 范围:  16.0 ~ 32.0 V
 *Resolution 分辨率:  0.1 V
 *Value in EEPROM: Data * 10
 *在EEPROM里的值：数据 * 10
*/
uint16_t Val_EOL_0300_Battery_Voltage_High_Threshold_Configuration(void)
{
    uint16_t Value = 0;
    Value = EOL_0300.Data [ 48u ];
    Value = Value << 8u;
    Value = Value | EOL_0300.Data [ 49u ];
    return Value;
}

/*BYTE50
 *瞬时油耗使能配置
 *0: Disable 不使能
 *1: Enable 使能 
*/
uint8_t Val_EOL_0300_Instantaneous_Fuel_Consumption_Enable_Configuration(void)
{
    return (EOL_0300.Data [ 50u ] >> 0u) & 0xFFu;
}

/*BYTE51
 *开机动画使能配置
 *0: Disable 不使能
 *1: Enable 使能 
*/
uint8_t Val_EOL_0300_Boot_Animation_Enable_Configuration(void)
{
    return (EOL_0300.Data [ 51u ] >> 0u) & 0xFFu;
}

/*BYTE52
 *液晶屏左侧数显表配置
 *0: Not display 不显示
 *1: Battery Voltage 电池电压 (Loader & Roller)
 *2: Vibration Frequency 振动频率 (Roller)
 *3: Tire Pressure 胎压 (Roller 
*/
uint8_t Val_EOL_0300_LCD_Left_Digital_Gauge_Configuration(void)
{
    return (EOL_0300.Data [ 52u ] >> 0u) & 0xFFu;
}

/*BYTE53
 *液晶屏左侧大表头配置
 *0: AdBlue Level Gauge 尿素液位表 (Loader)
 *1: Engine Oil PressureGauge 机油压力表 (Roller)
 *2: Battery Voltage Gauge 电池电压表 (Loader)
*/
uint8_t Val_EOL_0300_LCD_Left_Big_Gauge_Configuration(void)
{
    return (EOL_0300.Data [ 53u ] >> 0u) & 0xFFu;
}

/*BYTE54
 *液晶屏右侧大表头配置
 *0: Fuel Level Gauge 燃油液位表 (Loader)
 *1: LNG Level Gauge LNG气量表 (Loader)
 *2: AdBlue Level Gauge 尿素液位表 (Roller)
 *3: Battery Voltage Gauge 电池电压表 (Roller)
*/
uint8_t Val_EOL_0300_LCD_Right_Big_Gauge_Configuration(void)
{
    return (EOL_0300.Data [ 54u ] >> 0u) & 0xFFu;
}

/*BYTE55
 *液晶屏左侧小表头配置
 *0: Not display 不显示
 *1: Air Pressure Gauge 制动气压表 (Loader &  Roller)
 *2: Wet Brake Gauge 湿式制动表 (Loader)
 *3: Hydraulic Oil Temperature Gauge 液压油温表 (Roller)
 *4: Transmission Oil Pressure Gauge变速箱油压表 (Roller)
 *5: Transmission Oil
*/
uint8_t Val_EOL_0300_LCD_Left_Small_Gauge_Configuration(void)
{
    return (EOL_0300.Data [ 55u ] >> 0u) & 0xFFu;
}

/*BYTE56
 *液晶屏右侧小表头配置
 *0: Not display 不显示
 *1: Engine Oil Pressure
 *Gauge 机油压力表 (Loader)
 *2: Battery Voltage Gauge 电池电压表 (Roller)
 *3: Transmission Oil
 *Temperature Gauge   变速箱油温表 (Roller)
 *4: Transmission Oil
 *Pressure Gauge
 *变速箱油压表 (Roller)
 *5: AdBlue Level Gauge 尿素液位表 (Roller)
 *6: Hydraulic Oil
 *Temperature Gauge 液压油温表 (Roller)
*/
uint8_t Val_EOL_0300_LCD_Right_Small_Gauge_Configuration(void)
{
    return (EOL_0300.Data [ 56u ] >> 0u) & 0xFFu;
}

/*BYTE57
 *液晶屏左侧柱状表配置
 0: Not display 不显示 
 1: Transmission Oil
 Pressure Gauge Not
 Available变速箱油压表不可
 用 (Loader)
 2: Transmission Oil Pressure Gauge
 变速箱油压表 (Loader & Roller)
 3: Air Pressure Gauge 制动气压表 (Roller)
*/
uint8_t Val_EOL_0300_LCD_Left_Bar_Graph_Gauge_Configuration(void)
{
    return (EOL_0300.Data [ 57u ] >> 0u) & 0xFFu;
}

/*BYTE58
 *液晶屏右侧柱状表配置
0: Not display 不显示
1: Hydraulic Oil
Temperature Gauge Not
Available 液压油温表不可用 (Loader)
2: Hydraulic Oil
Temperature Gauge   液压油温表 (Loader & Roller)
3: Transmission Oil
Temperature Gauge   变速箱油温表 (Roller)
*/
uint8_t Val_EOL_0300_LCD_Right_Bar_Graph_Gauge_Configuration(void)
{
    return (EOL_0300.Data [ 58u ] >> 0u) & 0xFFu;
}


/*BYTE59
 *瞬时油耗输入配置
0: CAN Input CAN输入
1: IC Accumulation 仪表累计
*/
uint8_t Val_EOL_0300_LFE_Input_Configuration(void)
{
    return (EOL_0300.Data [ 59u ] >> 0u) & 0xFFu;
}

/*BYTE60
 *变速箱类型配置
0: MT 机械变速箱
1: ZF ZF变速箱
2: DANA DANA变速箱
3: XuGong Homemade 徐工自制变速箱
*/
uint8_t Val_EOL_0300_Transmission_Type_Configuration(void)
{
    return (EOL_0300.Data [ 60u ] >> 0u) & 0xFFu;
}

/*BYTE61
 *发动机类型配置
0: Weichai 潍柴
1: Shangchai 上柴
2: Cummins 康明斯
3: Yunnei 云内
4: Yuchai 玉柴
5: Luotuo 洛拖
*/
uint8_t Val_EOL_0300_Engine_Type_Configuration(void)
{
    return (EOL_0300.Data [ 61u ] >> 0u) & 0xFFu;
}

/*
62 - 73字节预留
*/

/*BYTE74
 *液晶屏右侧数显表配置
0: Not display 不显示
1: Amibent Temperature 环境温度
2: Battery Voltage 电池电压 (Loader & Roller)
3: Vibration Frequency 振动频率 (Roller)
4: Tire Pressure 胎压 (Roller)
*/
uint8_t Val_EOL_0300_LCD_Right_Digital_Gauge_Configuration(void)
{
    return (EOL_0300.Data [ 74u ] >> 0u) & 0xFFu;
}

/**
 * 75字节预留
 */

/**BYTE76 -BYTE79
 *发动机运行时间配置
Range 范围: 0.00 ~ 210,554,060.75 h
Resolution 分辨率: 0.05 h
Value in EEPROM: Data * 20
在EEPROM里的值：数据 * 20
 */
uint32_t Val_EOL_0300_Engine_Running_Time_Configuration(void)
{
    uint32_t Value = 0;
    uint8_t i;
    for(i = 0;i < 4;i++)
    {
        Value = Value << 8u;
        Value = Value | EOL_0300.Data [ 76u + i ];
    }
    return Value;
}

/**
 * BYTE80 - BYTE89预留
 */

/*0301*/

/**BYTE0 ~ BYTE1
* 液压油温校准点X1
Range 范围: 0.00 ~ 500.00 Ω
Resolution 分辨率: 0.01 Ω
Value in EEPROM: Data * 100
在EEPROM里的值：数据 * 100
*/
uint16_t Val_EOL_0301_Hydraulic_Oil_Temperature_Calibration_Point_X1(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 0u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 1u ];
    return Value;
}

/**BYTE2 ~ BYTE3
 * * 液压油温校准点X2
Range 范围: 0.00 ~ 500.00 Ω
Resolution 分辨率: 0.01 Ω
Value in EEPROM: Data * 100
在EEPROM里的值：数据 * 100
*/
uint16_t Val_EOL_0301_Hydraulic_Oil_Temperature_Calibration_Point_X2(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 2u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 3u ];
    return Value;
}

/**BYTE4 ~ BYTE5
 * * 液压油温校准点X3
Range 范围: 0.00 ~ 500.00 Ω
Resolution 分辨率: 0.01 Ω
Value in EEPROM: Data * 100
在EEPROM里的值：数据 * 100
*/
uint16_t Val_EOL_0301_Hydraulic_Oil_Temperature_Calibration_Point_X3(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 4u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 5u ];
    return Value;
}

/**BYTE6 ~ BYTE7
 * * 液压油温校准点X4
Range 范围: 0.00 ~ 500.00 Ω
Resolution 分辨率: 0.01 Ω
Value in EEPROM: Data * 100
在EEPROM里的值：数据 * 100
*/
uint16_t Val_EOL_0301_Hydraulic_Oil_Temperature_Calibration_Point_X4(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 6u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 7u ];
    return Value;
}


/**BYTE8 ~ BYTE9
 * * 液压油温校准点X5
Range 范围: 0.00 ~ 500.00 Ω
Resolution 分辨率: 0.01 Ω
Value in EEPROM: Data * 100
在EEPROM里的值：数据 * 100
*/
uint16_t Val_EOL_0301_Hydraulic_Oil_Temperature_Calibration_Point_X5(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 8u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 9u ];
    return Value;
}

/**BYTE10 ~ BYTE11
 * * 液压油温校准点X6
Range 范围: 0.00 ~ 500.00 Ω
Resolution 分辨率: 0.01 Ω
Value in EEPROM: Data * 100
在EEPROM里的值：数据 * 100
*/
uint16_t Val_EOL_0301_Hydraulic_Oil_Temperature_Calibration_Point_X6(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 10u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 11u ];
    return Value;
}

/**BYTE12 ~ BYTE13
 * * 液压油温校准点X7
Range 范围: 0.00 ~ 500.00 Ω
Resolution 分辨率: 0.01 Ω
Value in EEPROM: Data * 100
在EEPROM里的值：数据 * 100
*/
uint16_t Val_EOL_0301_Hydraulic_Oil_Temperature_Calibration_Point_X7(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 12u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 13u ];
    return Value;
}

/**BYTE14 ~ BYTE15
 * * 液压油温校准点Y1
Range 范围: 40 ~ 120 ℃
Resolution 分辨率: 1 ℃ , -40 offset
*/
uint16_t Val_EOL_0301_Hydraulic_Oil_Temperature_Calibration_Point_Y1(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 14u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 15u ];
    return Value;
}

/**BYTE16 ~ BYTE17
 * * 液压油温校准点Y2
Range 范围: 40 ~ 120 ℃
Resolution 分辨率: 1 ℃ , -40 offset
*/
uint16_t Val_EOL_0301_Hydraulic_Oil_Temperature_Calibration_Point_Y2(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 16u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 17u ];
    return Value;
}

/**BYTE18 ~ BYTE19
 * * 液压油温校准点Y3
Range 范围: 40 ~ 120 ℃
Resolution 分辨率: 1 ℃ , -40 offset
*/
uint16_t Val_EOL_0301_Hydraulic_Oil_Temperature_Calibration_Point_Y3(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 18u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 19u ];
    return Value;
}


/**BYTE20 ~ BYTE21
 * * 液压油温校准点Y4
Range 范围: 40 ~ 120 ℃
Resolution 分辨率: 1 ℃ , -40 offset
*/
uint16_t Val_EOL_0301_Hydraulic_Oil_Temperature_Calibration_Point_Y4(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 20u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 21u ];
    return Value;
}

/**BYTE22 ~ BYTE23
 * * 液压油温校准点Y5
Range 范围: 40 ~ 120 ℃
Resolution 分辨率: 1 ℃ , -40 offset
*/
uint16_t Val_EOL_0301_Hydraulic_Oil_Temperature_Calibration_Point_Y5(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 22u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 23u ];
    return Value;
}

/**BYTE24 ~ BYTE25
 * * 液压油温校准点Y6
Range 范围: 40 ~ 120 ℃
Resolution 分辨率: 1 ℃ , -40 offset
*/
uint16_t Val_EOL_0301_Hydraulic_Oil_Temperature_Calibration_Point_Y6(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 24u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 25u ];
    return Value;
}

/**BYTE26 ~ BYTE27
 * * 液压油温校准点Y7
Range 范围: 40 ~ 120 ℃
Resolution 分辨率: 1 ℃ , -40 offset
*/
uint16_t Val_EOL_0301_Hydraulic_Oil_Temperature_Calibration_Point_Y7(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 26u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 27u ];
    return Value;
}

/**BYTE28 ~ BYTE29
 * * 燃油液位校准点X1
Range 范围: 0.00 ~ 500.00 Ω
Resolution 分辨率: 0.01 Ω
Value in EEPROM: Data *100
在EEPROM里的值：数据 * 100
*/
uint16_t Val_EOL_0301_Fuel_Level_Calibration_Point_X1(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 28u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 29u ];
    return Value;
}

/**BYTE30 ~ BYTE31
 * * 燃油液位校准点X2
Range 范围: 0.00 ~ 500.00 Ω
Resolution 分辨率: 0.01 Ω
Value in EEPROM: Data *100
在EEPROM里的值：数据 * 100
*/
uint16_t Val_EOL_0301_Fuel_Level_Calibration_Point_X2(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 30u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 31u ];
    return Value;
}

/**BYTE32 ~ BYTE33
 * * 燃油液位校准点X3
Range 范围: 0.00 ~ 500.00 Ω
Resolution 分辨率: 0.01 Ω
Value in EEPROM: Data *100
在EEPROM里的值：数据 * 100
*/
uint16_t Val_EOL_0301_Fuel_Level_Calibration_Point_X3(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 32u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 33u ];
    return Value;
}

/**BYTE34 ~ BYTE35
 * * 燃油液位校准点X4
Range 范围: 0.00 ~ 500.00 Ω
Resolution 分辨率: 0.01 Ω
Value in EEPROM: Data *100
在EEPROM里的值：数据 * 100
*/
uint16_t Val_EOL_0301_Fuel_Level_Calibration_Point_X4(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 34u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 35u ];
    return Value;
}

/**BYTE36 ~ BYTE37
 * * 燃油液位校准点X5
Range 范围: 0.00 ~ 500.00 Ω
Resolution 分辨率: 0.01 Ω
Value in EEPROM: Data *100
在EEPROM里的值：数据 * 100
*/
uint16_t Val_EOL_0301_Fuel_Level_Calibration_Point_X5(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 36u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 37u ];
    return Value;
}

/**BYTE38 ~ BYTE39
 * * 燃油液位校准点X6
Range 范围: 0.00 ~ 500.00 Ω
Resolution 分辨率: 0.01 Ω
Value in EEPROM: Data *100
在EEPROM里的值：数据 * 100
*/
uint16_t Val_EOL_0301_Fuel_Level_Calibration_Point_X6(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 38u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 39u ];
    return Value;
}

/**BYTE40 ~ BYTE41
 * * 燃油液位校准点X7
Range 范围: 0.00 ~ 500.00 Ω
Resolution 分辨率: 0.01 Ω
Value in EEPROM: Data *100
在EEPROM里的值：数据 * 100
*/
uint16_t Val_EOL_0301_Fuel_Level_Calibration_Point_X7(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 40u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 41u ];
    return Value;
}

/**BYTE42 ~ BYTE43
 * * 燃油液位校准点Y1
Range 范围: 0.00 ~ 500.00 Ω
Resolution 分辨率: 0.01 Ω
Value in EEPROM: Data *100
在EEPROM里的值：数据 * 100
*/
uint16_t Val_EOL_0301_Fuel_Level_Calibration_Point_Y1(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 42u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 43u ];
    return Value;
}

/**BYTE44 ~ BYTE45
 * * 燃油液位校准点Y2
Range 范围: 0.00 ~ 500.00 Ω
Resolution 分辨率: 0.01 Ω
Value in EEPROM: Data *100
在EEPROM里的值：数据 * 100
*/
uint16_t Val_EOL_0301_Fuel_Level_Calibration_Point_Y2(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 44u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 45u ];
    return Value;
}

/**BYTE46 ~ BYTE47
 * * 燃油液位校准点Y3
Range 范围: 0.00 ~ 500.00 Ω
Resolution 分辨率: 0.01 Ω
Value in EEPROM: Data *100
在EEPROM里的值：数据 * 100
*/
uint16_t Val_EOL_0301_Fuel_Level_Calibration_Point_Y3(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 46u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 47u ];
    return Value;
}

/**BYTE48 ~ BYTE49
 * * 燃油液位校准点Y4
Range 范围: 0.00 ~ 500.00 Ω
Resolution 分辨率: 0.01 Ω
Value in EEPROM: Data *100
在EEPROM里的值：数据 * 100
*/
uint16_t Val_EOL_0301_Fuel_Level_Calibration_Point_Y4(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 48u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 49u ];
    return Value;
}

/**BYTE50 ~ BYTE51
 * * 燃油液位校准点Y5
Range 范围: 0.00 ~ 500.00 Ω
Resolution 分辨率: 0.01 Ω
Value in EEPROM: Data *100
在EEPROM里的值：数据 * 100
*/
uint16_t Val_EOL_0301_Fuel_Level_Calibration_Point_Y5(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 50u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 51u ];
    return Value;
}

/**BYTE52 ~ BYTE53
 * * 燃油液位校准点Y6
Range 范围: 0.00 ~ 500.00 Ω
Resolution 分辨率: 0.01 Ω
Value in EEPROM: Data *100
在EEPROM里的值：数据 * 100
*/
uint16_t Val_EOL_0301_Fuel_Level_Calibration_Point_Y6(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 52u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 53u ];
    return Value;
}

/**BYTE54 ~ BYTE55
 * * 燃油液位校准点Y7
Range 范围: 0.00 ~ 500.00 Ω
Resolution 分辨率: 0.01 Ω
Value in EEPROM: Data *100
在EEPROM里的值：数据 * 100
*/
uint16_t Val_EOL_0301_Fuel_Level_Calibration_Point_Y7(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 54u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 55u ];
    return Value;
}

/**BYTE56 ~ BYTE57
 * * 变速箱油温校准点X1
Range 范围: 0.00 ~ 500.00 Ω
Resolution 分辨率: 0.01 Ω
Value in EEPROM: Data *100
在EEPROM里的值：数据 * 100
*/
uint16_t Val_EOL_0301_Transmission_Oil_Temperature_Calibration_Point_X1(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 56u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 57u ];
    return Value;
}

/**BYTE58 ~ BYTE59
 * * 变速箱油温校准点X2
Range 范围: 0.00 ~ 500.00 Ω
Resolution 分辨率: 0.01 Ω
Value in EEPROM: Data *100
在EEPROM里的值：数据 * 100
*/
uint16_t Val_EOL_0301_Transmission_Oil_Temperature_Calibration_Point_X2(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 58u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 59u ];
    return Value;
}

/**BYTE60 ~ BYTE61
 * * 变速箱油温校准点X3
Range 范围: 0.00 ~ 500.00 Ω
Resolution 分辨率: 0.01 Ω
Value in EEPROM: Data *100
在EEPROM里的值：数据 * 100
*/
uint16_t Val_EOL_0301_Transmission_Oil_Temperature_Calibration_Point_X3(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 58u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 59u ];
    return Value;
}

/**BYTE62 ~ BYTE63
 * * 变速箱油温校准点X4
Range 范围: 0.00 ~ 500.00 Ω
Resolution 分辨率: 0.01 Ω
Value in EEPROM: Data *100
在EEPROM里的值：数据 * 100
*/
uint16_t Val_EOL_0301_Transmission_Oil_Temperature_Calibration_Point_X4(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 62u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 63u ];
    return Value;
}

/**BYTE64 ~ BYTE65
 * * 变速箱油温校准点X5
Range 范围: 0.00 ~ 500.00 Ω
Resolution 分辨率: 0.01 Ω
Value in EEPROM: Data *100
在EEPROM里的值：数据 * 100
*/
uint16_t Val_EOL_0301_Transmission_Oil_Temperature_Calibration_Point_X5(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 64u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 65u ];
    return Value;
}

/**BYTE66 ~ BYTE67
 * * 变速箱油温校准点X6
Range 范围: 0.00 ~ 500.00 Ω
Resolution 分辨率: 0.01 Ω
Value in EEPROM: Data *100
在EEPROM里的值：数据 * 100
*/
uint16_t Val_EOL_0301_Transmission_Oil_Temperature_Calibration_Point_X6(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 66u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 67u ];
    return Value;
}

/**BYTE68 ~ BYTE69
 * * 变速箱油温校准点X7
Range 范围: 0.00 ~ 500.00 Ω
Resolution 分辨率: 0.01 Ω
Value in EEPROM: Data *100
在EEPROM里的值：数据 * 100
*/
uint16_t Val_EOL_0301_Transmission_Oil_Temperature_Calibration_Point_X7(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 68u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 69u ];
    return Value;
}

/**BYTE70 ~ BYTE71
 * * 变速箱油温校准点X7
Range 范围: 55 ~ 140 ℃
Resolution 分辨率: 1 ℃ , -50 offset
*/
uint16_t Val_EOL_0301_Transmission_Oil_Temperature_Calibration_Point_Y1(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 70u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 71u ];
    return Value;
}


/**BYTE72 ~ BYTE73
 * * 变速箱油温校准点Y2
Range 范围: 55 ~ 140 ℃
Resolution 分辨率: 1 ℃ , -50 offset
*/
uint16_t Val_EOL_0301_Transmission_Oil_Temperature_Calibration_Point_Y2(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 72u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 73u ];
    return Value;
}

/**BYTE74 ~ BYTE75
 * * 变速箱油温校准点Y3
Range 范围: 55 ~ 140 ℃
Resolution 分辨率: 1 ℃ , -50 offset
*/
uint16_t Val_EOL_0301_Transmission_Oil_Temperature_Calibration_Point_Y3(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 74u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 75u ];
    return Value;
}

/**BYTE76 ~ BYTE77
 * * 变速箱油温校准点Y4
Range 范围: 55 ~ 140 ℃
Resolution 分辨率: 1 ℃ , -50 offset
*/
uint16_t Val_EOL_0301_Transmission_Oil_Temperature_Calibration_Point_Y4(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 76u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 77u ];
    return Value;
}

/**BYTE78 ~ BYTE79
 * * 变速箱油温校准点Y5
Range 范围: 55 ~ 140 ℃
Resolution 分辨率: 1 ℃ , -50 offset
*/
uint16_t Val_EOL_0301_Transmission_Oil_Temperature_Calibration_Point_Y5(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 78u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 79u ];
    return Value;
}

/**BYTE80 ~ BYTE81
 * * 变速箱油温校准点Y6
Range 范围: 55 ~ 140 ℃
Resolution 分辨率: 1 ℃ , -50 offset
*/
uint16_t Val_EOL_0301_Transmission_Oil_Temperature_Calibration_Point_Y6(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 80u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 81u ];
    return Value;
}

/**BYTE82 ~ BYTE83
 * * 变速箱油温校准点Y7
Range 范围: 55 ~ 140 ℃
Resolution 分辨率: 1 ℃ , -50 offset
*/
uint16_t Val_EOL_0301_Transmission_Oil_Temperature_Calibration_Point_Y7(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 82u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 83u ];
    return Value;
}

/**BYTE84 ~ BYTE85
 * * 制动气压（电阻）校准点X1
Range 范围: 0.00 ~ 500.00 Ω
Resolution 分辨率: 0.01 Ω
Value in EEPROM: Data * 100
在EEPROM里的值：数据 * 100
*/
uint16_t Val_EOL_0301_Air_Pressure_Resistor_Calibration_Point_X1(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 84u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 85u ];
    return Value;
}

/**BYTE86 ~ BYTE87
 * * 制动气压（电阻）校准点X2
Range 范围: 0.00 ~ 500.00 Ω
Resolution 分辨率: 0.01 Ω
Value in EEPROM: Data * 100
在EEPROM里的值：数据 * 100
*/
uint16_t Val_EOL_0301_Air_Pressure_Resistor_Calibration_Point_X2(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 86u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 87u ];
    return Value;
}

/**BYTE88 ~ BYTE89
 * * 制动气压（电阻）校准点X3
Range 范围: 0.00 ~ 500.00 Ω
Resolution 分辨率: 0.01 Ω
Value in EEPROM: Data * 100
在EEPROM里的值：数据 * 100
*/
uint16_t Val_EOL_0301_Air_Pressure_Resistor_Calibration_Point_X3(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 88u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 89u ];
    return Value;
}

/**BYTE90 ~ BYTE91
 * * 制动气压（电阻）校准点X4
Range 范围: 0.00 ~ 500.00 Ω
Resolution 分辨率: 0.01 Ω
Value in EEPROM: Data * 100
在EEPROM里的值：数据 * 100
*/
uint16_t Val_EOL_0301_Air_Pressure_Resistor_Calibration_Point_X4(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 90u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 91u ];
    return Value;
}

/**BYTE92 ~ BYTE93
 * * 制动气压（电阻）校准点X5
Range 范围: 0.00 ~ 500.00 Ω
Resolution 分辨率: 0.01 Ω
Value in EEPROM: Data * 100
在EEPROM里的值：数据 * 100
*/
uint16_t Val_EOL_0301_Air_Pressure_Resistor_Calibration_Point_X5(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 92u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 93u ];
    return Value;
}

/**BYTE94 ~ BYTE95
 * * 制动气压（电阻）校准点X6
Range 范围: 0.00 ~ 500.00 Ω
Resolution 分辨率: 0.01 Ω
Value in EEPROM: Data * 100
在EEPROM里的值：数据 * 100
*/
uint16_t Val_EOL_0301_Air_Pressure_Resistor_Calibration_Point_X6(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 94u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 95u ];
    return Value;
}

/**BYTE96 ~ BYTE97
 * * 制动气压（电阻）校准点X7
Range 范围: 0.00 ~ 500.00 Ω
Resolution 分辨率: 0.01 Ω
Value in EEPROM: Data * 100
在EEPROM里的值：数据 * 100
*/
uint16_t Val_EOL_0301_Air_Pressure_Resistor_Calibration_Point_X7(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 96u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 97u ];
    return Value;
}

/**BYTE98 ~ BYTE99
 * * 制动气压（电阻）校准点Y1
Range 范围: 0.00 ~ 10.00 bar
Resolution 分辨率: 0.01 bar
Value in EEPROM: Data * 100
在EEPROM里的值：数据 * 100
*/
uint16_t Val_EOL_0301_Air_Pressure_Resistor_Calibration_Point_Y1(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 98u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 99u ];
    return Value;
}

/**BYTE100 ~ BYTE101
 * * 制动气压（电阻）校准点Y2
Range 范围: 0.00 ~ 10.00 bar
Resolution 分辨率: 0.01 bar
Value in EEPROM: Data * 100
在EEPROM里的值：数据 * 100
*/
uint16_t Val_EOL_0301_Air_Pressure_Resistor_Calibration_Point_Y2(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 100u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 101u ];
    return Value;
}

/**BYTE102 ~ BYTE103
 * * 制动气压（电阻）校准点Y3
Range 范围: 0.00 ~ 10.00 bar
Resolution 分辨率: 0.01 bar
Value in EEPROM: Data * 100
在EEPROM里的值：数据 * 100
*/
uint16_t Val_EOL_0301_Air_Pressure_Resistor_Calibration_Point_Y3(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 102u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 103u ];
    return Value;
}

/**BYTE104 ~ BYTE105
 * * 制动气压（电阻）校准点Y4
Range 范围: 0.00 ~ 10.00 bar
Resolution 分辨率: 0.01 bar
Value in EEPROM: Data * 100
在EEPROM里的值：数据 * 100
*/
uint16_t Val_EOL_0301_Air_Pressure_Resistor_Calibration_Point_Y4(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 104u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 105u ];
    return Value;
}

/**BYTE106 ~ BYTE107
 * * 制动气压（电阻）校准点Y5
Range 范围: 0.00 ~ 10.00 bar
Resolution 分辨率: 0.01 bar
Value in EEPROM: Data * 100
在EEPROM里的值：数据 * 100
*/
uint16_t Val_EOL_0301_Air_Pressure_Resistor_Calibration_Point_Y5(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 106u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 107u ];
    return Value;
}

/**BYTE108 ~ BYTE109
 * * 制动气压（电阻）校准点Y6
Range 范围: 0.00 ~ 10.00 bar
Resolution 分辨率: 0.01 bar
Value in EEPROM: Data * 100
在EEPROM里的值：数据 * 100
*/
uint16_t Val_EOL_0301_Air_Pressure_Resistor_Calibration_Point_Y6(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 108u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 109u ];
    return Value;
}

/**BYTE110 ~ BYTE111
 * * 制动气压（电阻）校准点Y7
Range 范围: 0.00 ~ 10.00 bar
Resolution 分辨率: 0.01 bar
Value in EEPROM: Data * 100
在EEPROM里的值：数据 * 100
*/
uint16_t Val_EOL_0301_Air_Pressure_Resistor_Calibration_Point_Y7(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 110u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 111u ];
    return Value;
}

/**BYTE112 ~ BYTE113
 * * 制动气压（电压）校准点X1
Range 范围: 0.00 ~ 10.00 bar
Resolution 分辨率: 0.01 bar
Value in EEPROM: Data * 100
在EEPROM里的值：数据 * 100
*/
uint16_t Val_EOL_0301_Air_Pressure_Voltage_Calibration_Point_X1(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 112u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 113u ];
    return Value;
}

/**BYTE114 ~ BYTE115
 * * 制动气压（电压）校准点X2
Range 范围: 0.00 ~ 10.00 bar
Resolution 分辨率: 0.01 bar
Value in EEPROM: Data * 100
在EEPROM里的值：数据 * 100
*/
uint16_t Val_EOL_0301_Air_Pressure_Voltage_Calibration_Point_X2(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 114u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 115u ];
    return Value;
}

/**BYTE116 ~ BYTE117
 * * 制动气压（电压）校准点X3
Range 范围: 0.00 ~ 10.00 bar
Resolution 分辨率: 0.01 bar
Value in EEPROM: Data * 100
在EEPROM里的值：数据 * 100
*/
uint16_t Val_EOL_0301_Air_Pressure_Voltage_Calibration_Point_X3(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 116u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 117u ];
    return Value;
}

/**BYTE118 ~ BYTE119
 * * 制动气压（电压）校准点X4
Range 范围: 0.00 ~ 10.00 bar
Resolution 分辨率: 0.01 bar
Value in EEPROM: Data * 100
在EEPROM里的值：数据 * 100
*/
uint16_t Val_EOL_0301_Air_Pressure_Voltage_Calibration_Point_X4(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 118u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 119u ];
    return Value;
}

/**BYTE120 ~ BYTE121
 * * 制动气压（电压）校准点X5
Range 范围: 0.00 ~ 10.00 bar
Resolution 分辨率: 0.01 bar
Value in EEPROM: Data * 100
在EEPROM里的值：数据 * 100
*/
uint16_t Val_EOL_0301_Air_Pressure_Voltage_Calibration_Point_X5(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 120u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 121u ];
    return Value;
}

/**BYTE122 ~ BYTE123
 * * 制动气压（电压）校准点X6
Range 范围: 0.00 ~ 10.00 bar
Resolution 分辨率: 0.01 bar
Value in EEPROM: Data * 100
在EEPROM里的值：数据 * 100
*/
uint16_t Val_EOL_0301_Air_Pressure_Voltage_Calibration_Point_X6(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 122u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 123u ];
    return Value;
}

/**BYTE124 ~ BYTE125
 * * 制动气压（电压）校准点X7
Range 范围: 0.00 ~ 10.00 bar
Resolution 分辨率: 0.01 bar
Value in EEPROM: Data * 100
在EEPROM里的值：数据 * 100
*/
uint16_t Val_EOL_0301_Air_Pressure_Voltage_Calibration_Point_X7(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 124u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 125u ];
    return Value;
}

/**BYTE126 ~ BYTE127
 * * 制动气压（电压）校准点Y1
Range 范围: 0.00 ~ 10.00 bar
Resolution 分辨率: 0.01 bar
Value in EEPROM: Data * 100
在EEPROM里的值：数据 * 100
*/
uint16_t Val_EOL_0301_Air_Pressure_Voltage_Calibration_Point_Y1(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 126u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 127u ];
    return Value;
}

/**BYTE128 ~ BYTE129
 * * 制动气压（电压）校准点Y2
Range 范围: 0.00 ~ 10.00 bar
Resolution 分辨率: 0.01 bar
Value in EEPROM: Data * 100
在EEPROM里的值：数据 * 100
*/
uint16_t Val_EOL_0301_Air_Pressure_Voltage_Calibration_Point_Y2(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 128u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 129u ];
    return Value;
}

/**BYTE130 ~ BYTE131
 * * 制动气压（电压）校准点Y3
Range 范围: 0.00 ~ 10.00 bar
Resolution 分辨率: 0.01 bar
Value in EEPROM: Data * 100
在EEPROM里的值：数据 * 100
*/
uint16_t Val_EOL_0301_Air_Pressure_Voltage_Calibration_Point_Y3(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 130u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 131u ];
    return Value;
}

/**BYTE132 ~ BYTE133
 * * 制动气压（电压）校准点Y4
Range 范围: 0.00 ~ 10.00 bar
Resolution 分辨率: 0.01 bar
Value in EEPROM: Data * 100
在EEPROM里的值：数据 * 100
*/
uint16_t Val_EOL_0301_Air_Pressure_Voltage_Calibration_Point_Y4(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 132u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 133u ];
    return Value;
}

/**BYTE134 ~ BYTE135
 * * 制动气压（电压）校准点Y5
Range 范围: 0.00 ~ 10.00 bar
Resolution 分辨率: 0.01 bar
Value in EEPROM: Data * 100
在EEPROM里的值：数据 * 100
*/
uint16_t Val_EOL_0301_Air_Pressure_Voltage_Calibration_Point_Y5(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 134u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 135u ];
    return Value;
}

/**BYTE136 ~ BYTE137
 * * 制动气压（电压）校准点Y6
Range 范围: 0.00 ~ 10.00 bar
Resolution 分辨率: 0.01 bar
Value in EEPROM: Data * 100
在EEPROM里的值：数据 * 100
*/
uint16_t Val_EOL_0301_Air_Pressure_Voltage_Calibration_Point_Y6(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 136u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 137u ];
    return Value;
}

/**BYTE138 ~ BYTE139
 * * 制动气压（电压）校准点Y7
Range 范围: 0.00 ~ 10.00 bar
Resolution 分辨率: 0.01 bar
Value in EEPROM: Data * 100
在EEPROM里的值：数据 * 100
*/
uint16_t Val_EOL_0301_Air_Pressure_Voltage_Calibration_Point_Y7(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 138u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 139u ];
    return Value;
}

/**BYTE140 ~ BYTE141
 * * 湿式制动校准点X1
Range 范围: 0.000 ~ 5.000 V
Resolution 分辨率: 0.001 V
Value in EEPROM: Data * 1000
在EEPROM里的值：数据 * 1000
*/
uint16_t Val_EOL_0301_Wet_Brake_Calibration_Point_X1(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 140u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 141u ];
    return Value;
}

/**BYTE142 ~ BYTE143
 * * 湿式制动校准点X2
Range 范围: 0.000 ~ 5.000 V
Resolution 分辨率: 0.001 V
Value in EEPROM: Data * 1000
在EEPROM里的值：数据 * 1000
*/
uint16_t Val_EOL_0301_Wet_Brake_Calibration_Point_X2(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 142u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 143u ];
    return Value;
}

/**BYTE144 ~ BYTE145
 * * 湿式制动校准点X3
Range 范围: 0.000 ~ 5.000 V
Resolution 分辨率: 0.001 V
Value in EEPROM: Data * 1000
在EEPROM里的值：数据 * 1000
*/
uint16_t Val_EOL_0301_Wet_Brake_Calibration_Point_X3(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 144u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 145u ];
    return Value;
}

/**BYTE146 ~ BYTE147
 * * 湿式制动校准点X4
Range 范围: 0.000 ~ 5.000 V
Resolution 分辨率: 0.001 V
Value in EEPROM: Data * 1000
在EEPROM里的值：数据 * 1000
*/
uint16_t Val_EOL_0301_Wet_Brake_Calibration_Point_X4(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 146u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 147u ];
    return Value;
}

/**BYTE148 ~ BYTE149
 * * 湿式制动校准点X5
Range 范围: 0.000 ~ 5.000 V
Resolution 分辨率: 0.001 V
Value in EEPROM: Data * 1000
在EEPROM里的值：数据 * 1000
*/
uint16_t Val_EOL_0301_Wet_Brake_Calibration_Point_X5(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 148u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 149u ];
    return Value;
}

/**BYTE150 ~ BYTE151
 * * 湿式制动校准点X6
Range 范围: 0.000 ~ 5.000 V
Resolution 分辨率: 0.001 V
Value in EEPROM: Data * 1000
在EEPROM里的值：数据 * 1000
*/
uint16_t Val_EOL_0301_Wet_Brake_Calibration_Point_X6(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 150u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 151u ];
    return Value;
}

/**BYTE152 ~ BYTE153
 * * 湿式制动校准点X7
Range 范围: 0.000 ~ 5.000 V
Resolution 分辨率: 0.001 V
Value in EEPROM: Data * 1000
在EEPROM里的值：数据 * 1000
*/
uint16_t Val_EOL_0301_Wet_Brake_Calibration_Point_X7(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 152u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 153u ];
    return Value;
}

/**BYTE154 ~ BYTE155
 * * 湿式制动校准点Y1
Range 范围: 0.00 ~ 200.00 bar
Resolution 分辨率: 0.01 bar
Value in EEPROM: Data * 100
在EEPROM里的值：数据 * 100
*/
uint16_t Val_EOL_0301_Wet_Brake_Calibration_Point_Y1(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 154u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 155u ];
    return Value;
}

/**BYTE156 ~ BYTE157
 * * 湿式制动校准点Y2
Range 范围: 0.00 ~ 200.00 bar
Resolution 分辨率: 0.01 bar
Value in EEPROM: Data * 100
在EEPROM里的值：数据 * 100
*/
uint16_t Val_EOL_0301_Wet_Brake_Calibration_Point_Y2(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 156u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 157u ];
    return Value;
}

/**BYTE158 ~ BYTE159
 * * 湿式制动校准点Y3
Range 范围: 0.00 ~ 200.00 bar
Resolution 分辨率: 0.01 bar
Value in EEPROM: Data * 100
在EEPROM里的值：数据 * 100
*/
uint16_t Val_EOL_0301_Wet_Brake_Calibration_Point_Y3(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 158u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 159u ];
    return Value;
}

/**BYTE160 ~ BYTE161
 * * 湿式制动校准点Y4
Range 范围: 0.00 ~ 200.00 bar
Resolution 分辨率: 0.01 bar
Value in EEPROM: Data * 100
在EEPROM里的值：数据 * 100
*/
uint16_t Val_EOL_0301_Wet_Brake_Calibration_Point_Y4(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 160u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 161u ];
    return Value;
}

/**BYTE162 ~ BYTE163
 * * 湿式制动校准点Y5
Range 范围: 0.00 ~ 200.00 bar
Resolution 分辨率: 0.01 bar
Value in EEPROM: Data * 100
在EEPROM里的值：数据 * 100
*/
uint16_t Val_EOL_0301_Wet_Brake_Calibration_Point_Y5(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 162u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 163u ];
    return Value;
}

/**BYTE164 ~ BYTE165
 * * 湿式制动校准点Y6
Range 范围: 0.00 ~ 200.00 bar
Resolution 分辨率: 0.01 bar
Value in EEPROM: Data * 100
在EEPROM里的值：数据 * 100
*/
uint16_t Val_EOL_0301_Wet_Brake_Calibration_Point_Y6(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 164u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 165u ];
    return Value;
}

/**BYTE166 ~ BYTE167
 * * 湿式制动校准点Y6
Range 范围: 0.00 ~ 200.00 bar
Resolution 分辨率: 0.01 bar
Value in EEPROM: Data * 100
在EEPROM里的值：数据 * 100
*/
uint16_t Val_EOL_0301_Wet_Brake_Calibration_Point_Y7(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 166u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 167u ];
    return Value;
}

/**BYTE168 ~ BYTE169
 * * 变速箱油压校准点X1
Range 范围: 0.000 ~ 5.000 V
Resolution 分辨率: 0.001 V
Value in EEPROM: Data * 1000
在EEPROM里的值：数据 * 1000
*/
uint16_t Val_EOL_0301_Transmission_Oil_Pressure_Calibration_Point_X1(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 168u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 169u ];
    return Value;
}

/**BYTE170 ~ BYTE171
 * * 变速箱油压校准点X2
Range 范围: 0.000 ~ 5.000 V
Resolution 分辨率: 0.001 V
Value in EEPROM: Data * 1000
在EEPROM里的值：数据 * 1000
*/
uint16_t Val_EOL_0301_Transmission_Oil_Pressure_Calibration_Point_X2(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 170u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 171u ];
    return Value;
}

/**BYTE172 ~ BYTE173
 * * 变速箱油压校准点X3
Range 范围: 0.000 ~ 5.000 V
Resolution 分辨率: 0.001 V
Value in EEPROM: Data * 1000
在EEPROM里的值：数据 * 1000
*/
uint16_t Val_EOL_0301_Transmission_Oil_Pressure_Calibration_Point_X3(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 172u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 173u ];
    return Value;
}

/**BYTE174 ~ BYTE175
 * * 变速箱油压校准点X4
Range 范围: 0.000 ~ 5.000 V
Resolution 分辨率: 0.001 V
Value in EEPROM: Data * 1000
在EEPROM里的值：数据 * 1000
*/
uint16_t Val_EOL_0301_Transmission_Oil_Pressure_Calibration_Point_X4(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 174u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 175u ];
    return Value;
}

/**BYTE176 ~ BYTE177
 * * 变速箱油压校准点X5
Range 范围: 0.000 ~ 5.000 V
Resolution 分辨率: 0.001 V
Value in EEPROM: Data * 1000
在EEPROM里的值：数据 * 1000
*/
uint16_t Val_EOL_0301_Transmission_Oil_Pressure_Calibration_Point_X5(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 176u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 177u ];
    return Value;
}

/**BYTE178 ~ BYTE179
 * * 变速箱油压校准点X6
Range 范围: 0.000 ~ 5.000 V
Resolution 分辨率: 0.001 V
Value in EEPROM: Data * 1000
在EEPROM里的值：数据 * 1000
*/
uint16_t Val_EOL_0301_Transmission_Oil_Pressure_Calibration_Point_X6(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 178u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 179u ];
    return Value;
}

/**BYTE180 ~ BYTE181
 * * 变速箱油压校准点X7
Range 范围: 0.000 ~ 5.000 V
Resolution 分辨率: 0.001 V
Value in EEPROM: Data * 1000
在EEPROM里的值：数据 * 1000
*/
uint16_t Val_EOL_0301_Transmission_Oil_Pressure_Calibration_Point_X7(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 180u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 181u ];
    return Value;
}

/**BYTE182 ~ BYTE183
 * * 变速箱油压校准点Y1
Range 范围: 0.000 ~ 5.000 V
Resolution 分辨率: 0.001 V
Value in EEPROM: Data * 1000
在EEPROM里的值：数据 * 1000
*/
uint16_t Val_EOL_0301_Transmission_Oil_Pressure_Calibration_Point_Y1(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 182u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 183u ];
    return Value;
}

/**BYTE184 ~ BYTE185
 * * 变速箱油压校准点Y2
Range 范围: 0.000 ~ 5.000 V
Resolution 分辨率: 0.001 V
Value in EEPROM: Data * 1000
在EEPROM里的值：数据 * 1000
*/
uint16_t Val_EOL_0301_Transmission_Oil_Pressure_Calibration_Point_Y2(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 184u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 185u ];
    return Value;
}

/**BYTE186 ~ BYTE187
 * * 变速箱油压校准点Y3
Range 范围: 0.000 ~ 5.000 V
Resolution 分辨率: 0.001 V
Value in EEPROM: Data * 1000
在EEPROM里的值：数据 * 1000
*/
uint16_t Val_EOL_0301_Transmission_Oil_Pressure_Calibration_Point_Y3(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 186u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 187u ];
    return Value;
}

/**BYTE188 ~ BYTE189
 * * 变速箱油压校准点Y4
Range 范围: 0.000 ~ 5.000 V
Resolution 分辨率: 0.001 V
Value in EEPROM: Data * 1000
在EEPROM里的值：数据 * 1000
*/
uint16_t Val_EOL_0301_Transmission_Oil_Pressure_Calibration_Point_Y4(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 188u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 189u ];
    return Value;
}

/**BYTE190 ~ BYTE191
 * * 变速箱油压校准点Y5
Range 范围: 0.000 ~ 5.000 V
Resolution 分辨率: 0.001 V
Value in EEPROM: Data * 1000
在EEPROM里的值：数据 * 1000
*/
uint16_t Val_EOL_0301_Transmission_Oil_Pressure_Calibration_Point_Y5(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 190u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 191u ];
    return Value;
}

/**BYTE192 ~ BYTE193
 * * 变速箱油压校准点Y6
Range 范围: 0.000 ~ 5.000 V
Resolution 分辨率: 0.001 V
Value in EEPROM: Data * 1000
在EEPROM里的值：数据 * 1000
*/
uint16_t Val_EOL_0301_Transmission_Oil_Pressure_Calibration_Point_Y6(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 192u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 193u ];
    return Value;
}

/**BYTE194 ~ BYTE195
 * * 变速箱油压校准点Y7
Range 范围: 0.000 ~ 5.000 V
Resolution 分辨率: 0.001 V
Value in EEPROM: Data * 1000
在EEPROM里的值：数据 * 1000
*/
uint16_t Val_EOL_0301_Transmission_Oil_Pressure_Calibration_Point_Y7(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 194u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 195u ];
    return Value;
}

/**BYTE196 ~ BYTE197
 * * 电压传感器_未命名1校准点 X1
Range 范围: 0.000 ~ 5.000 V
Resolution 分辨率: 0.001 V
Value in EEPROM: Data * 1000
在EEPROM里的值：数据 * 1000
*/
uint16_t Val_EOL_0301_Voltage_Sensor_Unnamed1_Calibration_Point_X1(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 196u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 197u ];
    return Value;
}

/**BYTE198 ~ BYTE199
 * * 电压传感器_未命名1校准点 X2
Range 范围: 0.000 ~ 5.000 V
Resolution 分辨率: 0.001 V
Value in EEPROM: Data * 1000
在EEPROM里的值：数据 * 1000
*/
uint16_t Val_EOL_0301_Voltage_Sensor_Unnamed1_Calibration_Point_X2(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 198u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 199u ];
    return Value;
}

/**BYTE200 ~ BYTE201
 * * 电压传感器_未命名1校准点 X3
Range 范围: 0.000 ~ 5.000 V
Resolution 分辨率: 0.001 V
Value in EEPROM: Data * 1000
在EEPROM里的值：数据 * 1000
*/
uint16_t Val_EOL_0301_Voltage_Sensor_Unnamed1_Calibration_Point_X3(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 200u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 201u ];
    return Value;
}

/**BYTE202 ~ BYTE203
 * * 电压传感器_未命名1校准点 X4
Range 范围: 0.000 ~ 5.000 V
Resolution 分辨率: 0.001 V
Value in EEPROM: Data * 1000
在EEPROM里的值：数据 * 1000
*/
uint16_t Val_EOL_0301_Voltage_Sensor_Unnamed1_Calibration_Point_X4(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 202u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 203u ];
    return Value;
}

/**BYTE204 ~ BYTE205
 * * 电压传感器_未命名1校准点 X5
Range 范围: 0.000 ~ 5.000 V
Resolution 分辨率: 0.001 V
Value in EEPROM: Data * 1000
在EEPROM里的值：数据 * 1000
*/
uint16_t Val_EOL_0301_Voltage_Sensor_Unnamed1_Calibration_Point_X5(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 204u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 205u ];
    return Value;
}

/**BYTE206 ~ BYTE207
 * * 电压传感器_未命名1校准点 X6
Range 范围: 0.000 ~ 5.000 V
Resolution 分辨率: 0.001 V
Value in EEPROM: Data * 1000
在EEPROM里的值：数据 * 1000
*/
uint16_t Val_EOL_0301_Voltage_Sensor_Unnamed1_Calibration_Point_X6(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 206u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 207u ];
    return Value;
}

/**BYTE208 ~ BYTE209
 * * 电压传感器_未命名1校准点 X6
Range 范围: 0.000 ~ 5.000 V
Resolution 分辨率: 0.001 V
Value in EEPROM: Data * 1000
在EEPROM里的值：数据 * 1000
*/
uint16_t Val_EOL_0301_Voltage_Sensor_Unnamed1_Calibration_Point_X7(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 208u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 209u ];
    return Value;
}

/**BYTE210 ~ BYTE211
 * * 电压传感器_未命名1校准点 Y1
*/
uint16_t Val_EOL_0301_Voltage_Sensor_Unnamed1_Calibration_Point_Y1(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 210u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 211u ];
    return Value;
}

/**BYTE212 ~ BYTE213
 * * 电压传感器_未命名1校准点 Y2
*/
uint16_t Val_EOL_0301_Voltage_Sensor_Unnamed1_Calibration_Point_Y2(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 212u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 213u ];
    return Value;
}

/**BYTE214 ~ BYTE215
 * * 电压传感器_未命名1校准点 Y3
*/
uint16_t Val_EOL_0301_Voltage_Sensor_Unnamed1_Calibration_Point_Y3(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 214u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 215u ];
    return Value;
}

/**BYTE216 ~ BYTE217
 * * 电压传感器_未命名1校准点 Y4
*/
uint16_t Val_EOL_0301_Voltage_Sensor_Unnamed1_Calibration_Point_Y4(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 216u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 217u ];
    return Value;
}

/**BYTE218 ~ BYTE219
 * * 电压传感器_未命名1校准点 Y5
*/
uint16_t Val_EOL_0301_Voltage_Sensor_Unnamed1_Calibration_Point_Y5(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 218u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 219u ];
    return Value;
}

/**BYTE220 ~ BYTE221
 * * 电压传感器_未命名1校准点 Y6
*/
uint16_t Val_EOL_0301_Voltage_Sensor_Unnamed1_Calibration_Point_Y6(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 220u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 221u ];
    return Value;
}

/**BYTE222 ~ BYTE223
 * * 电压传感器_未命名1校准点 Y7
*/
uint16_t Val_EOL_0301_Voltage_Sensor_Unnamed1_Calibration_Point_Y7(void)
{
    uint16_t Value = 0;
    Value = EOL_0301.Data [ 222u ];
    Value = Value << 8u;
    Value = Value | EOL_0301.Data [ 223u ];
    return Value;
}