#include "TYW_stdint.h"
#include "Telltales_Lib.h"
#include "Telltales_user.h"

uint8_t AllIndicatorLight[m_LED_Driver_Warning + 2] = {0}; // 全部灯显示状态,+2中，一个为第0个灯是空，第二个为索引从零开始，有m_LED_Driver_Warning+1个灯
uint8_t DisplayQueue[6] = {0};                   // 当前显示队列
uint8_t AlldisplayQueue[m_LED_Driver_Warning + 1] = {0};               // 所有显示队列，有m_LED_Driver_Warning+1个灯
static uint8_t g_u8QueueSize = 0;                // 当前队列中的元素数量
static uint8_t g_u8Currently_displayed_icon = 0; // 当前显示图标
static uint8_t g_u8Currently_displayed_page = 0; // 当前显示页
static uint8_t g_u8Page_Timing = 0;              // 页面切换时间

static void DeactivateIcon(uint8_t id);

// 遍历每个灯的状态
void AddIndicationLight(void)
{
    uint8_t i;
    uint8_t j;
    uint8_t k;
    uint8_t LED_Index = 0;
    uint8_t Flag = 0; // 当前全部显示队列中有此灯时（不需要添加指示灯）为0，有指示灯为1

    for (i = 0; i <= m_LED_Driver_Warning; i++)
    {
        LED_Index = i + 1;
        AllIndicatorLight[LED_Index] = Get_TelltalesLedSts(i);

        // 如果有指示灯，添加指示灯到全部显示队列中
        if (AllIndicatorLight[LED_Index] != 0)
        {
            for (j = 0; j <= m_LED_Driver_Warning; j++)
            {
                // 如果全部显示队列中有此灯
                if (AlldisplayQueue[j] == LED_Index)
                {
                    Flag = 0;
                    break;
                }
                else
                {
                    Flag = 1;
                }
            }

            // 如果全部显示队列中无此灯
            if (Flag == 1)
            {
                AlldisplayQueue[g_u8QueueSize] = LED_Index; // 添加指示灯到全部显示队列中

                //如果添加在了当前页，重新计时
                if (g_u8QueueSize == 0)
                {
                    if (g_u8Currently_displayed_page == 0)
                    {
                        g_u8Page_Timing = 0;
                    }
                }
                else
                {
                    if ((g_u8QueueSize / 6) == g_u8Currently_displayed_page)
                    {
                        g_u8Page_Timing = 0;
                    }
                }
                g_u8QueueSize++;
            }
        }
    }

    // 删除指示灯
    for (k = 0; k < g_u8QueueSize; k++)
    {

        // 当前显示队列的灯熄灭
        if (AllIndicatorLight[AlldisplayQueue[k]] == 0)
        {
            DeactivateIcon(AlldisplayQueue[k]);
        }
    }
}

// 删除报警灯
void DeactivateIcon(uint8_t id)
{
    uint8_t i = 0;
    uint8_t j = 0;
    for (i = 0; i < g_u8QueueSize; i++)
    {
        // 定位灯的位置并删除
        if (AlldisplayQueue[i] == id)
        {
            AlldisplayQueue[i] = 0;

            // 如果删除的图标是当前页图标，重新计时
            if (i == 0)
            {
                if (g_u8Currently_displayed_page == 0)
                {
                    g_u8Page_Timing = 0;
                }
            }
            else
            {
                if ((i / 6) == g_u8Currently_displayed_page)
                {
                    g_u8Page_Timing = 0;
                }
            }
        }

        // 重新排序
        if (AlldisplayQueue[i] == 0)
        {
            for (j = i; j < g_u8QueueSize; j++)
            {
                AlldisplayQueue[j] = AlldisplayQueue[j + 1];
            }
            g_u8QueueSize--;
        }
    }
}

void DisplayLightService(void)
{
    uint8_t i;

    //每次时间为0的时候刷新显示
    if (g_u8Page_Timing == 0)
    {
        g_u8Currently_displayed_icon = g_u8Currently_displayed_page * 6;
        if (AlldisplayQueue[g_u8Currently_displayed_icon] != 0)
        {
            for (i = 0; i < 6; i++)
            {
                DisplayQueue[i] = AlldisplayQueue[g_u8Currently_displayed_icon];
                g_u8Currently_displayed_icon++;
            }
        }
        g_u8Page_Timing++;
    }

    //时间未满3s，则++
    else if (g_u8Page_Timing <= 30)
    {
        g_u8Page_Timing++;
    }

    //时间满5s清空计时
    else
    {
        g_u8Page_Timing = 0;
        g_u8Currently_displayed_page++;

        //循环一遍之后清空页数
        if((g_u8Currently_displayed_page * 6) > g_u8QueueSize)
        {
            g_u8Currently_displayed_page = 0;
        }
    }


}


