

#ifndef _POPUP_LIST_H_
#define _POPUP_LIST_H_

#include "TYW_stdint.h"
#include "Popup_Lib.h"

#define POPUP_NONE 0xFFFFu /*无报警*/

/******************************************************************************
报警类型定义
******************************************************************************/
#define POPUP_TYPE_FATAL     0x00u /*严重报警信息*/
#define POPUP_TYPE_HINT      0x01u /*提示信息*/
#define POPUP_TYPE_WARNING   0x02u /*报警信息*/
#define POPUP_TYPE_EXCEPTION 0x04u /*特殊信息*/

/******************************************************************************
报警类型定义
******************************************************************************/
#define POPUP_PRO_W1  0x00u
#define POPUP_PRO_W2  0x01u
#define POPUP_PRO_OP1 0x02u
#define POPUP_PRO_D1  0x03u
#define POPUP_PRO_D2  0x04u
#define POPUP_PRO_OP2 0x05u
#define POPUP_PRO_OP3 0x06u
#define POPUP_PRO_OP4 0x07u
#define POPUP_PRO_OP5 0x08u

/******************************************************************************
显示/声音模式
******************************************************************************/
#define POPUP_MODE_MULTI  0x00u /*可多次触发*/
#define POPUP_MODE_SINGLE 0x01u /*只触发一次*/

/******************************************************************************
+15 On / Off
******************************************************************************/
#define POPUP_IGN_OFF    0x00u
#define POPUP_IGN_ON     0x01u
#define POPUP_IGN_ON_OFF 0x02u

/******************************************************************************
显示时间 宏定义
******************************************************************************/
#define POPUP_DISP_NONE   0u
#define POPUP_DISP_1S     10u
#define POPUP_DISP_1S5    15u
#define POPUP_DISP_2S     20u
#define POPUP_DISP_3S     30u
#define POPUP_DISP_4S     40u
#define POPUP_DISP_5S     50u
#define POPUP_DISP_6S     60u
#define POPUP_DISP_8S     80u
#define POPUP_DISP_AlWAYS 0xFFu

/******************************************************************************
报警名称列表

注意：1. 报警名称所指代的序号应与该报警位于报警属性表中的序号一一对应
      2. 标注有的"[报警类]"的为报警类名称,不可直接用于报警的申请与删除,但可用于
         该类报警的查询
******************************************************************************/
enum PopupName
{                                            // 序号 功能 类型 存储 文字
    // POPUP_ID_CloseDoor_To_Lock,              // 001  F10  OP2  否  请关好车门再闭锁
    POPUP_ID_Not_Disconnect_The_Power,       // 0  F10  OP2  否  请勿断开电源
    POPUP_ID_Primary_limits_the_remaining_time, //初级限制系统激活剩余时间
    POPUP_ID_Severely_limits_the_remaining_time, //严重限制系统激活剩余时间
    POPUP_ID_Maintenance_Tips,               // 1  F10  OP2  否  保养提示   5S
    POPUP_MAX
};



/******************************************************************************
报警属性结构
******************************************************************************/
extern const Popup_Attribute_t PopupAttributeTable [ POPUP_MAX ];

#endif
