#ifndef _POPUP_MESSAGE_LIST_H_
#define _POPUP_MESSAGE_LIST_H_

#include "TYW_stdint.h"
/******************************************************************************
报警文字消息名称列表
******************************************************************************/
enum PopupMessageName
{                                                   // 序号 功能 类型 存储 文字
    POPUP_MSG_Oil_Pressure = 0ul,                   // 001  F1   W2   是  机油压力异常

    POPUP_MSG_MAX,
};

/******************************************************************************
消息类型定义
******************************************************************************/
#define POPUP_TYPE_GENERAL  0x0u /*一般消息*/
#define POPUP_TYPE_TPMS     0x1u /*胎压消息*/
#define POPUP_TYPE_DOOR     0x2u /*门开消息*/
#define POPUP_TYPE_RADAR    0x3u /*雷达消息*/
#define POPUP_TYPE_SERVICE  0x4u /*保养消息*/
#define POPUP_TYPE_OVSPD    0x5u /*超速消息*/
#define POPUP_TYPE_KEYS     0x6u /*按键激活消息*/
#define POPUP_TYPE_SYSFAULT 0x7u /*系统故障*/
#define POPUP_TYPE_DYNAMIC  0x8u /*动态报警*/

/******************************************************************************
伪文字消息列表
******************************************************************************/
#define POPUP_MSG_NONE 0xFFFFu

/******************************************************************************
报警文字消息属性
******************************************************************************/
typedef struct
{
    uint8_t Type;     /*类型*/
    uint8_t Function; /*功能类型*/
    uint8_t Number;   /*编号*/
    uint8_t u8IPSubNum; /* 报警功能类编号 */
    uint8_t u8IPWarMessage; /* 报警信息编号 */
} PopupMsgAttributeStruct;

extern const PopupMsgAttributeStruct PopupMsgAttributeTable [ POPUP_MSG_MAX ];

#endif
