
#ifndef RTE_GPIO_H
#define RTE_GPIO_H

#include "TYW_stdint.h"
#include "GPIO.h"

/* ----- xcmg */

#define  VCC_3V3_EN      GPIO_OUT_PORT11_PIN04
#define  Power_3V3_Ctrl  GPIO_OUT_PORT09_PIN05
#define  AMT_PWRCTL_3V3  GPIO_OUT_PORT08_PIN07
#define  VCC_1V3_EN      GPIO_OUT_PORT11_PIN03
#define  MCU_STBYB_LCD   GPIO_OUT_PORT08_PIN11
#define  MCU_RSTB_LCD    GPIO_OUT_PORT08_PIN10
#define  PWR_1530_EN     GPIO_OUT_PORT08_PIN08

/* 切电 */
#define VCC5V_LED GPIO_OUT_PORT10_PIN15
#define Sye_KL15_LINE GPIO_IN_PORT08_PIN03

#define LED_21036_Ctrl  GPIO_OUT_PORT08_PIN04

#define EEORIN_SCL_INPUT (GPIO_IN_PORT08_PIN01)
#define EEORIN_SDA_INPUT (GPIO_IN_PORT08_PIN00)

#define EEORIN_SCL_OUT (GPIO_OUT_PORT08_PIN01)
#define EEORIN_SDA_OUT (GPIO_OUT_PORT08_PIN00)

#define EEORIN_SCLDIR (GPIO_DIR_PORT08_PIN01)
#define EEORIN_SDADIR (GPIO_DIR_PORT08_PIN00)

#define LED_SDB GPIO_OUT_PORT00_PIN14
#define LED_SDA GPIO_OUT_PORT00_PIN11
#define LED_SDA_IN GPIO_IN_PORT00_PIN11
#define LED_SDA_DIR GPIO_DIR_PORT00_PIN11

#define LED_SCL_DIR GPIO_DIR_PORT00_PIN12
#define LED_SCL GPIO_OUT_PORT00_PIN12
#define LED_SCL_IN GPIO_IN_PORT00_PIN12


#define B_CAN_STB       GPIO_OUT_PORT00_PIN07

#define I2C_SDA_6416_IN    GPIO_IN_PORT10_PIN02
#define I2C_SDA_6416_OUT   GPIO_OUT_PORT10_PIN02
#define I2C_SDA_6416_DIR   GPIO_DIR_PORT10_PIN02

#define I2C_SCL_6416_IN    GPIO_IN_PORT10_PIN03
#define I2C_SCL_6416_OUT   GPIO_OUT_PORT10_PIN03
#define I2C_SCL_6416_DIR   GPIO_DIR_PORT10_PIN03

#define TCA6416_POWER      GPIO_OUT_PORT11_PIN07
#define TCA6416_RST        GPIO_OUT_PORT10_PIN01

#define LED_HI_BEAM        GPIO_IN_PORT00_PIN13     //远光灯
// #define LED_Transmission_High       GPIO_IN_APORT00_PIN10       //变速箱油温传感器
#define LED_RIGHT          GPIO_IN_PORT00_PIN01     //右转向
#define LED_LAMPLET        GPIO_IN_PORT00_PIN02     //小灯
#define LED_LEFT           GPIO_IN_PORT00_PIN03     //左转向
#define L_FuelSend_OUT     GPIO_OUT_PORT09_PIN02
#define LINE_IN_Get_Water_InThe_Oil     GPIO_IN_PORT08_PIN09    //油中有水
#define Right_Key          GPIO_IN_PORT08_PIN06     //右键
#define Left_Key           GPIO_IN_PORT08_PIN05     //左键


#define Power_5V_EN GPIO_OUT_PORT10_PIN06

/******************************************************************************
函数接口
******************************************************************************/
void RTE_GPIO_30_Init(void);    // 30初始化
void GPIO_Sleep_Init(void);     //睡眠初始化
void GPIO_Wakeup_Init(void);    //唤醒初始化

void RTE_GPIO_SET_WakeUp(void);
void RTE_GPIO_Init(void);
void RTE_GPIO_Wakeup_Init(void);
void RTE_GPIO_Sleep_Init(void);
void RTE_GPIO_Open_Device(void);
void RTE_GPIO_OFF_Device(void);
// void RTE_GPIO_Squence(void);
void RTE_PowerOFF_Squence(void);
void RTE_OPEN_STB(void);

#endif
