
#ifndef _SOUND_PLAYER_H_
#define _SOUND_PLAYER_H_

#include "TYW_stdint.h"
#include "Sound_Source.h"

extern volatile uint8_t SoundPlaySeatbeltSync;
#define SND_SEATBELT_SYNC SoundPlaySeatbeltSync

typedef enum
{
    SND_PLAYER_IDLE,
    SND_PLAYER_PEEPARE,
    SND_PLAYER_PLAY_REQ,
    SND_PLAYER_PLAYING,
    SND_PLAYER_PLAY_END,
    SND_PLAYER_STOP_REQ,
} EN_SND_PLAYER_ST;

#define SND_VOLUME_HI  8
#define SND_VOLUME_MID 4
#define SND_VOLUME_LOW 1

typedef struct
{
    EN_SND_PLAYER_ST Status;
    uint32_t         Playing;
    uint32_t         Timer;
    uint32_t         Cycle;
    uint32_t         PrepareTimer;
    uint8_t          VolInit;

} SoundPlayCtrlStruct;

void     Sound_Player_Init(void);
uint8_t  Sound_Play(uint32_t SoundID);
uint8_t  Sound_Stop(uint32_t SoundID);
void     Sound_Clear(void);
uint32_t Sound_Priority_Query(uint32_t SoundID);

void Sound_Play_Service(void);
void DIAG_SoundPlay(void);
void DIAG_SoundStop(void);

uint8_t  Get_SND_SEATBELT_SYNC(void);
void     ReSet_SND_SEATBELT_SYNC(void);
uint32_t GetCurSndSrcIndx(void); /*获取正在播放报警音源号*/
/* 播放指定声音，在某个通道 0~3*/
/* 参数  TrackID 音源ID, channel 为通道号码,  cycles 播放周期*/
void    I2S_MAX98357_Play(uint8_t TrackID, uint8_t Channel, unsigned int cycles);
void    BuzzerForceCtrlRequest(void);
void    BuzzerForceCtrlRelease(void);
uint8_t GetBuzzerForceCtrlSta(void);
void    BuzzerCtrlPlayBack(void);
void    BuzzerCtrlStopPlaying(void);
uint8_t Get_SoundPlayCtrlPlaying(void);
void    Set_Sound_Volume(uint8_t Volume);
uint8_t Get_Sound_Volume(void);
void    Set_Sound_Type(uint8_t SoundType);
uint8_t Get_Sound_Type(void);

void SoundType30Init(void);

void BuzzerFactoryInit(void);
void BuzzerFactoryCtrl_1(uint32_t cmd, uint32_t val);
void BuzzerFactoryRelease(void);
#endif
