#include "UDS_28Service_Filter.h"

/**
  *28服务是否支持功能寻址
  *功能寻址下屏蔽该负反馈
  *@return 负反馈编号
  */
uint8_t UDS_28Service_NRC11(void)
{
    uint8_t NRC = positiveResponse;
    return NRC;
}

/**
  *28服务会话是否支持验证
  *功能寻址下屏蔽该负反馈
  *@return 负反馈编号
  */
uint8_t UDS_28Service_NRC7F(void)
{
    uint8_t NRC = positiveResponse;
    if ( getSessionType( ) != ExtendedDiagnosticSession )
    {
        NRC = serviceNotSupportedInActiveSession;
        if(DiagMSG.msgID == DIAG_ID_Rx_PHY)
        {
            UDS_Service_Response(0x28u, NEGATIVE_RSP, DIAG_ID_Tx, 1u, ( uint8_t * )&NRC);
        }
    }
    else
    {
        NRC = positiveResponse;
    }
    return NRC;
}

/**
  *28服务解锁等级验证
  *@return 负反馈编号
  */
uint8_t UDS_28Service_NRC33(void)
{
    uint8_t NRC = positiveResponse;
    return NRC;
}

/**
  *28服务最小长度验证
  *@return 负反馈编号
  */
uint8_t UDS_28Service_NRC13_MinLengthCheck(void)
{
    uint8_t NRC = positiveResponse;

    if ( DiagMSG.msgDLC != 2u )
    {
        NRC = incorrectMessageLength;
        UDS_Service_Response(0x28u, NEGATIVE_RSP, DIAG_ID_Tx, 1u, ( uint8_t * )&NRC);
    }
    else
    {
        NRC = positiveResponse;
    }
    return NRC;
}

/**
  *28服务超出请求范围验证
  *功能寻址下屏蔽该负反馈
  *@return 负反馈编号
  */
uint8_t UDS_28Service_NRC31(void)
{
    uint8_t NRC = positiveResponse;
    if ( (DiagMSG.msgData.S28Detail.ContrlType != normalMsg) && (DiagMSG.msgData.S28Detail.ContrlType != networkManagementMsg) && (DiagMSG.msgData.S28Detail.ContrlType != networkManagementMsgAndnormalMsg) )
    {
        NRC = requestOutOfRange;
        if ( DiagMSG.msgID == DIAG_ID_Rx_PHY )
        {
            UDS_Service_Response(0x28u, NEGATIVE_RSP, DIAG_ID_Tx, 1u, ( uint8_t * )&NRC);
        }
    }
    else
    {
        NRC = positiveResponse;
    }
    return NRC;
}

/**
  *28服务总长度长度验证
  *@return 负反馈编号
  */
uint8_t UDS_28Service_NRC13_TotalLengthCheck(void)
{
    uint8_t NRC = positiveResponse;
    /*
    if(DiagMSG.msgDLC != 2u)
    {
        NRC = incorrectMessageLength;
        UDS_Service_Response(0x28u, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&NRC);
    }
    else
    {
        NRC = positiveResponse;
    }
    */
    return NRC;
}

/**
  *28服务条件验证
  *@return 负反馈编号
  */
uint8_t UDS_28Service_NRC22(void)
{
    uint8_t NRC = positiveResponse;
    if ( getSpeed( ) >= 3u )
    {
        NRC = conditionsNotCorrect;
        UDS_Service_Response(0x28u, NEGATIVE_RSP, DIAG_ID_Tx, 1u, ( uint8_t * )&NRC);
    }
    else if ( getESpeed( ) > 400u )
    {
        NRC = conditionsNotCorrect;
        UDS_Service_Response(0x28u, NEGATIVE_RSP, DIAG_ID_Tx, 1u, ( uint8_t * )&NRC);
    }
    else
    {
        NRC = positiveResponse;
    }
    return NRC;
}

/**
  *28服务子功能最小长度验证
  *@return 负反馈编号
  */
uint8_t UDS_28Service_Sub_NRC13_MinLengthCheck(void)
{
    uint8_t NRC = positiveResponse;
    if ( DiagMSG.msgData.S28Detail.SubID == enableRxAndTx )
    {
        if ( DiagMSG.msgDLC < 2u )
        {
            NRC = incorrectMessageLength;
            UDS_Service_Response(0x28u, NEGATIVE_RSP, DIAG_ID_Tx, 1u, ( uint8_t * )&NRC);
        }
        else
        {
            NRC = positiveResponse;
        }
    }
    if ( DiagMSG.msgData.S28Detail.SubID == enableRxAndDisableTx )
    {
        if ( DiagMSG.msgDLC < 2u )
        {
            NRC = incorrectMessageLength;
            UDS_Service_Response(0x28u, NEGATIVE_RSP, DIAG_ID_Tx, 1u, ( uint8_t * )&NRC);
        }
        else
        {
            NRC = positiveResponse;
        }
    }
    if ( DiagMSG.msgData.S28Detail.SubID == disableRxAndEnableTx )
    {
        if ( DiagMSG.msgDLC < 2u )
        {
            NRC = incorrectMessageLength;
            UDS_Service_Response(0x28u, NEGATIVE_RSP, DIAG_ID_Tx, 1u, ( uint8_t * )&NRC);
        }
        else
        {
            NRC = positiveResponse;
        }
    }
    if ( DiagMSG.msgData.S28Detail.SubID == disableRxAndTx )
    {
        if ( DiagMSG.msgDLC < 2u )
        {
            NRC = incorrectMessageLength;
            UDS_Service_Response(0x28u, NEGATIVE_RSP, DIAG_ID_Tx, 1u, ( uint8_t * )&NRC);
        }
        else
        {
            NRC = positiveResponse;
        }
    }
    return NRC;
}

/**
  *28服务子功能是否支持验证
  *功能寻址下屏蔽该负反馈
  *@return 负反馈编号
  */
uint8_t UDS_28Service_Sub_NRC12(void)
{
    uint8_t NRC = positiveResponse;
    if ( (DiagMSG.msgData.S28Detail.SubID == enableRxAndTx) ||/* (DiagMSG.msgData.S28Detail.SubID == enableRxAndDisableTx) || (DiagMSG.msgData.S28Detail.SubID == disableRxAndEnableTx) || */(DiagMSG.msgData.S28Detail.SubID == disableRxAndTx) )
    {
        NRC = positiveResponse;
    }
    else
    {
        NRC = subFunctionNotSupported;
        if ( DiagMSG.msgID == DIAG_ID_Rx_PHY )
        {
            UDS_Service_Response(0x28u, NEGATIVE_RSP, DIAG_ID_Tx, 1u, ( uint8_t * )&NRC);
        }
    }
    return NRC;
}

/**
  *28服务子功能会话是否支持验证
  *功能寻址下屏蔽该负反馈
  *@return 负反馈编号
  */
uint8_t UDS_28Service_Sub_NRC7E(void)
{
    uint8_t NRC = positiveResponse;
    return NRC;
}

/**
  *28服务子功能超出请求范围验证
  *功能寻址下屏蔽该负反馈
  *@return 负反馈编号
  */
uint8_t UDS_28Service_Sub_NRC31(void)
{
    uint8_t NRC = positiveResponse;
    if ( (DiagMSG.msgData.S28Detail.ContrlType != normalMsg) && (DiagMSG.msgData.S28Detail.ContrlType != networkManagementMsg) && (DiagMSG.msgData.S28Detail.ContrlType != networkManagementMsgAndnormalMsg) )
    {
        NRC = requestOutOfRange;
        if ( DiagMSG.msgID == DIAG_ID_Rx_PHY )
        {
            UDS_Service_Response(0x28u, NEGATIVE_RSP, DIAG_ID_Tx, 1u, ( uint8_t * )&NRC);
        }
    }
    else
    {
        NRC = positiveResponse;
    }
    return NRC;
}

/**
  *28服务子功能总长度长度验证
  *@return 负反馈编号
  */
uint8_t UDS_28Service_Sub_NRC13_TotalLengthCheck(void)
{
    uint8_t NRC = positiveResponse;
    if ( DiagMSG.msgData.S28Detail.SubID == enableRxAndTx )
    {
        if ( DiagMSG.msgDLC != 2u )
        {
            NRC = incorrectMessageLength;
            UDS_Service_Response(0x28u, NEGATIVE_RSP, DIAG_ID_Tx, 1u, ( uint8_t * )&NRC);
        }
        else
        {
            NRC = positiveResponse;
        }
    }
    if ( DiagMSG.msgData.S28Detail.SubID == enableRxAndDisableTx )
    {
        if ( DiagMSG.msgDLC != 2u )
        {
            NRC = incorrectMessageLength;
            UDS_Service_Response(0x28u, NEGATIVE_RSP, DIAG_ID_Tx, 1u, ( uint8_t * )&NRC);
        }
        else
        {
            NRC = positiveResponse;
        }
    }
    if ( DiagMSG.msgData.S28Detail.SubID == disableRxAndEnableTx )
    {
        if ( DiagMSG.msgDLC != 2u )
        {
            NRC = incorrectMessageLength;
            UDS_Service_Response(0x28u, NEGATIVE_RSP, DIAG_ID_Tx, 1u, ( uint8_t * )&NRC);
        }
        else
        {
            NRC = positiveResponse;
        }
    }
    if ( DiagMSG.msgData.S28Detail.SubID == disableRxAndTx )
    {
        if ( DiagMSG.msgDLC != 2u )
        {
            NRC = incorrectMessageLength;
            UDS_Service_Response(0x28u, NEGATIVE_RSP, DIAG_ID_Tx, 1u, ( uint8_t * )&NRC);
        }
        else
        {
            NRC = positiveResponse;
        }
    }
    return NRC;
}

/**
  *28服务子功能请求顺序验证
  *@return 负反馈编号
  */
uint8_t UDS_28Service_Sub_NRC24(void)
{
    uint8_t NRC = positiveResponse;
    return NRC;
}

/**
  *28服务子功能条件验证
  *@return 负反馈编号
  */
uint8_t UDS_28Service_Sub_NRC22(void)
{
    uint8_t NRC = positiveResponse;
    return NRC;
}
