#include "UDS_2EService_Filter.h"

const uint8_t  S2EDLC [] = {    90u,    224u, };
const uint16_t S2EDID [] = {0x0300u, 0x0301u, };

/**
  *2E�����Ƿ�֧�ֹ���Ѱַ
  *����Ѱַ�����θø�����
  *@return ���������
  */
uint8_t UDS_2EService_NRC11(void)
{
    uint8_t NRC = positiveResponse;
    if ( DiagMSG.msgID == DIAG_ID_Rx_FUN )
    {
        NRC = serviceNotSupported;
    }
    return NRC;
}

/**
  *2E����Ự�Ƿ�֧����֤
  *����Ѱַ�����θø�����
  *@return ���������
  */
uint8_t UDS_2EService_NRC7F(void)
{
    uint8_t NRC = positiveResponse;
    if ( getSessionType( ) == DefaultSession )
    {
        NRC = serviceNotSupportedInActiveSession;
        UDS_Service_Response(0x2Eu, NEGATIVE_RSP, DIAG_ID_Tx, 1u, ( uint8_t * )&NRC);
    }
    else
    {
        NRC = positiveResponse;
    }
    return NRC;
}

/**
  *2E��������ȼ���֤
  *@return ���������
  */
uint8_t UDS_2EService_NRC33(void)
{
    uint8_t NRC = positiveResponse;
    if ( getSecurityLevel( ) == NormalKeyUnlock )
    {
        NRC = positiveResponse;
    }
    else if ( (getDID(DiagMSG.msgData.DidDetail.DID_H, DiagMSG.msgData.DidDetail.DID_L) == 0xF1F0u) && (getSecurityLevel( ) == BootKeyUnlock) )
    {
        NRC = positiveResponse;
    }
    else
    {
        NRC = securityAccessDenied;
        UDS_Service_Response(0x2Eu, NEGATIVE_RSP, DIAG_ID_Tx, 1u, ( uint8_t * )&NRC);
    }
    return NRC;
}

/**
  *2E������С������֤
  *@return ���������
  */
uint8_t UDS_2EService_NRC13_MinLengthCheck(void)
{
    uint8_t NRC = positiveResponse;
    if ( DiagMSG.msgDLC < 3u )
    {
        NRC = incorrectMessageLength;
        UDS_Service_Response(0x2Eu, NEGATIVE_RSP, DIAG_ID_Tx, 1u, ( uint8_t * )&NRC);
    }
    else
    {
        NRC = positiveResponse;
    }
    return NRC;
}

/**
  *2E���񳬳�����Χ��֤
  *����Ѱַ�����θø�����
  *@return ���������
  */
uint8_t UDS_2EService_NRC31(void)
{
    uint8_t i;
    uint8_t j;
    uint8_t NRC = requestOutOfRange;
    for ( i = 0u; i < DIM(S2EDID); ++i )
    {
        if ( getDID(DiagMSG.msgData.DidDetail.DID_H, DiagMSG.msgData.DidDetail.DID_L) == S2EDID [ i ] )
        {
            NRC = positiveResponse;
        }
    }
    if ( (NRC == requestOutOfRange) && (DiagMSG.msgID == DIAG_ID_Rx_PHY) )
    {
        UDS_Service_Response(0x2Eu, NEGATIVE_RSP, DIAG_ID_Tx, 1u, ( uint8_t * )&NRC);
    }
    return NRC;
}

/**
  *2E�����ܳ��ȳ�����֤
  *@return ���������
  */
uint8_t UDS_2EService_NRC13_TotalLengthCheck(void)
{
    uint8_t i;
    uint8_t NRC = positiveResponse;
    for ( i = 0u; i < DIM(S2EDID); ++i )
    {
        if ( getDID(DiagMSG.msgData.DidDetail.DID_H, DiagMSG.msgData.DidDetail.DID_L) == S2EDID [ i ] )
        {
            if ( DiagMSG.msgDLC != (S2EDLC [ i ] + 2u) )
            {
                NRC = incorrectMessageLength;
                UDS_Service_Response(0x2Eu, NEGATIVE_RSP, DIAG_ID_Tx, 1u, ( uint8_t * )&NRC);
            }
            else
            {
                NRC = positiveResponse;
            }
            break;
        }
    }
    return NRC;
}

/**
  *2E����������֤
  *@return ���������
  */
uint8_t UDS_2EService_NRC22(void)
{
    uint8_t NRC = positiveResponse;
    if ( getSpeed( ) >= 3u )
    {
        NRC = conditionsNotCorrect;
        UDS_Service_Response(0x2Eu, NEGATIVE_RSP, DIAG_ID_Tx, 1u, ( uint8_t * )&NRC);
    }
    else if ( getESpeed( ) > 400u )
    {
        NRC = conditionsNotCorrect;
        UDS_Service_Response(0x2Eu, NEGATIVE_RSP, DIAG_ID_Tx, 1u, ( uint8_t * )&NRC);
    }
    else
    {
        NRC = positiveResponse;
    }

    if ( NRC == positiveResponse )
    {
        if ( getDID(DiagMSG.msgData.DidDetail.DID_H, DiagMSG.msgData.DidDetail.DID_L) == 0x6208u )
        {
            //if(Services_Read_ODO_ClearCnt1()>=10000u)
            if ( 0u )
            {
                NRC = conditionsNotCorrect;
                UDS_Service_Response(0x2Eu, NEGATIVE_RSP, DIAG_ID_Tx, 1u, ( uint8_t * )&NRC);
            }
            else
            {
                NRC = positiveResponse;
            }
        }
    }
    return NRC;
}
