#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <arpa/inet.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/msg.h>
#include "../lib/sock_msg.h"

int main(int argc, char *argv[])
{
    char buffer[BUFFER_SIZE];

    if (init_msg_queue() == -1)
    {
        exit(EXIT_FAILURE);
    }

    while (fgets(buffer, sizeof(buffer), stdin) != NULL)
    {
        buffer[strlen(buffer) - 1] = '\0';
        if (msg_local_send(MSG_CAN_OD, 0, (void *)buffer, (strlen(buffer) + 1)) == -1)
        {
            destroy_msg_queue();
            exit(EXIT_FAILURE);
        }
        // 清空buffer
        memset(buffer, 0, BUFFER_SIZE);
    }

    // 清理消息队列
    if (destroy_msg_queue() == -1)
    {
        exit(EXIT_FAILURE);
    }

    return 0;
}