#include <sys/ipc.h>
#include <stdint.h>
#include <stdio.h>
#include <error.h>
#include <stdlib.h>
#include <sys/msg.h>
#include <string.h>
#include "../lib/sock_msg.h"

int main(int argc, char *argv[])
{
    msg_data_t msg;

    // 初始化消息队列
    if (init_msg_queue() == -1)
    {
        exit(EXIT_FAILURE);
    }

    printf("Server is running...\n");

    while (1)
    {
        if (msg_local_recv(&msg) > 0)
        {
            printf("Received code: %d\n", msg.code);
            printf("Received type: %d\n", msg.type);
            printf("Received len: %d\n", msg.len);
            printf("Received pad: %s\n\n", (char *)(msg.pad));
            // 清空pad
            memset(msg.pad, 0, BUFFER_SIZE);
        }
        else
        {
            destroy_msg_queue();
            exit(EXIT_FAILURE);
        }
    }

    // 清理消息队列
    if (destroy_msg_queue() == -1)
    {
        exit(EXIT_FAILURE);
    }

    return 0;
}