#include "../lib/sock_msg.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#define PORT 8888 // 服务器端口号

int main()
{
    int listenfd, connfd;                 // 监听套接字和连接套接字
    struct sockaddr_in servaddr, cliaddr; // 服务器和客户端地址结构
    socklen_t cliaddr_len;                // 客户端地址长度
    char buf[BUFFER_SIZE];                // 缓冲区
    char str[INET_ADDRSTRLEN];            // IP地址字符串
    int n;                                // 读写字节数
    uint32_t ipaddr, port;                // 对端连接的IP地址和端口

    listenfd = sock_init(1, INADDR_ANY, PORT);

    cliaddr_len = sizeof(cliaddr);

    printf("waiting for client to connect...\n");

    connfd = accept(listenfd, (struct sockaddr *)&cliaddr, &cliaddr_len);
    if (connfd < 0)
    {
        perror("accept error");
    }
    else
    {
        printf("accept a new client, fd: %d\n", connfd);
    }

    sock_info(connfd, &ipaddr, &port);
    servaddr.sin_addr.s_addr = ipaddr;
    // 将获取到的字符串反转
    char *p = inet_ntoa(servaddr.sin_addr);

    printf("connected client IP: %s, port: %d\n", p, port);

    while (1)
    {
        // 循环读取客户端发送的数据，并回复
        int n = sock_read(connfd, buf, BUFFER_SIZE);
        if (n == 0)
        {
            printf("The other side has been closed.\n");
            break;
        }
        else
        {
            printf("received from %s at PORT %d\n",
                   inet_ntop(AF_INET, &cliaddr.sin_addr, str, sizeof(str)),
                   ntohs(cliaddr.sin_port));
            printf("received: %s\n", buf);
            sock_write(connfd, buf, n);
        }
    }

    sock_exit(connfd);
    sock_exit(listenfd);

    return 0;
}
