#include "../lib/sock_msg.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#define PORT 8888 // 服务器端口号

int main()
{
    int listenfd, connfd;                 // 监听套接字和连接套接字
    struct sockaddr_in servaddr, cliaddr; // 服务器和客户端地址结构
    socklen_t cliaddr_len;                // 客户端地址长度
    char buf[BUFFER_SIZE];                // 缓冲区
    char str[INET_ADDRSTRLEN];            // IP地址字符串
    int n;                                // 读写字节数

    // 创建监听套接字，使用TCP协议
    inet_pton(AF_INET, INADDR_ANY, &servaddr.sin_addr);
    listenfd = sock_init(1, servaddr.sin_addr.s_addr, PORT);

    // 接受客户端连接请求，返回连接套接字
    cliaddr_len = sizeof(cliaddr);
    connfd = accept(listenfd, (struct sockaddr *)&cliaddr, &cliaddr_len);
    if (connfd < 0)
    {
        perror("accept error");
    }
    // 打印客户端的IP地址和端口号
    printf("connected client IP: %s, port: %d\n",
           inet_ntop(AF_INET, &cliaddr.sin_addr, str, sizeof(str)),
           ntohs(cliaddr.sin_port));

    while (1)
    {

        // 循环读取客户端发送的数据，并回复
        int reg_success = sock_ev_register(connfd, sock_read, SOCK_READ);
        if (reg_success != 0)
        {
            printf("[%s],[%d],[%d]\n", __FILE__, __LINE__, reg_success);
            perror("register fail");
            return -1;
        }

        // 关闭连接套接字
        close(connfd);
    }

    // 关闭监听套接字
    close(listenfd);

    return 0;
}
