#ifndef EMULATED_EEPROM_H__
#define EMULATED_EEPROM_H__

#include "Flash_test.h"

typedef enum
{
  EEPROM_STAT_BLANK = 0U,
  EEPROM_STAT_ACTIVE,
  EEPROM_STAT_ERROR,
}EEPROM_Block_Status_en_t;

typedef enum
{
  EEPROM_RW_PASS = 0,
  EEPROM_RW_FAIL,
}EEPROM_RW_Result_en_t;

typedef enum
{
  EEPROM_STAT_IDLE = 0,
  EEPROM_STAT_BUSY,
}EEPROM_Status_en_t;

/****************************************************************************
 *   !!! The following code should be generated by configuration tool !!!   *
****************************************************************************/
enum g_enEEPROMBlockName
{
    EEPROM_BLOCK_UDS_FLAG = 0U,
    // EEPROM_BLOCK_UDS_S27 = 1U,
    // EEPROM_BLOCK_UDS_S2E = 2U,
    // EEPROM_BLOCK_UDS_CONFIG = 3U,
    // EEPROM_BLOCK_UDS_DTC = 4U,
    // EEPROM_BLOCK_ODO = 5U,
    // EEPROM_BLOCK_ODO_STAMP = 6U,
    // EEPROM_BLOCK_TRIP_STAMP = 7U,
    // EEPROM_BLOCK_SERVICE_INFO = 8U,
};

#define   EEPROM_BLOCK_UDS_FLAG_SIZE        (16U)/*Life:20.0W*/
#define   EEPROM_BLOCK_UDS_S27_SIZE         (12U)/*Life:20.0W*/
#define   EEPROM_BLOCK_UDS_S2E_SIZE         (12U)/*Life:20.0W*/
#define   EEPROM_BLOCK_UDS_CONFIG_SIZE      (40U)/*Life:20.0W*/
#define   EEPROM_BLOCK_UDS_DTC_SIZE         (56U)/*Life:20.0W*/
#define   EEPROM_BLOCK_ODO_SIZE             (4U)/*Life:1000.0W*/
#define   EEPROM_BLOCK_ODO_STAMP_SIZE       (8U)/*Life:1000.0W*/
#define   EEPROM_BLOCK_TRIP_STAMP_SIZE      (16U)/*Life:1000.0W*/
#define   EEPROM_BLOCK_SERVICE_INFO_SIZE    (56U)/*Life:20.0W*/

#define   EEPROM_TOTAL_BLOCK_NUM            (1U)/*创建的独立的负载均衡空间的个数*/

/****************************************************************************
 *             !!!          End of code generation          !!!             *
****************************************************************************/

extern void EEPROM_Init(void);

extern EEPROM_Status_en_t       EEPROM_Get_Status(void);
extern EEPROM_Block_Status_en_t EEPROM_Get_Block_Status(uint16_t u16BlockID);

extern EEPROM_RW_Result_en_t    EEPROM_Read_Data(uint16_t u16BlockID, uint32_t u32Data[], uint16_t u16Len);
extern EEPROM_RW_Result_en_t    EEPROM_Write_Data(uint16_t u16BlockID, uint32_t u32Data[], uint16_t u16Len);

#endif

