#ifndef FLASH_USER_H__
#define FLASH_USER_H__

#include  <stdint.h>
#include "py32f0xx_hal.h"

#define     FLASH_DATA_LEN             32


#define     SECTOR_0_START_ADDR        0x08000000UL
#define     SECTOR_1_START_ADDR        0x08002000UL
#define     SECTOR_2_START_ADDR        0x08004000UL
#define     SECTOR_3_START_ADDR        0x08006000UL
#define     SECTOR_4_START_ADDR        0x08008000UL
#define     SECTOR_5_START_ADDR        0x0800A000UL
#define     SECTOR_6_START_ADDR        0x0800C000UL
#define     SECTOR_7_START_ADDR        0x0800E000UL
#define     SECTOR_8_START_ADDR        0x08010000UL
#define     SECTOR_9_START_ADDR        0x08012000UL
#define     SECTOR_10_START_ADDR       0x08014000UL
#define     SECTOR_11_START_ADDR       0x08016000UL
#define     SECTOR_12_START_ADDR       0x08018000UL
#define     SECTOR_13_START_ADDR       0x0801A000UL
#define     SECTOR_14_START_ADDR       0x0801C000UL
#define     SECTOR_15_START_ADDR       0x0801E000UL


typedef enum
{
  FLASH_CONTROL_PASS = 0,
  FLASH_CONTROL_FAIL,

}Flash_User_Result_en_t;

/*传入的数据长度u32Len需为字节数*/
extern void Flash_Data_Read(uint32_t u32Addr, uint16_t u16Data[], uint32_t u32Len);
extern Flash_User_Result_en_t Flash_Data_Write(uint32_t u32Addr, uint16_t u16Data[], uint32_t u32Len);
extern Flash_User_Result_en_t Flash_Data_PageErase(uint32_t u32StartAddr, uint32_t u32EndAddr);
extern Flash_User_Result_en_t Flash_Data_SectorErase(uint32_t u32StartAddr, uint32_t u32EndAddr);
extern uint32_t Flash_Data_CheckBlank(uint32_t u32StartAddr, uint32_t u32EndAddr);

#endif