#ifndef FLASH_TEST_H__
#define FLASH_TEST_H__

#include  <stdint.h>
#include "py32f0xx_hal.h"

#define     FLASH_DATA_LEN             32


#define     SECTOR_0_START_ADDR        0x08000000UL
#define     SECTOR_1_START_ADDR        0x08002000UL
#define     SECTOR_2_START_ADDR        0x08004000UL
#define     SECTOR_3_START_ADDR        0x08006000UL
#define     SECTOR_4_START_ADDR        0x08008000UL
#define     SECTOR_5_START_ADDR        0x0800A000UL
#define     SECTOR_6_START_ADDR        0x0800C000UL
#define     SECTOR_7_START_ADDR        0x0800E000UL
#define     SECTOR_8_START_ADDR        0x08010000UL
#define     SECTOR_9_START_ADDR        0x08012000UL
#define     SECTOR_10_START_ADDR       0x08014000UL
#define     SECTOR_11_START_ADDR       0x08016000UL
#define     SECTOR_12_START_ADDR       0x08018000UL
#define     SECTOR_13_START_ADDR       0x0801A000UL
#define     SECTOR_14_START_ADDR       0x0801C000UL
#define     SECTOR_15_START_ADDR       0x0801E000UL


typedef struct
{
  uint32_t mileage1;
  uint32_t mileage2;
  uint32_t mileage3;
  uint32_t mileage4;
  uint32_t maintenance1;
  uint32_t maintenance2;
  uint32_t maintenance3;
  uint32_t maintenance4;

}LoadBalancing_NVM_Data_st_t;

// typedef union
// {
//     uint32_t MileageData [ 8 ];
//     struct
//     {
//         uint32_t mileage1;
//         uint32_t mileage2;
//         uint32_t mileage3;
//         uint32_t mileage4;
//         uint32_t maintenance1;
//         uint32_t maintenance2;
//         uint32_t maintenance3;
//         uint32_t maintenance4;
//     } LoadBalancing_NVM_Data_st_t;

// } MileageData_un_t;

typedef enum
{
  MILEAGE1 = 0,
  MILEAGE2,
  MILEAGE3,
  MILEAGE4,
  MAINTENANCE1,
  MAINTENANCE2,
  MAINTENANCE3,
  MAINTENANCE4,

}FLASH_Store_Data_en_t;


// extern LoadBalancing_NVM_Data_st_t FlashData;
extern uint32_t TestData[8];
extern uint32_t TestData1[8];
extern uint32_t TestData2[8];

extern void Test_Flash_AppointAddress_Read(uint32_t u32Addr, uint32_t u32Data[], uint32_t u32Len);
extern void Test_Flash_AppointAddress_Write(uint32_t u32Addr, uint32_t u32Data[], uint32_t u32Len);
extern void Test_Flash_AppointAddress_Erase(uint32_t u32StartAddr, uint32_t u32EndAddr);
extern void Test_Flash_AppointSector_Erase(uint32_t u32StartAddr, uint32_t u32EndAddr);
extern void Data_Create_Service(void);
extern uint32_t Test_APP_FlashBlank(uint32_t u32StartAddr, uint32_t u32EndAddr);


extern void Flash_Data_Read(uint32_t u32Addr, uint16_t u16Data[], uint32_t u32Len);
extern void Flash_Data_Write(uint32_t u32Addr, uint16_t u16Data[], uint32_t u32Len);
extern void Flash_Data_PageErase(uint32_t u32StartAddr, uint32_t u32EndAddr);
extern void Flash_Data_SectorErase(uint32_t u32StartAddr, uint32_t u32EndAddr);
extern uint32_t Flash_Data_CheckBlank(uint32_t u32StartAddr, uint32_t u32EndAddr);

#endif