// #include "r_typedefs.h"
// #include "Internal_Flash.h"
#include "Emulated_EEPROM.h"
#include "Emulated_EEPROM_Access.h"



/****************************************************************************
 *   !!! The following code should be generated by configuration tool !!!   *
 *   !!!单个数据空间最大写入的数据量为256 - 4 = 251byte                  !!!   *
****************************************************************************/

/* EEPROM_BLOCK0_BUFFER_SIZE： 1个数据块的大小，1个数据块包括索引+反索引+存储的数据+校验值。（由于普冉只支持页擦和页写，所以最小的块大小也只能是1page）*/
#define   EEPROM_BLOCK0_BUFFER_SIZE         256U                        
// uint32_t g_u32EEPROMBlock0Buffer[EEPROM_BLOCK0_BUFFER_SIZE / 4U];   /*1个数据块用到的数据数组的大小，根据数组的数据类型来，uint16的就/2，uint32的就/4*/
uint16_t g_u32EEPROMBlock0Buffer[EEPROM_BLOCK0_BUFFER_SIZE / 2U];   /*1个数据块用到的数据数组的大小，根据数组的数据类型来，uint16的就/2，uint32的就/4*/


static const EEPROM_Block_st_t g_stEEPROMBlockTable[] = 
{
    /*u32UsageTimes                    u32StartAddr             u32EndAddr          u32DataSize                     pu16DataBuffer */
    {EEPROM_TARGET_ERASE_NUM,         SECTOR_14_START_ADDR,    0x0801E7FFUL,       EEPROM_BLOCK0_BUFFER_SIZE,      g_u32EEPROMBlock0Buffer,},
    // {EEPROM_TARGET_ERASE_NUM1,        SECTOR_12_START_ADDR,    0x0801A7FFUL,       EEPROM_BLOCK0_BUFFER_SIZE,      g_u32EEPROMBlock0Buffer,},
};

/****************************************************************************
 *             !!!          End of code generation          !!!             *
****************************************************************************/

EEPROM_Block_Access_st_t g_stEEPROMBlockAccess[EEPROM_TOTAL_BLOCK_NUM];

EEPROM_Init_Status_en_t EEPROM_Init(void)
{
    EEPROM_Media_Access_st_t stFlashAccessFunc;
    uint8_t u8Result = 0U;

    // TYW_FDL_Init();
    
    stFlashAccessFunc.pfnMemErase    = Flash_Data_PageErase;//Int_Data_Flash_Erase;
    stFlashAccessFunc.pfnMemBlankChk = Flash_Data_CheckBlank;//Int_Data_Flash_Blank_Check;
    stFlashAccessFunc.pfnMemRead     = Flash_Data_Read;//Int_Data_Flash_Read;
    stFlashAccessFunc.pfnMemWrite    = Flash_Data_Write;//Int_Data_Flash_Write;
    
    // Int_Data_Flash_Register_P_E_Complete_Cb(EEPROM_Mem_Access_Complete_Callback);
    
    u8Result = EEPROM_Access_Init(  g_stEEPROMBlockTable,
                                    g_stEEPROMBlockAccess,
                                    &stFlashAccessFunc,
                                    EEPROM_TOTAL_BLOCK_NUM);

    if (u8Result == 0xFFU)
    {
        return EEPROM_INIT_FAIL;
    }
    else
    {
        return EEPROM_INIT_SUCCESS;
    }
}

EEPROM_Status_en_t EEPROM_Get_Status(void)
{
    EEPROM_Status_en_t enStatus;
    
    if(EEPROM_Access_Busy())
    {
        enStatus = EEPROM_STAT_BUSY;
    }
    else
    {
        enStatus = EEPROM_STAT_IDLE;
    }
    
    return enStatus;
}

EEPROM_Block_Status_en_t EEPROM_Get_Block_Status(uint16_t u16BlockID)
{
    uint8_t u8BlockStatus;
    EEPROM_Block_Status_en_t enStatus;
    
    u8BlockStatus = EEPROM_Block_Access_Status(u16BlockID);
    if (u8BlockStatus == EEPROM_BLOCK_BLANK)
    {
        enStatus = EEPROM_STAT_BLANK;
    }
    else if (u8BlockStatus == EEPROM_BLOCK_ACTIVE)
    {
        enStatus = EEPROM_STAT_ACTIVE;
    }
    else
    {
        enStatus = EEPROM_STAT_ERROR;
    }
    
    return enStatus;
}

/*u16Len是32位数组的长度*/
EEPROM_RW_Result_en_t EEPROM_Read_Data(uint16_t u16BlockID, uint32_t u32Data[], uint16_t u16Len)
{
    uint8_t u8Error;
    EEPROM_RW_Result_en_t enResult;
    
    u8Error = EEPROM_Read_Block_Data(u16BlockID, u32Data, u16Len);
    if (u8Error)
    {
        enResult = EEPROM_RW_FAIL;
    }
    else
    {
        enResult = EEPROM_RW_PASS;
    }
    
    return enResult;
}

/*u16Len是32位数组的长度*/
EEPROM_RW_Result_en_t EEPROM_Write_Data(uint16_t u16BlockID, uint32_t u32Data[], uint16_t u16Len)
{
    uint8_t u8Error;
    EEPROM_RW_Result_en_t enResult;
    
    u8Error = EEPROM_Write_Block_Data(u16BlockID, u32Data, u16Len);
    if (u8Error)
    {
        enResult = EEPROM_RW_FAIL;
    }
    else
    {
        enResult = EEPROM_RW_PASS;
    }
    
    return enResult;
}

