
#ifndef EMULATED_EEPROM_ACCESS_H__
#define EMULATED_EEPROM_ACCESS_H__

#include  <stdint.h>

#define     ONE_PAGE_LEN               0x100U
#define     MAX_ERASE_FREQUENCY        100000U

typedef struct
{
    uint32_t   u32UsageTimes;
    uint32_t   u32StartAddr;
    uint32_t   u32EndAddr;
    uint32_t   u32DataSize;
    uint32_t*  pu32DataBuffer;
}EEPROM_Block_st_t;

typedef struct
{
    uint8_t    u8Status;
    uint8_t    u8SectorOffset;
    uint16_t   u16SectorSize;
    uint16_t   u16Index;
    uint16_t   u16RecordNum;
    uint16_t   u16MaxRecordNum;
    uint16_t   u16BlockSize;
    uint32_t   u32BaseAddr;
    uint32_t   u32EndAddr;
    uint32_t*  pu32Data;
}EEPROM_Block_Access_st_t;

typedef void     (*EEPROM_Mem_Erase_Func_ptr_t)     (uint32_t, uint32_t);
typedef uint32_t (*EEPROM_Mem_Blank_Chk_Func_ptr_t) (uint32_t, uint32_t);
typedef void     (*EEPROM_Mem_Read_Func_ptr_t)      (uint32_t, uint32_t*, uint32_t);
typedef void     (*EEPROM_Mem_Write_Func_ptr_t)     (uint32_t, uint32_t*, uint32_t);

typedef struct
{
    EEPROM_Mem_Erase_Func_ptr_t      pfnMemErase;
    EEPROM_Mem_Blank_Chk_Func_ptr_t  pfnMemBlankChk;
    EEPROM_Mem_Read_Func_ptr_t       pfnMemRead;
    EEPROM_Mem_Write_Func_ptr_t      pfnMemWrite;
}EEPROM_Media_Access_st_t;

#define   EEPROM_BLOCK_BLANK                (0U)
#define   EEPROM_BLOCK_ACTIVE               (1U)
#define   EEPROM_BLOCK_ERROR                (2U)

#define   EEPROM_BLOCK_CTRL_BYTE_SIZE       (8U)

extern uint8_t EEPROM_Access_Init(const  EEPROM_Block_st_t * pstBlockTable,
                        EEPROM_Block_Access_st_t * pstBlockAccess,
                        EEPROM_Media_Access_st_t * pstMediaAccess,
                        uint16_t u16BlockNum);

extern uint8_t EEPROM_Access_Busy(void);
extern uint8_t EEPROM_Block_Access_Status(uint16_t u16BlockID);
extern uint8_t EEPROM_Read_Block_Data(uint16_t u16BlockID, uint32_t u32Data[], uint16_t u16Len);
extern uint8_t EEPROM_Write_Block_Data(uint16_t u16BlockID, uint32_t u32Data[], uint16_t u16Len);
extern void EEPROM_Mem_Access_Complete_Callback(void);

#endif

