#include "RTE.h"

RTE_GPIO_IRQ_Desc_st_t      stSLEEPIRQDesc={0};

/*****************************************************************************
 * @description:外部中断回调函数，
 * @param {uint32_t} pin        
 * @param {uint8_t} u8level
 * @return {*}
 *****************************************************************************/
void RTE_SLEEP_EXTICallBack(uint32_t pin, uint8_t u8level)
{
    /* Enable SysTick interrupt */
   // HAL_ResumeTick();
  return;
}
/*****************************************************************************
 * @description: 配置指定GPIO进行休眠唤醒，这里如果中断线冲突可能注册失败，调用前先用GPIOconfig配置
 * @param {uint32_t} u32Pin
 * @param {RTE_GPIO_Interrupt_Type_en_t} EXTI_Trigger
 * @return {*}
 *****************************************************************************/
void RTE_DEEPSLEEP_GPIO_Interrupt_Enable(uint32_t u32Pin,RTE_GPIO_Interrupt_Type_en_t EXTI_Trigger)
{
    

    RTE_GPIO_Interrupt_Register(&stSLEEPIRQDesc, u32Pin, EXTI_Trigger,  RTE_SLEEP_EXTICallBack);
    RTE_GPIO_Interrupt_Enable(&stSLEEPIRQDesc);
}
/*****************************************************************************
 * @description: 配置休眠唤醒相关参数和使能
 * @param {uint32_t} u32StopVoltSelection       
 * @param {uint32_t} u32StopFlashDelay
 * @param {uint32_t} u32StopWakeUpHsiEnableTime
 * @return {*}
 *****************************************************************************/
void RTE_DEEPSLEEP_Enable(uint32_t u32StopVoltSelection, uint32_t u32StopFlashDelay, uint32_t u32StopWakeUpHsiEnableTime)
{

      PWR_StopModeConfigTypeDef PwrStopModeConf = {0};

      /* Suspend SysTick interrupt */
     // HAL_SuspendTick();
      
      PwrStopModeConf.LPVoltSelection     =  u32StopVoltSelection;
      PwrStopModeConf.FlashDelay          =  u32StopFlashDelay;
      PwrStopModeConf.WakeUpHsiEnableTime =  u32StopWakeUpHsiEnableTime;
      HAL_PWR_ConfigStopMode(&PwrStopModeConf);

      /* Enter STOP mode */
      HAL_PWR_EnterSTOPMode(PWR_LOWPOWERREGULATOR_ON, PWR_STOPENTRY_WFI);  

}

