#include "RTE_RTC_PY32F072.h"
#include "main.h"

RTC_DateTypeDef RTC_DateStructure;
RTC_TimeTypeDef RTC_TimeStructure;
RTC_Information_st_t g_stRTCInformation = {
    RTC_DEFAULT_YEAR,
    RTC_DEFAULT_MONTH,
    RTC_DEFAULT_DATE,
    RTC_DEFAULT_WEEK,
    RTC_DEFAULT_HOUR,
    RTC_DEFAULT_MINUTE,
    RTC_DEFAULT_SECOND,
};

RTC_HandleTypeDef RTCinit;

/************************************************************************ 
 * @description: 
 * @param {RTC_Information_st_t} *g_stRTCInformationPart
 * @param {uint32_t} u32RTCFORMAT
 * @return {*}
 ************************************************************************/
void RTE_RTC_Init(RTC_Information_st_t *g_stRTCInformationPart, uint32_t u32RTCFORMAT)
{
    RCC_OscInitTypeDef RCC_OscInitStruct = {0};
    RCC_PeriphCLKInitTypeDef PeriphClkInitStruct = {0};

    RCC_PeriphCLKInitTypeDef RTCLCKconfig = {0};
    /* Enable access to the backup domain (RTC settings are stored in the backup domain) */
    HAL_PWR_EnableBkUpAccess();

    /*Enable RTC clock*/
    //__HAL_RCC_RTCAPB_CLK_ENABLE(); /* Enable RTC module APB clock */
    __HAL_RCC_RTC_ENABLE();        /* Enable RTC clock */

    /* RCC peripheral clock initialization */
    RTCLCKconfig.PeriphClockSelection = RCC_PERIPHCLK_RTC; /* RCC peripheral clock selection as RTC */
    RTCLCKconfig.RTCClockSelection = RCC_RTCCLKSOURCE;     /* RTC source selection as LSI */
    HAL_RCCEx_PeriphCLKConfig(&RTCLCKconfig);

    /* RTC initialization */
    RTCinit.Instance          = RTC;                        /* Select RTC */
    RTCinit.Init.AsynchPrediv = RTC_AUTO_1_SECOND; /* Automatic calculation of RTC's 1-second time base */
    RTCinit.Init.OutPut       = RTC_OUTPUTSOURCE_NONE;   /* No output on the TAMPER pin */

    RTC_TimeStructure.Hours   = g_stRTCInformationPart->u8RTCHour;
    RTC_TimeStructure.Minutes = g_stRTCInformationPart->u8RTCMinute;
    RTC_TimeStructure.Seconds = g_stRTCInformationPart->u8RTCSecond;

    // 日期：星期一，2025年1月1日
    RTC_DateStructure.WeekDay = g_stRTCInformationPart->u8RTCDayOfWeek;
    RTC_DateStructure.Date    = g_stRTCInformationPart->u8RTCDayOfMonth;
    RTC_DateStructure.Month   = g_stRTCInformationPart->u8RTCMonth;
    RTC_DateStructure.Year    = g_stRTCInformationPart->u8RTCYear;

    /* RTC deinitialization */
    HAL_RTC_DeInit(&RTCinit);

    /* RTC initialization */
    HAL_RTC_Init(&RTCinit);

    HAL_RTC_SetDate(&RTCinit, &RTC_DateStructure, u32RTCFORMAT);
    /* Set RTC current time in binary format */
    HAL_RTC_SetTime(&RTCinit, &RTC_TimeStructure, u32RTCFORMAT);
}
/************************************************************************ 
 * @description: 
 * @param {RTC_TimeTypeDef} *RTC_UserTimeStruct
 * @param {RTC_DateTypeDef} *RTC_UserDateStruct
 * @param {uint32_t} u32RTCFORMAT   时间格式
 * @return {*}
 ************************************************************************/
void RTE_RTC_Set_Time(RTC_TimeTypeDef *RTC_UserTimeStruct, RTC_DateTypeDef *RTC_UserDateStruct, uint32_t u32RTCFORMAT)

{
    HAL_RTC_SetTime(&RTCinit, RTC_UserTimeStruct, u32RTCFORMAT);
    HAL_RTC_SetDate(&RTCinit, RTC_UserDateStruct, u32RTCFORMAT);
}
/************************************************************************ 
 * @description: 
 * @param {RTC_TimeTypeDef} *RTC_UserTimeStruct
 * @param {RTC_DateTypeDef} *RTC_UserDateStruct
 * @param {uint32_t} u32RTCFORMAT   时间格式
 * @return {*}
 ************************************************************************/
void UPDATE_RTC_GET_DATETIME(RTC_TimeTypeDef *RTC_UserTimeStruct, RTC_DateTypeDef *RTC_UserDateStruct, uint32_t u32RTCFORMAT)
{
    HAL_RTC_GetTime(&RTCinit, RTC_UserTimeStruct, u32RTCFORMAT);
    HAL_RTC_GetDate(&RTCinit, RTC_UserDateStruct, u32RTCFORMAT);
}
