//#include "stddef.h"
//#include "Tick_Timer\RTE_Tick_Timer.h"
#include "RTE_Tick_Timer.h"
#include "main.h"
#include "RTE.h"
#include "Sys_Scheduler.h"
#define   RTE_TICK_TIMER_CLK_SRC_FREQ       (72000000UL)

RTE_Tick_Timer_Call_Back_ptr_t   g_pfnRTETickTimerCallBackFunc = NULL;
extern unsigned int g_Flag;
void SysTick_Handler(void);
 
void RTE_Tick_Timer_Start(uint32_t u32Interval, RTE_Tick_Timer_Call_Back_ptr_t pfnCallBack)
{
    uint32_t u32ReloadVal;
    u32ReloadVal = RTE_TICK_TIMER_CLK_SRC_FREQ / 1000000UL;
    u32ReloadVal = u32ReloadVal * u32Interval - 1UL;
    
    NVIC_DisableIRQ(SysTick_IRQn);

    SysTick->CTRL  = SysTick_CTRL_CLKSOURCE_Msk | SysTick_CTRL_TICKINT_Msk;
    SysTick->LOAD  = u32ReloadVal;
    SysTick->VAL   = 0UL;
    
    g_pfnRTETickTimerCallBackFunc = pfnCallBack;

    SysTick->CTRL |= SysTick_CTRL_ENABLE_Msk;

    HAL_NVIC_SetPriority(SysTick_IRQn, 0, 0);
    HAL_NVIC_EnableIRQ(SysTick_IRQn);
}

void RTE_Tick_Timer_Stop(void)
{
    NVIC_DisableIRQ(SysTick_IRQn);
    SysTick->CTRL  = 0UL;
    SysTick->VAL   = 0UL;
}

uint8_t g_u8TickTimeradd = 0;
void SysTick_Handler(void)
{
    g_u8TickTimeradd++;
    if (g_u8TickTimeradd >= 20)
    {
        HAL_IncTick();
        g_u8TickTimeradd = 0U;
    }
    
    if (g_pfnRTETickTimerCallBackFunc != NULL)
    {
        g_pfnRTETickTimerCallBackFunc();
    }
    Sys_Exact_50us_Tasks();
}
