#include "main.h"
#include "RTE.h"

#define   RTE_WDT_CLK_SRC_FREQ              (32000U)


IWDG_HandleTypeDef   IwdgHandle = {0};


/**
 * @description: 看门狗使能
 * @return {*}
 */
void RTE_WDT_Enable(void)
{
    #if __DEBUG
        __HAL_DBGMCU_FREEZE_IWDG();
    #endif

     //相关使能
     //__HAL_RCC_SYSCFG_CLK_ENABLE();
     //__HAL_RCC_PWR_CLK_ENABLE();
     //RCC_EnableLsi(ENABLE);本芯片自动LSI使能

      IwdgHandle.Instance = IWDG;                     /* Select IWDG */
      IwdgHandle.Init.Prescaler = IWDG_PRESCALER;  /* Configure prescaler as 32 */
      IwdgHandle.Init.Reload = IWDG_RELOAD;           /* IWDG counter reload value is 1024, 1s */
      /* Initialize IWDG */
       if (HAL_IWDG_Init(&IwdgHandle) != HAL_OK)       
     {
        //APP_ErrorHandler();
     }

}
/*****************************************************************************
 * @description: FLASH用户选项配置字里选择关门狗休眠冻结，执行HAL_FLASH_OB_Launch会复位一次
 * @return {*}
 *****************************************************************************/
void RTE_WDT_Disable(void)
{

    if( READ_BIT(FLASH->OPTR, FLASH_OPTR_IWDG_STOP) == OB_IWDG_STOP_FREEZE)
        return;
    FLASH_OBProgramInitTypeDef OBInitCfg={0};
    HAL_FLASH_Unlock();        /* Unlock Flash */
    HAL_FLASH_OB_Unlock();     /* Unlock Option */
    OBInitCfg.OptionType = OPTIONBYTE_USER;
    OBInitCfg.USERType   = OB_USER_IWDG_STOP;
    OBInitCfg.USERConfig = OB_IWDG_STOP_FREEZE;
     /* Start option byte programming */
    HAL_FLASH_OBProgram(&OBInitCfg);
    HAL_FLASH_Lock();      /* Lock Flash */
    HAL_FLASH_OB_Lock();   /* Lock Option */
    /* Option Launch */
    HAL_FLASH_OB_Launch();
    
}
/*****************************************************************************
 * @description: 看门狗刷新
 * @return {*}
 *****************************************************************************/
void RTE_WDT_Clear(void)
{
    //IWDG_ReloadKey();
    if (HAL_IWDG_Refresh(&IwdgHandle) != HAL_OK)
    {
      //APP_ErrorHandler();
    }
}
