#include "main.h"
#include "RTE.h"

static ADC_HandleTypeDef        AdcHandle          = {0};
static ADC_ChannelConfTypeDef   ADC_InitStructure  = {0};
static uint8_t u8ADC_State = 0;

static uint8_t    u8ADC_CHseq  =  0;           //记录通道轮转状态                   
static uint8_t    u8ADC_CHidex =  0xFF;        //控制需要转换的通道组，防止重复添加
static uint32_t   u32Ad_CH_Record[ADC_CH_NUMS] = {0xFFFFFFFF}; //记录需要转换的通道
static uint16_t   u16AdDatelist[ADC_CH_NUMS];  //临时记录获取的通道转换结果

   
uint32_t   u32ADC_CHS[24] = 
{
    ADC_CHANNEL_0,
    ADC_CHANNEL_1,
    ADC_CHANNEL_2,
    ADC_CHANNEL_3,
    ADC_CHANNEL_4,
    ADC_CHANNEL_5,
    ADC_CHANNEL_6,
    ADC_CHANNEL_7,
    ADC_CHANNEL_8,
    ADC_CHANNEL_9,
    ADC_CHANNEL_10,
    ADC_CHANNEL_11,
    ADC_CHANNEL_12,
    ADC_CHANNEL_13,
    ADC_CHANNEL_14,
    ADC_CHANNEL_15,
    ADC_CHANNEL_16,
    ADC_CHANNEL_17,
    ADC_CHANNEL_18,
    ADC_CHANNEL_19,
    ADC_CHANNEL_20,
    ADC_CHANNEL_21,
    ADC_CHANNEL_22,
    ADC_CHANNEL_23,
};

/************************************************************************ 
 * @description:adc初始化，通道需要添加进轮转的通道组内 
 * @param {uint8_t} u8ChList    暂时不用这种方式添加
 * @param {uint8_t} u8ChNum     通道号
 * @return {*}
 ************************************************************************/
void RTE_ADC_Init(const uint8_t u8ChList[], uint8_t u8ChNum)
{
    GPIO_InitTypeDef         GPIO_InitStructure = {0};
    RCC_PeriphCLKInitTypeDef RCC_PeriphCLKInit  = {0};
    uint8_t i;

	if(u8ChNum<=7)
	{   
	    __HAL_RCC_GPIOA_CLK_ENABLE();    
	    GPIO_InitStructure.Pull = GPIO_NOPULL;
		GPIO_InitStructure.Pin  = 1U << u8ChNum;  
		GPIO_InitStructure.Mode = GPIO_MODE_ANALOG; 
		HAL_GPIO_Init(GPIOA, &GPIO_InitStructure);
	}
	else if((u8ChNum==8)||(u8ChNum==9))
	{   
	    __HAL_RCC_GPIOB_CLK_ENABLE();    
            GPIO_InitStructure.Pull = GPIO_NOPULL;
		GPIO_InitStructure.Pin  = (u8ChNum==8? ((uint16_t)0x0001):((uint16_t)0x0002));  //PB0或PB1
		GPIO_InitStructure.Mode = GPIO_MODE_ANALOG;  
		HAL_GPIO_Init(GPIOB, &GPIO_InitStructure);
	}
	else if (u8ChNum >= 10 && u8ChNum <= 15)
	{
	    u8ChNum-=10;
		 __HAL_RCC_GPIOC_CLK_ENABLE();    
	    GPIO_InitStructure.Pull = GPIO_NOPULL;
		GPIO_InitStructure.Pin  = 1U << u8ChNum;  
		GPIO_InitStructure.Mode = GPIO_MODE_ANALOG; 
		HAL_GPIO_Init(GPIOC, &GPIO_InitStructure);
        u8ChNum+=10;
	}

    AdcHandle.Instance = ADC1;
    AdcHandle.Init.Resolution            = ADC_RESOLUTION_12B;        /* 12-bit resolution for converted data */
    AdcHandle.Init.DataAlign             = ADC_DATAFORMAT;            /* Right-alignment for converted data */
    AdcHandle.Init.ScanConvMode          = ADC_SCAN_DISABLE;          /* *Scan mode off */
    AdcHandle.Init.ContinuousConvMode    = DISABLE;                   /* Single mode */
    AdcHandle.Init.NbrOfConversion       = 1;                         /* Number of conversion channels 1 */
    AdcHandle.Init.DiscontinuousConvMode = DISABLE;                   /* Discontinuous mode not enabled */
    AdcHandle.Init.NbrOfDiscConversion   = 1;                         /* Discontinuous mode short sequence length is 1 */
    AdcHandle.Init.ExternalTrigConv      = ADC_SOFTWARE_START;         /* *software trigger */
    
    /* Enable ADC clock */
    __HAL_RCC_ADC_CLK_ENABLE();
    RCC_PeriphCLKInit.PeriphClockSelection= RCC_PERIPHCLK_ADC;
    RCC_PeriphCLKInit.ADCClockSelection   = RCC_ADCCLKSOURCE_PCLK_DIV8;
    HAL_RCCEx_PeriphCLKConfig(&RCC_PeriphCLKInit);

    ADC_InitStructure.Channel = u32ADC_CHS[u8ChNum];
    if(u8ADC_CHidex == 0xFF)
    {
        u8ADC_CHidex = 0;
        u32Ad_CH_Record[u8ADC_CHidex] = ADC_InitStructure.Channel;
        
    }
    else 
    {
      for(i = 0; i <= u8ADC_CHidex; i++)
          {  
              if(ADC_InitStructure.Channel == u32Ad_CH_Record[i])
                  break;            
          }
      if (i > u8ADC_CHidex)
          {
            u8ADC_CHidex++;
            u32Ad_CH_Record[u8ADC_CHidex] = ADC_InitStructure.Channel; 
          }
    }
        
    ADC_InitStructure.SamplingTime = ADC_SAMPLETIME;
    
    if (HAL_ADC_Init(&AdcHandle) != HAL_OK)
    {
     //APP_ErrorHandler();
    }
    if (HAL_ADC_ConfigChannel(&AdcHandle, &ADC_InitStructure) != HAL_OK)
    {
    //APP_ErrorHandler();
    }
    /* ADC calibration */
   if(HAL_ADCEx_Calibration_Start(&AdcHandle) != HAL_OK)
   {//如果想校准必须在启动前
    //APP_ErrorHandler();
   }
    HAL_NVIC_SetPriority(ADC_COMP_IRQn, 0, 0); /* Interrupt priority setting */
    HAL_NVIC_EnableIRQ(ADC_COMP_IRQn);         /* ADC interrupt enable */
}
/************************************************************************ 
 * @description: adc复位初始化
 * @return {*}
 ************************************************************************/
void RTE_ADC_DeInit(void)
{	
       __HAL_RCC_ADC_CLK_DISABLE();
       HAL_ADC_DeInit(&AdcHandle);
       NVIC_ClearPendingIRQ(ADC_COMP_IRQn);      // clear INTAD interrupt flag 
       NVIC_DisableIRQ(ADC_COMP_IRQn);           // disable INTAD interrupt 
       u8ADC_State = 0;
       u8ADC_CHidex = 0xFF;
       uint8_t i;
       for(i=0; i<ADC_CH_NUMS; i++)
            u32Ad_CH_Record[i] = 0xFFFFFFFF;
}
/************************************************************************ 
 * @description: 开启转换，按照轮转通道进行顺序转化
 * @return {*}
 ************************************************************************/
void RTE_ADC_Start_Conversion(void)
{
    /*A/D conversion for SG1 is completed*/
	NVIC_ClearPendingIRQ(ADC_COMP_IRQn);  // clear INTAD interrupt flag 
	NVIC_EnableIRQ(ADC_COMP_IRQn);		  // enable INTAD interrupt
 
    ADC_InitStructure.Channel = u32Ad_CH_Record[u8ADC_CHseq];
    ADC_InitStructure.Rank    = ADC_REGULAR_RANK_1; 
	HAL_ADC_ConfigChannel(&AdcHandle, &ADC_InitStructure);
	HAL_ADC_Start_IT(&AdcHandle);
    u8ADC_State = 1;
}
/************************************************************************ 
 * @description: STOP
 * @return {*}
 ************************************************************************/
void RTE_ADC_Stop_Conversion(void)
{
    HAL_ADC_Stop(&AdcHandle);
    u8ADC_State = 0;
}
/*****************************************************************************
 * @description:获取AD状态
 * @return {*}  0：已转换完所有通道 1：未转换完所有通道
 *****************************************************************************/
uint8_t RTE_ADC_Get_Conversion_Status(void)
{
    return u8ADC_State;
}
/*****************************************************************************
 * @description: 获取转换数据
 * @param {uint16_t} *pu16Data
 * @param {uint8_t} u8ChNum
 * @return {*}
 *****************************************************************************/
void RTE_ADC_Get_Conversion_Result(uint16_t *pu16Data, uint8_t u8ChNum)
{

	uint8_t i;
        if(pu16Data == NULL)
          return;

	if ((pu16Data != 0U) && (u8ChNum > 0U) && (u8ChNum <= ADC_CH_NUMS))
	{
            for(i=0; i < u8ChNum; i++)
            *pu16Data++ = u16AdDatelist[i];
	}
}
/*****************************************************************************
 * @description: 中断服务函数，按照转换组内的通道顺序进行转换
 * @return {*}
 *****************************************************************************/
void ADC_COMP_IRQHandler(void)
{
  if((READ_BIT(AdcHandle.Instance->SR, ADC_SR_EOC) == (ADC_SR_EOC))  != 0)
  {
     WRITE_REG(AdcHandle.Instance->SR, ~ADC_SR_EOC);
     u16AdDatelist[u8ADC_CHseq] = (uint16_t)(READ_BIT(AdcHandle.Instance->DR, ADC_DR_DATA));
     u8ADC_CHseq++;
     u8ADC_State = 0;
    if(u8ADC_CHseq >=  ADC_CH_NUMS)
    {
        u8ADC_CHseq = 0;
    }
    else
    {
        RTE_ADC_Start_Conversion();
    }
       
  }
}

