#include <stdint.h>
// #include "gpio.h"
// #include "isr.h"
// #include "RTE_CAN.h"
#include "main.h"
#include "RTE.h"
#include "CommonInterface.h"

uint8_t RxData[8] = {0};
CAN_RxHeaderTypeDef CanRxHeader;
CAN_HandleTypeDef CanHandle;
uint8_t BusoffState;
uint8_t txCplt ;

/**
 * @brief CAN就收完成回调
 *
 * @param msg
 */
void HAL_CAN_RxCpltCallback(CAN_HandleTypeDef *hcan)
{
    /* Read received data */
    if (HAL_CAN_GetRxMessage(&CanHandle, &CanRxHeader, RxData) == HAL_OK)
    {
        Can_Rx_Cak(&CanRxHeader,RxData);
    }
    
}

void HAL_CAN_PtbTxCpltCallback(CAN_HandleTypeDef *hcan)
{
    txCplt = 1;
}

void HAL_CAN_BusErrorCallback(CAN_HandleTypeDef *hcan)
{
	__HAL_RCC_CAN1_FORCE_RESET();
	__HAL_RCC_CAN1_RELEASE_RESET();
    BusoffState = 1;
}

uint8_t CAN_User_Transmit(CAN_TxHeaderTypeDef CanTxHeader, uint8_t *pData)
{
    if(txCplt == 1)
    {
        txCplt = 0; 
    }
    else
    {
        return 1;
    }
    if (HAL_CAN_AddMessageToTxFifo(&CanHandle, &CanTxHeader, pData, CAN_TX_FIFO_PTB) == HAL_OK)
    {
        if (HAL_CAN_ActivateTxRequest(&CanHandle, CAN_TXFIFO_PTB_SEND) == HAL_OK)
        {
            return 0;
        }
    }
}

void CAN_Config( void)
{
    /* Initialize CAN */
    CanHandle.Instance                      = CAN1;
    CanHandle.Init.FrameFormat              = CAN_FRAME_CLASSIC;
    CanHandle.Init.Mode                     = CAN_MODE_NORMAL;
    CanHandle.Init.Prescaler                = 9U; 
    CanHandle.Init.NominalSyncJumpWidth     = 4U;/* 250KHz */
    CanHandle.Init.NominalTimeSeg1          = 12U;
    CanHandle.Init.NominalTimeSeg2          = 4U;
    
    if (HAL_CAN_Init(&CanHandle) != HAL_OK)
    {
    }
    /* Start CAN */

    Can_RX_Apply_Buff();
    if (HAL_CAN_Start(&CanHandle) != HAL_OK)
    {
    }
    BusoffState = 0;
    txCplt = 1;
    __HAL_CAN_ENABLE_IT(&CanHandle, CAN_IT_RX_COMPLETE | CAN_IT_BUS_ERROR | CAN_IT_TX_PTB_COMPLETE);
}

/**
  * @brief  This function handles CAN Handler.
  * @param  None
  * @retval None
  */
 void CAN_IRQHandler(void)
 {
    HAL_CAN_IRQHandler(&CanHandle);
 
 }

/**
 * @brief CAN初始�?
 *
 * @param config CAN初始结构体指�?
 * @return uint8_t 0成功 1失败
 */
uint8_t rte_can_init(can_config_st_t *config)
{
    GPIO_InitTypeDef  GPIO_InitStruct = {0};

    /* enable clock */
    __HAL_RCC_CAN1_CLK_ENABLE();  /* Enable CAN clock */
    __HAL_RCC_GPIOA_CLK_ENABLE(); /* Enable GPIOA clock */
    
    /* Configure CAN pins */
    GPIO_InitStruct.Pin = GPIO_PIN_11 | GPIO_PIN_12; /* CAN_RX:PB8,CAN_TX:PB9 */
    GPIO_InitStruct.Mode = GPIO_MODE_AF_PP;
    GPIO_InitStruct.Pull = GPIO_NOPULL;
    GPIO_InitStruct.Speed = GPIO_SPEED_FREQ_VERY_HIGH;
    GPIO_InitStruct.Alternate = GPIO_AF4_CAN;
    HAL_GPIO_Init(GPIOA, &GPIO_InitStruct);

    HAL_NVIC_SetPriority(CAN_IRQn, 0, 0);
    HAL_NVIC_EnableIRQ(CAN_IRQn);
    /****** CAN bus periphal init ******/
    CAN_Config();

    return 0;
}

