#ifndef RTE_SLEEP_PY32F072_H__
#define RTE_SLEEP_PY32F072_H__
#include "main.h"

#ifdef 0
typedef struct
{
    uint32_t u32StopVoltSelection;           /*< STOP mode LPR Voltage Selection. */
    uint32_t u32StopFlashDelay;              /*< PWR_STOP_WakeUp_Flash_Delay  PWR STOP WakeUp Flash Delay. */
    uint32_t u32StopWakeUpHsiEnableTime;     /*< PWR_STOP_WakeUp_HSIEN_Timing  PWR STOP mode WakeUp HSI Enable Timing. */
}RTE_STOPMODE_Config_st_t;
#endif


#define RTE_STOPMOD_LPR_VOLT_1P2V  PWR_STOPMOD_LPR_VOLT_1P2V                /*!< After entering stop mode, VDD=1.2V */
#define RTE_STOPMOD_LPR_VOLT_1P0V  PWR_STOPMOD_LPR_VOLT_1P0V                /*!< After entering stop mode, VDD=1.0V */
#define RTE_STOPMOD_LPR_VOLT_0P9V  PWR_STOPMOD_LPR_VOLT_0P9V                /*!< After entering stop mode, VDD=0.9V */
#define RTE_STOPMOD_LPR_VOLT_0P8V  PWR_STOPMOD_LPR_VOLT_0P8V                /*!< After entering stop mode, VDD=0.8V */


#define RTE_WAKEUP_FLASH_DELAY_1US PWR_WAKEUP_FLASH_DELAY_1US               /* Wake up from the STOP mode, Delay 1us enable flash*/
#define RTE_WAKEUP_FLASH_DELAY_2US PWR_WAKEUP_FLASH_DELAY_2US               /* Wake up from the STOP mode, Delay 2us enable flash*/
#define RTE_WAKEUP_FLASH_DELAY_3US PWR_WAKEUP_FLASH_DELAY_3US               /* Wake up from the STOP mode, Delay 3us enable flash*/
#define RTE_WAKEUP_FLASH_DELAY_0US PWR_WAKEUP_FLASH_DELAY_0US               /* Wake up from the STOP mode, From Sram*/


#define RTE_WAKEUP_HSIEN_AFTER_MR  PWR_WAKEUP_HSIEN_AFTER_MR                /* Wake up from the STOP mode, After the MR becomes stable, enable HSI */
#define RTE_WAKEUP_HSIEN_IMMEDIATE PWR_WAKEUP_HSIEN_IMMEDIATE               /* Wake up from the STOP mode, Enable HSI immediately */


extern void RTE_DEEPSLEEP_GPIO_Interrupt_Enable(uint32_t u32Pin, RTE_GPIO_Interrupt_Type_en_t EXTI_Trigger);

extern void RTE_DEEPSLEEP_Enable(uint32_t u32StopVoltSelection, uint32_t u32StopFlashDelay, uint32_t u32StopWakeUpHsiEnableTime);
extern void RTE_SLEEP_EXTICallBack(uint32_t pin, uint8_t u8level);
#endif
