#ifndef RTE_UART_H__
#define RTE_UART_H__

extern UART_HandleTypeDef USART1_St;
extern UART_HandleTypeDef USART2_St;
extern UART_HandleTypeDef USART3_St;
extern UART_HandleTypeDef USART4_St;

#define READ_BIT(REG, BIT)    ((REG) & (BIT))



#define USART1_GPIOCLK       __HAL_RCC_GPIOA_CLK_ENABLE()
#define USART1_CLK           __HAL_RCC_USART1_CLK_ENABLE()
#define USART1_TXGPIOTypeDef      GPIOA
#define USART1_TXGPIOPIN          GPIO_PIN_2
#define USART1_GPIOTXAF           GPIO_AF1_USART2
#define USART1_RXGPIOTypeDef      GPIOA
#define USART1_RXGPIOPIN          GPIO_PIN_3
#define USART1_GPIORXAF           GPIO_AF1_USART2


#define USART2_GPIOCLK       __HAL_RCC_GPIOA_CLK_ENABLE()
#define USART2_CLK           __HAL_RCC_USART2_CLK_ENABLE()
#define USART2_TXGPIOTypeDef      GPIOA
#define USART2_TXGPIOPIN          GPIO_PIN_2
#define USART2_GPIOTXAF           GPIO_AF1_USART2
#define USART2_RXGPIOTypeDef      GPIOA
#define USART2_RXGPIOPIN          GPIO_PIN_3
#define USART2_GPIORXAF           GPIO_AF1_USART2

#define USART3_GPIOCLK       __HAL_RCC_GPIOC_CLK_ENABLE()
#define USART3_CLK           __HAL_RCC_USART3_CLK_ENABLE()
#define USART3_TXGPIOTypeDef      GPIOC
#define USART3_TXGPIOPIN          GPIO_PIN_2
#define USART3_GPIOTXAF           GPIO_AF9_USART3
#define USART3_RXGPIOTypeDef      GPIOC
#define USART3_RXGPIOPIN          GPIO_PIN_3
#define USART3_GPIORXAF           GPIO_AF9_USART3

#define USART4_GPIOCLK       __HAL_RCC_GPIOA_CLK_ENABLE()
#define USART4_CLK           __HAL_RCC_USART4_CLK_ENABLE()
#define USART4_TXGPIOTypeDef      GPIOA
#define USART4_TXGPIOPIN          GPIO_PIN_0
#define USART4_GPIOTXAF           GPIO_AF4_USART4
#define USART4_RXGPIOTypeDef      GPIOA
#define USART4_RXGPIOPIN          GPIO_PIN_1
#define USART4_GPIORXAF           GPIO_AF4_USART4

typedef enum
{
    RTEUSART1  = 0x00U,      
    RTEUSART2  = 0x01U,      
    RTEUSART3  = 0x02U,     
    RTEUSART4  = 0x03U    
}RET_USARTX_en_t;
    


void    RTE_USART_DeInit(UART_HandleTypeDef* USARTx);
void    RTE_USART_Init(RET_USARTX_en_t emUSARTx);

void    RTE_USART_SendData(UART_HandleTypeDef* USARTx, uint8_t *Data, uint32_t SendLen);
uint8_t RTE_USART_ReceiveData(UART_HandleTypeDef* USARTx);

uint8_t UASRT_Get_TX_Busy_Flag(void);
uint8_t UASRT_Send_Multiple_Byte(UART_HandleTypeDef* USARTx, uint8_t *Data, uint32_t Len);
uint8_t UASRT_TX_ISR(void);
#endif /* RTE_UART_H__ */
