#include <stdbool.h>
#include <stdlib.h>
#include <stdint.h>
#include "main.h"
#include "RTE.h"
#include "Application.h"

#pragma pack(4)

UART_HandleTypeDef USART1_St;
UART_HandleTypeDef USART2_St;
UART_HandleTypeDef USART3_St;
UART_HandleTypeDef USART4_St;

 
// 加对齐指令
typedef struct __attribute__((aligned(4)))
{
	uint8_t u8UartSendCount;
	uint8_t u8UartSendLen;
	uint8_t u8UartSendStatus; /*0:idle 1:busy*/
	uint8_t u8reserved;

} Uart_Send_Ctr_st_t;

Uart_Send_Ctr_st_t stUartSendCtr;

void RTE_USSART_DeInit(UART_HandleTypeDef* USARTx)
{
    HAL_UART_DeInit(USARTx);
    if(USARTx->Instance == USART1)
    {
        HAL_NVIC_DisableIRQ(USART1_IRQn);
    }
    else if(USARTx->Instance == USART2)
    {
        HAL_NVIC_DisableIRQ(USART2_IRQn);
    }
    else if(USARTx->Instance == USART3)
    {
        HAL_NVIC_DisableIRQ(USART3_4_IRQn);
    }
    else if(USARTx->Instance == USART4)
    {
        HAL_NVIC_DisableIRQ(USART3_4_IRQn);
    }
}

static void RTE_USART1_RCC_Configuration(void)
{
	/* Enable GPIO clock */
    USART1_GPIOCLK;
    USART1_CLK;
}
static void RTE_USART1_GPIO_Configuration(void)
{
    GPIO_InitTypeDef  GPIO_InitStruct = {0};
    
    GPIO_InitStruct.Pin       = USART1_TXGPIOPIN;
    GPIO_InitStruct.Mode      = GPIO_MODE_AF_PP;
    GPIO_InitStruct.Pull      = GPIO_PULLUP;
    GPIO_InitStruct.Speed     = GPIO_SPEED_FREQ_HIGH;
    GPIO_InitStruct.Alternate = USART1_GPIOTXAF;
    HAL_GPIO_Init(USART1_TXGPIOTypeDef, &GPIO_InitStruct);

    GPIO_InitStruct.Pin = USART1_RXGPIOPIN;
    GPIO_InitStruct.Alternate = USART1_GPIORXAF;
    HAL_GPIO_Init(USART1_RXGPIOTypeDef, &GPIO_InitStruct);
}


static void RTE_USART2_RCC_Configuration(void)
{
	/* Enable GPIO clock */
    USART2_GPIOCLK;
    USART2_CLK;
}
static void RTE_USART2_GPIO_Configuration(void)
{
    GPIO_InitTypeDef  GPIO_InitStruct = {0};
    
    GPIO_InitStruct.Pin       = USART2_TXGPIOPIN;
    GPIO_InitStruct.Mode      = GPIO_MODE_AF_PP;
    GPIO_InitStruct.Pull      = GPIO_PULLUP;
    GPIO_InitStruct.Speed     = GPIO_SPEED_FREQ_HIGH;
    GPIO_InitStruct.Alternate = USART2_GPIOTXAF;
    HAL_GPIO_Init(USART2_TXGPIOTypeDef, &GPIO_InitStruct);

    GPIO_InitStruct.Pin = USART2_RXGPIOPIN;
    GPIO_InitStruct.Alternate = USART2_GPIORXAF;
    HAL_GPIO_Init(USART2_RXGPIOTypeDef, &GPIO_InitStruct);
}

static void RTE_USART3_RCC_Configuration(void)
{
	/* Enable GPIO clock */
    USART3_GPIOCLK;
    USART3_CLK;
}
static void RTE_USART3_GPIO_Configuration(void)
{
    GPIO_InitTypeDef  GPIO_InitStruct = {0};
    
    GPIO_InitStruct.Pin       = USART3_TXGPIOPIN;
    GPIO_InitStruct.Mode      = GPIO_MODE_AF_PP;
    GPIO_InitStruct.Pull      = GPIO_PULLUP;
    GPIO_InitStruct.Speed     = GPIO_SPEED_FREQ_HIGH;
    GPIO_InitStruct.Alternate = USART3_GPIOTXAF;
    HAL_GPIO_Init(USART3_TXGPIOTypeDef, &GPIO_InitStruct);

    GPIO_InitStruct.Pin = USART3_RXGPIOPIN;
    GPIO_InitStruct.Alternate = USART3_GPIORXAF;
    HAL_GPIO_Init(USART3_RXGPIOTypeDef, &GPIO_InitStruct);
}

static void RTE_USART4_RCC_Configuration(void)
{
    USART4_GPIOCLK;
    USART4_CLK;
}
static void RTE_USART4_GPIO_Configuration(void)
{
    GPIO_InitTypeDef  GPIO_InitStruct = {0};
    
    GPIO_InitStruct.Pin       = USART4_TXGPIOPIN;
    GPIO_InitStruct.Mode      = GPIO_MODE_AF_PP;
    GPIO_InitStruct.Pull      = GPIO_PULLUP;
    GPIO_InitStruct.Speed     = GPIO_SPEED_FREQ_HIGH;
    GPIO_InitStruct.Alternate = USART4_GPIOTXAF;
    HAL_GPIO_Init(USART4_TXGPIOTypeDef, &GPIO_InitStruct);

    GPIO_InitStruct.Pin = USART4_RXGPIOPIN;
    GPIO_InitStruct.Alternate = USART4_GPIORXAF;
    HAL_GPIO_Init(USART4_RXGPIOTypeDef, &GPIO_InitStruct);
}

void RTE_USART_Init(RET_USARTX_en_t emUSARTx)
{
	stUartSendCtr.u8UartSendCount = 0U;
	stUartSendCtr.u8UartSendLen   = 0U;
	stUartSendCtr.u8UartSendStatus= 0U;
	stUartSendCtr.u8reserved      = 0U;

    switch (emUSARTx)
        {
         case RTEUSART1:
            {
                RTE_USART1_RCC_Configuration();
            	RTE_USART1_GPIO_Configuration();
                /* Initialize USART */
                USART1_St.Instance          = USART1;
                USART1_St.Init.BaudRate     = 115200;
                USART1_St.Init.WordLength   = UART_WORDLENGTH_8B;
                USART1_St.Init.StopBits     = UART_STOPBITS_1;
                USART1_St.Init.Parity       = UART_PARITY_NONE;
                USART1_St.Init.HwFlowCtl    = UART_HWCONTROL_NONE;
                USART1_St.Init.Mode         = UART_MODE_TX_RX;
                USART1_St.Init.OverSampling = UART_OVERSAMPLING_16;
                USART1_St.AdvancedInit.AdvFeatureInit = UART_ADVFEATURE_NO_INIT;
                HAL_UART_Init(&USART1_St);    
                HAL_NVIC_SetPriority(USART1_IRQn, 0,0);
                HAL_NVIC_EnableIRQ(USART1_IRQn);
                __HAL_UART_ENABLE_IT(&USART1_St, UART_IT_RXNE); 
            }
            break;
         case RTEUSART2:
            {
                RTE_USART2_RCC_Configuration();
            	RTE_USART2_GPIO_Configuration();
                /* Initialize USART */
                USART2_St.Instance          = USART2;
                USART2_St.Init.BaudRate     = 115200;
                USART2_St.Init.WordLength   = UART_WORDLENGTH_8B;
                USART2_St.Init.StopBits     = UART_STOPBITS_1;
                USART2_St.Init.Parity       = UART_PARITY_NONE;
                USART2_St.Init.HwFlowCtl    = UART_HWCONTROL_NONE;
                USART2_St.Init.Mode         = UART_MODE_TX_RX;
                USART2_St.Init.OverSampling = UART_OVERSAMPLING_16;
                USART2_St.AdvancedInit.AdvFeatureInit = UART_ADVFEATURE_NO_INIT;
                HAL_UART_Init(&USART2_St);    
                HAL_NVIC_SetPriority(USART2_IRQn, 0,0);
                HAL_NVIC_EnableIRQ(USART2_IRQn);
                __HAL_UART_ENABLE_IT(&USART2_St, UART_IT_RXNE); 
            }
            break;
         case RTEUSART3:
            {
                RTE_USART3_RCC_Configuration();
            	RTE_USART3_GPIO_Configuration();
                /* Initialize USART */
                USART3_St.Instance          = USART3;
                USART3_St.Init.BaudRate     = 115200;
                USART3_St.Init.WordLength   = UART_WORDLENGTH_8B;
                USART3_St.Init.StopBits     = UART_STOPBITS_1;
                USART3_St.Init.Parity       = UART_PARITY_NONE;
                USART3_St.Init.HwFlowCtl    = UART_HWCONTROL_NONE;
                USART3_St.Init.Mode         = UART_MODE_TX_RX;
                USART3_St.Init.OverSampling = UART_OVERSAMPLING_16;
                USART3_St.AdvancedInit.AdvFeatureInit = UART_ADVFEATURE_NO_INIT;
                HAL_UART_Init(&USART3_St);    
                HAL_NVIC_SetPriority(USART3_4_IRQn, 0,0);
                HAL_NVIC_EnableIRQ(USART3_4_IRQn);
                __HAL_UART_ENABLE_IT(&USART3_St, UART_IT_RXNE); 
            }
            break;
          case RTEUSART4:
            {
                RTE_USART4_RCC_Configuration();
            	RTE_USART4_GPIO_Configuration();
                /* Initialize USART */
                USART4_St.Instance          = USART4;
                USART4_St.Init.BaudRate     = 115200;
                USART4_St.Init.WordLength   = UART_WORDLENGTH_8B;
                USART4_St.Init.StopBits     = UART_STOPBITS_1;
                USART4_St.Init.Parity       = UART_PARITY_NONE;
                USART4_St.Init.HwFlowCtl    = UART_HWCONTROL_NONE;
                USART4_St.Init.Mode         = UART_MODE_TX_RX;
                USART4_St.Init.OverSampling = UART_OVERSAMPLING_16;
                USART4_St.AdvancedInit.AdvFeatureInit = UART_ADVFEATURE_NO_INIT;
                HAL_UART_Init(&USART4_St);    
                HAL_NVIC_SetPriority(USART3_4_IRQn, 0,0);
                HAL_NVIC_EnableIRQ(USART3_4_IRQn);
                __HAL_UART_ENABLE_IT(&USART4_St, UART_IT_RXNE); 
            }
            break;
          default:break;
        
        }
    
}

uint8_t USART_Get_TX_Busy_Flag(void)
{

	return stUartSendCtr.u8UartSendStatus;
}

/*因本项目使用外部全局数组进行数据发送，函数内部不额外拷贝一次数据了*/
uint8_t USART_Send_Multiple_Byte(UART_HandleTypeDef* USARTx, uint8_t *Data, uint32_t Len)
{
    uint32_t u32UARTResult = 1UL;
    if(USARTx == NULL)
        return u32UARTResult;
    
	if ((USART_Get_TX_Busy_Flag() == 0U) && (Len <= 255))
	{
		stUartSendCtr.u8UartSendCount = 0U;
		stUartSendCtr.u8UartSendLen = Len;
		stUartSendCtr.u8UartSendStatus = 1U;

		u32UARTResult = 0UL;
		/*使能中断*/
        __HAL_UART_ENABLE_IT(USARTx, UART_IT_TXE);    
	}
	return u32UARTResult;
}


void RTE_USART_SendData(UART_HandleTypeDef* USARTx, uint8_t *Data, uint32_t SendLen)
{

    HAL_UART_Transmit(USARTx, Data, SendLen, 500);//超时时间需要注意合理设置
}

    

uint8_t RTE_USART_ReceiveData(UART_HandleTypeDef* USARTx)
{
       uint32_t u32UARTResult = 1UL;
       if(USARTx == NULL)
        {
            return u32UARTResult;
        }
       return (uint8_t)(READ_BIT(USARTx->Instance->DR, USART_DR_DR));
}


uint8_t USART_TX_ISR(UART_HandleTypeDef* USARTx)
{
    uint32_t u32UARTResult = 1UL;
    if(USARTx == NULL)
        return u32UARTResult;
    
	if ((stUartSendCtr.u8UartSendLen) && (stUartSendCtr.u8UartSendCount < stUartSendCtr.u8UartSendLen))
	{
		//USART_SendData(USART2, UsartDataBuf[stUartSendCtr.u8UartSendCount++]);
		//USARTx->Instance->DR = buff[stUartSendCtr.u8UartSendCount++];
	}
	else /*发送完成或者异常*/
	{
		//USART_ConfigInt(USART2, USART_INT_TXDE, DISABLE);
        __HAL_UART_DISABLE_IT(USARTx, UART_IT_TXE);  
		stUartSendCtr.u8UartSendCount = 0U;
		stUartSendCtr.u8UartSendLen = 0U;
		stUartSendCtr.u8UartSendStatus = 0U;
	}
    return u32UARTResult;
}

void USART1_IRQHandler(void)
{
	if (__HAL_UART_GET_FLAG(&USART1_St, UART_FLAG_RXNE) != RESET)
	{
	    __HAL_UART_CLEAR_FLAG(&USART1_St, UART_FLAG_RXNE);
        // UART_Put(RTE_USART_ReceiveData(&USART1_St));
    }

	if (__HAL_UART_GET_FLAG(&USART1_St, UART_FLAG_TXE) != RESET)
	{
        __HAL_UART_CLEAR_FLAG(&USART1_St, UART_FLAG_TXE);
    
	}
}

void USART2_IRQHandler(void)
{
	if (__HAL_UART_GET_FLAG(&USART2_St, UART_FLAG_RXNE) != RESET)
	{
	    __HAL_UART_CLEAR_FLAG(&USART2_St, UART_FLAG_RXNE);
        // UART_Put(RTE_USART_ReceiveData(&USART2_St));
    }

	if (__HAL_UART_GET_FLAG(&USART2_St, UART_FLAG_TXE) != RESET)
	{
		/* Write one byte to the transmit data register */
        __HAL_UART_CLEAR_FLAG(&USART2_St, UART_FLAG_TXE);
        // USART_TX_ISR(&USART2_St);
	}
}

void USART3_4_IRQHandler(void)
{
	if (__HAL_UART_GET_FLAG(&USART3_St, UART_FLAG_RXNE) != RESET)
	{
	    __HAL_UART_CLEAR_FLAG(&USART3_St, UART_FLAG_RXNE); 
        // UART_Put(RTE_USART_ReceiveData(&USART3_St));
    }

	if (__HAL_UART_GET_FLAG(&USART3_St, UART_FLAG_TXE) != RESET)
	{
        __HAL_UART_CLEAR_FLAG(&USART3_St, UART_FLAG_TXE);

        //USART_TX_ISR(&USART3_St);
    } 
    
      if (__HAL_UART_GET_FLAG(&USART4_St, UART_FLAG_RXNE) != RESET)
	{
	    __HAL_UART_CLEAR_FLAG(&USART4_St, UART_FLAG_RXNE);  

        uint16_t rx_data = (uint16_t)RTE_USART_ReceiveData(&USART4_St);
        UART_Put(rx_data);
    
    }
	if (__HAL_UART_GET_FLAG(&USART4_St, UART_FLAG_TXE) != RESET)
	{
        __HAL_UART_CLEAR_FLAG(&USART4_St, UART_FLAG_TXE);
        
    } 
}

