#ifndef RTE_GPIO_PY32F072_H__
#define RTE_GPIO_PY32F072_H__
#include "main.h"

typedef struct
{
    uint32_t  u32Pin;  
    uint16_t  u16Type;
    int32_t   i32Flag;
    void     *pvHandler;
}RTE_GPIO_IRQ_Desc_st_t;


#define   RTE_GPIO_PORT_GROUP_A             (0x00U)
#define   RTE_GPIO_PORT_GROUP_B             (0x01U)
#define   RTE_GPIO_PORT_GROUP_C             (0x02U)
#define   RTE_GPIO_PORT_GROUP_F             (0x03U)

#define   RTE_GPIO_PIN_NUM_00               (0x00U)
#define   RTE_GPIO_PIN_NUM_01               (0x01U)
#define   RTE_GPIO_PIN_NUM_02               (0x02U)
#define   RTE_GPIO_PIN_NUM_03               (0x03U)
#define   RTE_GPIO_PIN_NUM_04               (0x04U)
#define   RTE_GPIO_PIN_NUM_05               (0x05U)
#define   RTE_GPIO_PIN_NUM_06               (0x06U)
#define   RTE_GPIO_PIN_NUM_07               (0x07U)
#define   RTE_GPIO_PIN_NUM_08               (0x08U)
#define   RTE_GPIO_PIN_NUM_09               (0x09U)
#define   RTE_GPIO_PIN_NUM_10               (0x0AU)
#define   RTE_GPIO_PIN_NUM_11               (0x0BU)
#define   RTE_GPIO_PIN_NUM_12               (0x0CU)
#define   RTE_GPIO_PIN_NUM_13               (0x0DU)
#define   RTE_GPIO_PIN_NUM_14               (0x0EU)
#define   RTE_GPIO_PIN_NUM_15               (0x0FU)

#define   RTE_GPIO_PORTA_PIN00              (((uint32_t)RTE_GPIO_PORT_GROUP_A << 16) | (uint32_t)RTE_GPIO_PIN_NUM_00)
#define   RTE_GPIO_PORTA_PIN01              (((uint32_t)RTE_GPIO_PORT_GROUP_A << 16) | (uint32_t)RTE_GPIO_PIN_NUM_01)
#define   RTE_GPIO_PORTA_PIN02              (((uint32_t)RTE_GPIO_PORT_GROUP_A << 16) | (uint32_t)RTE_GPIO_PIN_NUM_02)
#define   RTE_GPIO_PORTA_PIN03              (((uint32_t)RTE_GPIO_PORT_GROUP_A << 16) | (uint32_t)RTE_GPIO_PIN_NUM_03)
#define   RTE_GPIO_PORTA_PIN04              (((uint32_t)RTE_GPIO_PORT_GROUP_A << 16) | (uint32_t)RTE_GPIO_PIN_NUM_04)
#define   RTE_GPIO_PORTA_PIN05              (((uint32_t)RTE_GPIO_PORT_GROUP_A << 16) | (uint32_t)RTE_GPIO_PIN_NUM_05)
#define   RTE_GPIO_PORTA_PIN06              (((uint32_t)RTE_GPIO_PORT_GROUP_A << 16) | (uint32_t)RTE_GPIO_PIN_NUM_06)
#define   RTE_GPIO_PORTA_PIN07              (((uint32_t)RTE_GPIO_PORT_GROUP_A << 16) | (uint32_t)RTE_GPIO_PIN_NUM_07)
#define   RTE_GPIO_PORTA_PIN08              (((uint32_t)RTE_GPIO_PORT_GROUP_A << 16) | (uint32_t)RTE_GPIO_PIN_NUM_08)
#define   RTE_GPIO_PORTA_PIN09              (((uint32_t)RTE_GPIO_PORT_GROUP_A << 16) | (uint32_t)RTE_GPIO_PIN_NUM_09)
#define   RTE_GPIO_PORTA_PIN10              (((uint32_t)RTE_GPIO_PORT_GROUP_A << 16) | (uint32_t)RTE_GPIO_PIN_NUM_10)
#define   RTE_GPIO_PORTA_PIN11              (((uint32_t)RTE_GPIO_PORT_GROUP_A << 16) | (uint32_t)RTE_GPIO_PIN_NUM_11)
#define   RTE_GPIO_PORTA_PIN12              (((uint32_t)RTE_GPIO_PORT_GROUP_A << 16) | (uint32_t)RTE_GPIO_PIN_NUM_12)
#define   RTE_GPIO_PORTA_PIN13              (((uint32_t)RTE_GPIO_PORT_GROUP_A << 16) | (uint32_t)RTE_GPIO_PIN_NUM_13)
#define   RTE_GPIO_PORTA_PIN14              (((uint32_t)RTE_GPIO_PORT_GROUP_A << 16) | (uint32_t)RTE_GPIO_PIN_NUM_14)
#define   RTE_GPIO_PORTA_PIN15              (((uint32_t)RTE_GPIO_PORT_GROUP_A << 16) | (uint32_t)RTE_GPIO_PIN_NUM_15)

#define   RTE_GPIO_PORTB_PIN00              (((uint32_t)RTE_GPIO_PORT_GROUP_B << 16) | (uint32_t)RTE_GPIO_PIN_NUM_00) 
#define   RTE_GPIO_PORTB_PIN01              (((uint32_t)RTE_GPIO_PORT_GROUP_B << 16) | (uint32_t)RTE_GPIO_PIN_NUM_01)
#define   RTE_GPIO_PORTB_PIN02              (((uint32_t)RTE_GPIO_PORT_GROUP_B << 16) | (uint32_t)RTE_GPIO_PIN_NUM_02)
#define   RTE_GPIO_PORTB_PIN03              (((uint32_t)RTE_GPIO_PORT_GROUP_B << 16) | (uint32_t)RTE_GPIO_PIN_NUM_03)
#define   RTE_GPIO_PORTB_PIN04              (((uint32_t)RTE_GPIO_PORT_GROUP_B << 16) | (uint32_t)RTE_GPIO_PIN_NUM_04)
#define   RTE_GPIO_PORTB_PIN05              (((uint32_t)RTE_GPIO_PORT_GROUP_B << 16) | (uint32_t)RTE_GPIO_PIN_NUM_05)
#define   RTE_GPIO_PORTB_PIN06              (((uint32_t)RTE_GPIO_PORT_GROUP_B << 16) | (uint32_t)RTE_GPIO_PIN_NUM_06)
#define   RTE_GPIO_PORTB_PIN07              (((uint32_t)RTE_GPIO_PORT_GROUP_B << 16) | (uint32_t)RTE_GPIO_PIN_NUM_07)
#define   RTE_GPIO_PORTB_PIN08              (((uint32_t)RTE_GPIO_PORT_GROUP_B << 16) | (uint32_t)RTE_GPIO_PIN_NUM_08)
#define   RTE_GPIO_PORTB_PIN09              (((uint32_t)RTE_GPIO_PORT_GROUP_B << 16) | (uint32_t)RTE_GPIO_PIN_NUM_09)
#define   RTE_GPIO_PORTB_PIN10              (((uint32_t)RTE_GPIO_PORT_GROUP_B << 16) | (uint32_t)RTE_GPIO_PIN_NUM_10)
#define   RTE_GPIO_PORTB_PIN11              (((uint32_t)RTE_GPIO_PORT_GROUP_B << 16) | (uint32_t)RTE_GPIO_PIN_NUM_11)
#define   RTE_GPIO_PORTB_PIN12              (((uint32_t)RTE_GPIO_PORT_GROUP_B << 16) | (uint32_t)RTE_GPIO_PIN_NUM_12)
#define   RTE_GPIO_PORTB_PIN13              (((uint32_t)RTE_GPIO_PORT_GROUP_B << 16) | (uint32_t)RTE_GPIO_PIN_NUM_13)
#define   RTE_GPIO_PORTB_PIN14              (((uint32_t)RTE_GPIO_PORT_GROUP_B << 16) | (uint32_t)RTE_GPIO_PIN_NUM_14)
#define   RTE_GPIO_PORTB_PIN15              (((uint32_t)RTE_GPIO_PORT_GROUP_B << 16) | (uint32_t)RTE_GPIO_PIN_NUM_15)

#define   RTE_GPIO_PORTC_PIN00              (((uint32_t)RTE_GPIO_PORT_GROUP_C << 16) | (uint32_t)RTE_GPIO_PIN_NUM_00)
#define   RTE_GPIO_PORTC_PIN01              (((uint32_t)RTE_GPIO_PORT_GROUP_C << 16) | (uint32_t)RTE_GPIO_PIN_NUM_01)
#define   RTE_GPIO_PORTC_PIN02              (((uint32_t)RTE_GPIO_PORT_GROUP_C << 16) | (uint32_t)RTE_GPIO_PIN_NUM_02)
#define   RTE_GPIO_PORTC_PIN03              (((uint32_t)RTE_GPIO_PORT_GROUP_C << 16) | (uint32_t)RTE_GPIO_PIN_NUM_03)
#define   RTE_GPIO_PORTC_PIN04              (((uint32_t)RTE_GPIO_PORT_GROUP_C << 16) | (uint32_t)RTE_GPIO_PIN_NUM_04)
#define   RTE_GPIO_PORTC_PIN05              (((uint32_t)RTE_GPIO_PORT_GROUP_C << 16) | (uint32_t)RTE_GPIO_PIN_NUM_05)
#define   RTE_GPIO_PORTC_PIN06              (((uint32_t)RTE_GPIO_PORT_GROUP_C << 16) | (uint32_t)RTE_GPIO_PIN_NUM_06)
#define   RTE_GPIO_PORTC_PIN07              (((uint32_t)RTE_GPIO_PORT_GROUP_C << 16) | (uint32_t)RTE_GPIO_PIN_NUM_07)
#define   RTE_GPIO_PORTC_PIN08              (((uint32_t)RTE_GPIO_PORT_GROUP_C << 16) | (uint32_t)RTE_GPIO_PIN_NUM_08)
#define   RTE_GPIO_PORTC_PIN09              (((uint32_t)RTE_GPIO_PORT_GROUP_C << 16) | (uint32_t)RTE_GPIO_PIN_NUM_09)
#define   RTE_GPIO_PORTC_PIN10              (((uint32_t)RTE_GPIO_PORT_GROUP_C << 16) | (uint32_t)RTE_GPIO_PIN_NUM_10)
#define   RTE_GPIO_PORTC_PIN11              (((uint32_t)RTE_GPIO_PORT_GROUP_C << 16) | (uint32_t)RTE_GPIO_PIN_NUM_11)
#define   RTE_GPIO_PORTC_PIN12              (((uint32_t)RTE_GPIO_PORT_GROUP_C << 16) | (uint32_t)RTE_GPIO_PIN_NUM_12)
#define   RTE_GPIO_PORTC_PIN13              (((uint32_t)RTE_GPIO_PORT_GROUP_C << 16) | (uint32_t)RTE_GPIO_PIN_NUM_13)
#define   RTE_GPIO_PORTC_PIN14              (((uint32_t)RTE_GPIO_PORT_GROUP_C << 16) | (uint32_t)RTE_GPIO_PIN_NUM_14)
#define   RTE_GPIO_PORTC_PIN15              (((uint32_t)RTE_GPIO_PORT_GROUP_C << 16) | (uint32_t)RTE_GPIO_PIN_NUM_15)

#define   RTE_GPIO_PORTF_PIN00              (((uint32_t)RTE_GPIO_PORT_GROUP_F << 16) | (uint32_t)RTE_GPIO_PIN_NUM_00)
#define   RTE_GPIO_PORTF_PIN01              (((uint32_t)RTE_GPIO_PORT_GROUP_F << 16) | (uint32_t)RTE_GPIO_PIN_NUM_01)
#define   RTE_GPIO_PORTF_PIN02              (((uint32_t)RTE_GPIO_PORT_GROUP_F << 16) | (uint32_t)RTE_GPIO_PIN_NUM_02)
#define   RTE_GPIO_PORTF_PIN03              (((uint32_t)RTE_GPIO_PORT_GROUP_F << 16) | (uint32_t)RTE_GPIO_PIN_NUM_03)
#define   RTE_GPIO_PORTF_PIN04              (((uint32_t)RTE_GPIO_PORT_GROUP_F << 16) | (uint32_t)RTE_GPIO_PIN_NUM_04)
#define   RTE_GPIO_PORTF_PIN05              (((uint32_t)RTE_GPIO_PORT_GROUP_F << 16) | (uint32_t)RTE_GPIO_PIN_NUM_05)
#define   RTE_GPIO_PORTF_PIN06              (((uint32_t)RTE_GPIO_PORT_GROUP_F << 16) | (uint32_t)RTE_GPIO_PIN_NUM_06)
#define   RTE_GPIO_PORTF_PIN07              (((uint32_t)RTE_GPIO_PORT_GROUP_F << 16) | (uint32_t)RTE_GPIO_PIN_NUM_07)
#define   RTE_GPIO_PORTF_PIN08              (((uint32_t)RTE_GPIO_PORT_GROUP_F << 16) | (uint32_t)RTE_GPIO_PIN_NUM_08)
#define   RTE_GPIO_PORTF_PIN09              (((uint32_t)RTE_GPIO_PORT_GROUP_F << 16) | (uint32_t)RTE_GPIO_PIN_NUM_09)

#endif /* RTE_GPIO_N32G432CB_H__ */
