#ifndef RTE_RTC_H__
#define RTE_RTC_H__
#include <stdint.h>
#include "main.h"

/* RTC default time setting */
#ifndef RTC_DEFAULT_TIME
#define RTC_DEFAULT_TIME   1U
#define RTC_DEFAULT_YEAR   25U
#define RTC_DEFAULT_MONTH  3U
#define RTC_DEFAULT_DATE   14U
#define RTC_DEFAULT_WEEK   5U /*must be right*/
#define RTC_DEFAULT_HOUR   23U
#define RTC_DEFAULT_MINUTE 59U
#define RTC_DEFAULT_SECOND 30U
#endif

#define RCC_RTCCLKSOURCE RCC_RTCCLKSOURCE_HSE_DIV128
#define RTC_BINFORMAT RTC_FORMAT_BIN
#define RTC_BCDFORMAT RTC_FORMAT_BCD

#define ErrorStatus unsigned char

typedef struct __attribute__((aligned(4)))
{
	uint8_t u8RTCYear;		 /*00~~99 in Dec*/
	uint8_t u8RTCMonth;		 /*01~~12 in Dec*/
	uint8_t u8RTCDayOfMonth; /*01~~31 in Dec*/
	uint8_t u8RTCDayOfWeek;	 /*0~~6 in Dec*/
	uint8_t u8RTCHour;		 /*fix 24Hour Format 00~~23 in  Dec*/
	uint8_t u8RTCMinute;	 /*0~~59 in Dec*/
	uint8_t u8RTCSecond;	 /*0~~59 in Dec*/
} RTC_Information_st_t;

typedef enum
{
	RTC_CLK_SRC_TYPE_HSE_DIV128 = 0x01,
	RTC_CLK_SRC_TYPE_LSE = 0x02,
	RTC_CLK_SRC_TYPE_LSI = 0x03,
} RTC_CLK_SRC_TYPE;

/* RTC exported time register */
#define RTC_YEAR g_stRTCInformation.u8RTCYear
#define RTC_MONTH g_stRTCInformation.u8RTCMonth
#define RTC_DATE g_stRTCInformation.u8RTCDayOfMonth
#define RTC_WEEK g_stRTCInformation.u8RTCDayOfWeek
#define RTC_HOUR g_stRTCInformation.u8RTCHour
#define RTC_MINUTE g_stRTCInformation.u8RTCMinute
#define RTC_SECOND g_stRTCInformation.u8RTCSecond

extern RTC_DateTypeDef RTC_DateStructure;
extern RTC_TimeTypeDef RTC_TimeStructure;
extern RTC_Information_st_t g_stRTCInformation;

extern void RTE_RTC_Init(RTC_Information_st_t *g_stRTCInformationPart, uint32_t u32RTCFORMAT);
extern void RTE_RTC_Set_Time(RTC_TimeTypeDef *RTC_UserTimeStruct, RTC_DateTypeDef *RTC_UserDateStruct, uint32_t u32RTCFORMAT);
extern void UPDATE_RTC_GET_DATETIME(RTC_TimeTypeDef *RTC_UserTimeStruct, RTC_DateTypeDef *RTC_UserDateStruct, uint32_t u32RTCFORMAT);
#endif
