#include <stdint.h>
#include "RTE.h"

RTE_PWM_TIMER_Desc_st_t   g_stTIMERPWM1 = {
    TIMERM_1, 0,
};

RTE_PWM_TIMER_Desc_st_t   g_stTIMERPWM14 = {
    TIMERM_14, 0,
};

/************************************************************************ 
 * @description:根据目标频率计算定时器是否需要分频，拿到定时器预分频值
 * @param {uint32_t} target_freq    目标频率  
 * @param {uint32_t} tim_clk_freq   定时器频率
 * @param {uint32_t} *psc           计算后得到的Prescaler值
 * @param {uint8_t} *clk_divider    定时器分频系数
 * @return {*}
 ************************************************************************/
/*static void calculate_pwm_divider(uint32_t target_freq, uint32_t tim_clk_freq, uint32_t *psc, uint8_t *clk_divider) {
    // 初始不分频
    *clk_divider = TIM_CLOCK_DIV1;
    // 计算理论预分频值
    *psc = (tim_clk_freq / (target_freq * (ARR_VALUE + 1))) - 1;

    // 判断是否需要 2 分频
    if (*psc > 0xFFFF) {
        *clk_divider = TIM_CLOCK_DIV2;
        *psc = ((tim_clk_freq / *clk_divider) / (target_freq * (ARR_VALUE + 1))) - 1;
    }

    // 判断是否需要 4 分频
    if (*psc > 0xFFFF) {
        *clk_divider = TIM_CLOCK_DIV4;
        *psc = ((tim_clk_freq / *clk_divider) / (target_freq * (ARR_VALUE + 1))) - 1;
    }
}
*/

/************************************************************************ 
 * @description:配置定时器初始化相关参数，（这里定时器和引脚配置不全，根据需要后续添加和修改）
 * @param {RTE_PWM_TIMER_Desc_st_t*} psTimx
 * @param {RTE_PWM_TIMER_Desc_st_t*} psTimx
 * @param {uint16_t} freq
 * @param {uint32_t} PWM_Clock
 * @return {*}正常0 失败1 
 ************************************************************************/
uint8_t TimerM_PWM_counter_Output_Init(RTE_PWM_TIMER_Desc_st_t* psTimx, uint16_t freq, uint32_t PWM_Clock)                                                     
{   
    if ((psTimx->TIMX < 0) || (psTimx->TIMX >= TIMERM_MAX))
    {
        return 1;
    }
    psTimx->TimHandle.Init.CounterMode   = TIM_COUNTERMODE_UP;
    psTimx->TimHandle.Init.RepetitionCounter = 1-1;
    psTimx->TimHandle.Init.AutoReloadPreload = TIM_AUTORELOAD_PRELOAD_ENABLE;
    psTimx->TimHandle.Init.Period    = psTimx->Period =  ARR_VALUE;
    psTimx->TimHandle.Init.Prescaler = (PWM_Clock / (freq * (ARR_VALUE + 1))) - 1;
    psTimx->TimHandle.Init.ClockDivision = TIM_CLOCKDIVISION_DIV1;
    switch (psTimx->TIMX)
    {
        case TIMERM_1:
        {
                TIM1_GPIOCLK_ENABLE();
                psTimx->TimHandle.Instance = TIM1;
       }break;
        case TIMERM_14:
        {       
                TIM14_GPIOCLK_ENABLE();
                psTimx->TimHandle.Instance = TIM14;                     
       }break;
       default:return 1;
   }
    if (HAL_TIM_PWM_Init(&psTimx->TimHandle) != HAL_OK)
        return 1;
   else    
        return 0;
 }
/************************************************************************ 
 * @description:配置具体通道参数并使能pwm输出，占空比默认采用宏DEFAULT_PULSE，（这里定时器和引脚配置不全，根据需要后续添加和修改）
 * @param {RTE_PWM_TIMER_Desc_st_t*} psTimx
 * @param {TIMERM_PWM_Channel_en_t} ch
 * @param {TIMERM_PWM_ActiveLevel_en_t} ActiveLevel
 * @return {*} 正常0 失败1 
 ************************************************************************/    
uint8_t TimerM_PWM_CH_Output_init(RTE_PWM_TIMER_Desc_st_t* psTimx, TIMERM_PWM_Channel_en_t ch, TIMERM_PWM_ActiveLevel_en_t ActiveLevel)
{
    GPIO_InitTypeDef GPIO_InitStruct;

     if ((psTimx->TIMX < 0) || (psTimx->TIMX >= TIMERM_MAX))
    {
        return 1;
    }
    psTimx->TimsConfig.OCMode       = TIM_OCMODE_PWM1;                                                                
    psTimx->TimsConfig.OCFastMode   = TIM_OCFAST_DISABLE;                                
    psTimx->TimsConfig.OCNPolarity  = TIM_OCPOLARITY_LOW;                               
    psTimx->TimsConfig.OCNIdleState = TIM_OCNIDLESTATE_RESET;                              
    psTimx->TimsConfig.OCIdleState  = TIM_OCIDLESTATE_RESET; 
    if (ActiveLevel == ActiveLevel_High)
    {
            psTimx->TimsConfig.OCPolarity   = TIM_OCPOLARITY_HIGH;     
    }
    else 
    {
            psTimx->TimsConfig.OCPolarity   = TIM_OCPOLARITY_LOW; 
    }
    switch (psTimx->TIMX)
        {
            case TIMERM_1:
            {
                TIM1_CHANNEL1_GPIOCLK_ENABLE();
                GPIO_InitStruct.Mode = GPIO_MODE_AF_PP;       
                GPIO_InitStruct.Pull = GPIO_PULLDOWN;           
                GPIO_InitStruct.Speed = GPIO_SPEED_FREQ_HIGH;
                
                if (ch == TIMERM_CH1) 
                {
                      GPIO_InitStruct.Pin = TIM1_GPIO_PIN_CHANNEL1;
                      GPIO_InitStruct.Alternate = TIM1_GPIO_AF_CHANNEL1;
                      HAL_GPIO_Init(TIM1_GPIO_PORT_CHANNEL1, &GPIO_InitStruct);
                      
                      psTimx->TimsConfig.Pulse =  psTimx->pwm_duty[TIMERM_CH1] = DEFAULT_PULSE;
                      
                      if (HAL_TIM_PWM_ConfigChannel(&psTimx->TimHandle, &psTimx->TimsConfig, TIM_CHANNEL_1) != HAL_OK)        
                            return 1;
                       if (HAL_TIM_PWM_Start(&psTimx->TimHandle, TIM_CHANNEL_1) != HAL_OK)
                            return 1;
                    return 0;
                }
                if (ch == TIMERM_CH2) 
                {
                      GPIO_InitStruct.Pin = TIM1_GPIO_PIN_CHANNEL2;
                      GPIO_InitStruct.Alternate = TIM1_GPIO_AF_CHANNEL2;
                      HAL_GPIO_Init(TIM1_GPIO_PORT_CHANNEL2, &GPIO_InitStruct);
                      
                      psTimx->TimsConfig.Pulse =  psTimx->pwm_duty[TIMERM_CH2] = DEFAULT_PULSE;
                      if (HAL_TIM_PWM_ConfigChannel(&psTimx->TimHandle, &psTimx->TimsConfig, TIM_CHANNEL_2) != HAL_OK)        
                            return 1;
                       if (HAL_TIM_PWM_Start(&psTimx->TimHandle, TIM_CHANNEL_2) != HAL_OK)
                            return 1;
                       return 0;
                }
                if (ch == TIMERM_CH3) 
                {
                      GPIO_InitStruct.Pin = TIM1_GPIO_PIN_CHANNEL3;
                      GPIO_InitStruct.Alternate = TIM1_GPIO_AF_CHANNEL3;
                      HAL_GPIO_Init(TIM1_GPIO_PORT_CHANNEL3, &GPIO_InitStruct);
                      
                      psTimx->TimsConfig.Pulse =  psTimx->pwm_duty[TIMERM_CH3] = DEFAULT_PULSE;
                      if (HAL_TIM_PWM_ConfigChannel(&psTimx->TimHandle, &psTimx->TimsConfig, TIM_CHANNEL_3) != HAL_OK)        
                            return 1;
                       if (HAL_TIM_PWM_Start(&psTimx->TimHandle, TIM_CHANNEL_3) != HAL_OK)
                            return 1;
                       return 0;
                } 
                if (ch == TIMERM_CH4) 
                {
                      GPIO_InitStruct.Pin = TIM1_GPIO_PIN_CHANNEL4;
                      GPIO_InitStruct.Alternate = TIM1_GPIO_AF_CHANNEL4;
                      HAL_GPIO_Init(TIM1_GPIO_PORT_CHANNEL4, &GPIO_InitStruct);
                      
                      psTimx->TimsConfig.Pulse =  psTimx->pwm_duty[TIMERM_CH3] = DEFAULT_PULSE;
                      if (HAL_TIM_PWM_ConfigChannel(&psTimx->TimHandle, &psTimx->TimsConfig, TIM_CHANNEL_4) != HAL_OK)        
                            return 1;
                       if (HAL_TIM_PWM_Start(&psTimx->TimHandle, TIM_CHANNEL_4) != HAL_OK)
                            return 1;
                }
                return 0;
            }break;
            case TIMERM_14:
            {
                TIM14_GPIOCLK_ENABLE();
                GPIO_InitStruct.Mode = GPIO_MODE_AF_PP;       
                GPIO_InitStruct.Pull = GPIO_PULLUP;           
                GPIO_InitStruct.Speed = GPIO_SPEED_FREQ_HIGH;
                if(ch == TIMERM_CH1) 
                {
                      GPIO_InitStruct.Pin = TIM14_GPIO_PIN_CHANNEL1;
                      GPIO_InitStruct.Alternate = TIM14_GPIO_AF_CHANNEL1;
                      HAL_GPIO_Init(TIM14_GPIO_PORT_CHANNEL1, &GPIO_InitStruct);
                      
                      psTimx->TimsConfig.Pulse =  psTimx->pwm_duty[TIMERM_CH1] = DEFAULT_PULSE;
                      if (HAL_TIM_PWM_ConfigChannel(&psTimx->TimHandle, &psTimx->TimsConfig, TIM_CHANNEL_1) != HAL_OK)        
                            return 1;
                       if (HAL_TIM_PWM_Start(&psTimx->TimHandle, TIM_CHANNEL_1) != HAL_OK)
                            return 1;
                }
                return 0;
            }break;
            
           default: break;
       }
       return 1;
}
/************************************************************************ 
 * @description:PWM占空比设置
 * @param {RTE_PWM_TIMER_Desc_st_t*} psTimx
 * @param {TIMERM_PWM_Channel_en_t} ch
 * @param {uint16_t} duty
 * @return {*}正常0 失败1 
 ************************************************************************/
uint8_t TimerM_PWM_set_duty(RTE_PWM_TIMER_Desc_st_t* psTimx, TIMERM_PWM_Channel_en_t ch, uint16_t duty )
{
    if ((psTimx->TIMX < 0) || (psTimx->TIMX >= TIMERM_MAX))
        return 1;

    if (duty >= 1000)
        duty = 0;
    else if (duty <= 0)
        duty = 1000;
        
    switch (ch)
    {
        case TIMERM_CH1:
        {          
             if(psTimx->TIMX == TIMERM_1)
                    TIM1->CCR1 = duty;
             
       }break;
        case TIMERM_CH2:
        {
             if(psTimx->TIMX == TIMERM_1)
                    TIM1->CCR2 = duty;
            
       }break;
        case TIMERM_CH3:
        {
            if(psTimx->TIMX == TIMERM_1)
                    TIM1->CCR3 = duty;
            
       }break;
       case TIMERM_CH4:
        {
             if(psTimx->TIMX == TIMERM_1)
                    TIM1->CCR4 = duty;
            
       }break;
       default: return 1;
   }
   return 0;
}

/************************************************************************ 
 * @description:关闭定时器的通道输出
 * @param {RTE_PWM_TIMER_Desc_st_t*} psTimx
 * @param {TIMERM_PWM_Channel_en_t} ch
 * @return {*}正常0 失败1 
 ************************************************************************/
uint8_t TimerM_PWM_STOP_CHX(RTE_PWM_TIMER_Desc_st_t* psTimx, TIMERM_PWM_Channel_en_t ch)
{
        
    if ((psTimx->TIMX < 0) || (psTimx->TIMX >= TIMERM_MAX))
        {
            return 1;
        }
    switch(ch)
    {
            case (TIMERM_CH1):
            {
                if (HAL_TIM_PWM_Stop(&psTimx->TimHandle, TIM_CHANNEL_1) != HAL_OK)
                    return 1;
            }break;
            case (TIMERM_CH2):
            {
                if (HAL_TIM_PWM_Stop(&psTimx->TimHandle, TIM_CHANNEL_2) != HAL_OK)
                    return 1;
            }break;   
            case (TIMERM_CH3):
            {
                if (HAL_TIM_PWM_Stop(&psTimx->TimHandle, TIM_CHANNEL_3) != HAL_OK)
                    return 1;
            }break;
             case (TIMERM_CH4):
            {
                if (HAL_TIM_PWM_Stop(&psTimx->TimHandle, TIM_CHANNEL_4) != HAL_OK)
                    return 1;
            }break;
            default:return 1;
    }
    return 0;
}

/************************************************************************ 
 * @description:使能pwm输出
 * @param {RTE_PWM_TIMER_Desc_st_t*} psTimx
 * @param {TIMERM_PWM_Channel_en_t} ch
 * @return {*}正常0 失败1 
 ************************************************************************/
uint8_t TimerM_PWM_START_CHX(RTE_PWM_TIMER_Desc_st_t* psTimx, TIMERM_PWM_Channel_en_t ch)
{
        
    if ((psTimx->TIMX < 0) || (psTimx->TIMX >= TIMERM_MAX))
        {
            return 1;
        }
    switch(ch)
    {
           case (TIMERM_CH1):
            {
                if (HAL_TIM_PWM_Start(&psTimx->TimHandle, TIM_CHANNEL_1) != HAL_OK)
                    return 1;
            }break;
           
            case (TIMERM_CH2):
            {
                if (HAL_TIM_PWM_Start(&psTimx->TimHandle, TIM_CHANNEL_2) != HAL_OK)
                    return 1;
            }break;
            
            case (TIMERM_CH3):
            {
                if (HAL_TIM_PWM_Start(&psTimx->TimHandle, TIM_CHANNEL_3) != HAL_OK)
                    return 1;
            }break;
           
            case (TIMERM_CH4):
            {
                if (HAL_TIM_PWM_Start(&psTimx->TimHandle, TIM_CHANNEL_4) != HAL_OK)
                    return 1;
            }break;
            default:return 1;
    }
    return 0;
}
/************************************************************************ 
 * @description:复位定时器
 * @param {RTE_PWM_TIMER_Desc_st_t*} psTimx
 * @return {*}正常0 失败1 
 ************************************************************************/
uint8_t TimerM_PWM_DeInit_CHX(RTE_PWM_TIMER_Desc_st_t* psTimx)
{
    if ((psTimx->TIMX < 0) || (psTimx->TIMX >= TIMERM_MAX))
            return 1;
 
     if (HAL_TIM_PWM_DeInit(&psTimx->TimHandle) != HAL_OK)
            return 1;
     
     memset(psTimx, 0, sizeof(RTE_PWM_TIMER_Desc_st_t));
    
    return 0;
}
/************************************************************************ 
 * @description: pwm频率设置
 * @param {RTE_PWM_TIMER_Desc_st_t*} psTimx
 * @param {uint16_t} freq
 * @return {*}正常0 失败1 
 ************************************************************************/
uint8_t TimerM_PWM_set_freq(RTE_PWM_TIMER_Desc_st_t* psTimx, uint16_t freq )
{
    if ((psTimx->TIMX < 0) || (psTimx->TIMX >= TIMERM_MAX))
        {
            return 1;
        }
    switch (psTimx->TIMX)
        {
            case TIMERM_1:
            {         
                TIM1->PSC = (TIMERCLkFREQ / (freq * (ARR_VALUE + 1))) - 1;
            }break;
            case TIMERM_14:
            {
                TIM14->PSC = (TIMERCLkFREQ / (freq * (ARR_VALUE + 1))) - 1;
            }break;
            
           default: return 1;
       }
  return 0;

}

