#ifndef TRMERM_H_
#define TRMERM_H_
#include <stdint.h>
#include "main.h"

#define   TIMERCLkFREQ      (24000000)  //注意配置

#define   ARR_VALUE         999         //注意配置
#define   DEFAULT_PULSE     500         //注意配置

//没有确定具体使用引脚，后续需要重新添加配置
#define TIM1_GPIOCLK_ENABLE()          __HAL_RCC_TIM1_CLK_ENABLE()
#define TIM1_CHANNEL1_GPIOCLK_ENABLE() __HAL_RCC_GPIOA_CLK_ENABLE()
#define TIM1_GPIO_PORT_CHANNEL1        GPIOA
#define TIM1_GPIO_PIN_CHANNEL1         GPIO_PIN_8
#define TIM1_GPIO_AF_CHANNEL1          GPIO_AF2_TIM1

#define TIM1_CHANNEL2_GPIOCLK_ENABLE() __HAL_RCC_GPIOA_CLK_ENABLE()
#define TIM1_GPIO_PORT_CHANNEL2        GPIOA
#define TIM1_GPIO_PIN_CHANNEL2         GPIO_PIN_8
#define TIM1_GPIO_AF_CHANNEL2          GPIO_AF2_TIM1

#define TIM1_CHANNEL3_GPIOCLK_ENABLE() __HAL_RCC_GPIOA_CLK_ENABLE()
#define TIM1_GPIO_PORT_CHANNEL3        GPIOA
#define TIM1_GPIO_PIN_CHANNEL3         GPIO_AF2_TIM1
#define TIM1_GPIO_AF_CHANNEL3          GPIO_AF2_TIM1

#define TIM1_CHANNEL4_GPIOCLK_ENABLE() __HAL_RCC_GPIOA_CLK_ENABLE()
#define TIM1_GPIO_PORT_CHANNEL4        GPIOA
#define TIM1_GPIO_PIN_CHANNEL4         GPIO_AF2_TIM1
#define TIM1_GPIO_AF_CHANNEL4          GPIO_AF2_TIM1


#define TIM14_GPIOCLK_ENABLE()          __HAL_RCC_TIM14_CLK_ENABLE()
#define TIM14_CHANNEL1_GPIOCLK_ENABLE() __HAL_RCC_GPIOA_CLK_ENABLE()
#define TIM14_GPIO_PORT_CHANNEL1        GPIOA
#define TIM14_GPIO_PIN_CHANNEL1         GPIO_PIN_7
#define TIM14_GPIO_AF_CHANNEL1          GPIO_AF4_TIM14


typedef enum
{
    TIMERM_1 = 0x0000U,
    TIMERM_2,
    TIMERM_3,
    TIMERM_6,
    TIMERM_7,
    TIMERM_14,
    TIMERM_15,
    TIMERM_16,
    TIMERM_17,
    TIMERM_MAX
} TIMERM_NUM_en_t;

typedef enum
{
    TIMERM_CH1 = 0U,
    TIMERM_CH2,
    TIMERM_CH3,
    TIMERM_CH4,
    TIMERM_CHALL
} TIMERM_PWM_Channel_en_t;

  
typedef struct
{
    TIMERM_NUM_en_t      TIMX;
    TIM_HandleTypeDef    TimHandle;
    TIM_OC_InitTypeDef   TimsConfig;
    uint32_t             cycle_pulse;  
    uint32_t             Period;      
    uint32_t             pwm_duty[TIMERM_CHALL];
}RTE_PWM_TIMER_Desc_st_t;



typedef enum
{
    ActiveLevel_High = 0,
    ActiveLevel_Low,
} TIMERM_PWM_ActiveLevel_en_t;

typedef enum
{
    TIM_CLOCK_DIV1 = 1,
    TIM_CLOCK_DIV2 = 2,
    TIM_CLOCK_DIV4 = 4
} TIMERM_PWM_u8clkdiv_en_t;


extern RTE_PWM_TIMER_Desc_st_t   g_stTIMERPWM1;
extern RTE_PWM_TIMER_Desc_st_t   g_stTIMERPWM14;

extern uint8_t TimerM_PWM_counter_Output_Init(RTE_PWM_TIMER_Desc_st_t* psTimx, uint16_t freq, uint32_t PWM_Clock);
extern uint8_t TimerM_PWM_CH_Output_init(RTE_PWM_TIMER_Desc_st_t* psTimx, TIMERM_PWM_Channel_en_t ch, TIMERM_PWM_ActiveLevel_en_t ActiveLevel);
extern uint8_t TimerM_PWM_set_duty(RTE_PWM_TIMER_Desc_st_t* psTimx, TIMERM_PWM_Channel_en_t ch, uint16_t duty );
extern uint8_t TimerM_PWM_set_freq(RTE_PWM_TIMER_Desc_st_t* psTimx, uint16_t freq );
extern uint8_t TimerM_PWM_START_CHX(RTE_PWM_TIMER_Desc_st_t* psTimx, TIMERM_PWM_Channel_en_t ch);
extern uint8_t TimerM_PWM_STOP_CHX(RTE_PWM_TIMER_Desc_st_t* psTimx, TIMERM_PWM_Channel_en_t ch);

#endif /* TRMERM_H_ */
