#include <stdint.h>
#include "Protocol_User.h"
#include "Protocol_Lib.h"
#include "freertos/FreeRTOS.h"
#include "freertos/task.h"
#include "freertos/event_groups.h"
#include "esp_system.h"
#include "esp_log.h"
#include "nvs_flash.h"
#include "esp_bt.h"

#include "esp_gap_ble_api.h"
#include "esp_gatts_api.h"
#include "esp_bt_main.h"
#include "gatts_table_creat_demo.h"
#include "esp_gatt_common_api.h"

#include "esp_mac.h"

#include "freertos/FreeRTOS.h"
#include "freertos/task.h"
#include "esp_system.h"
#include "esp_log.h"
#include "driver/uart.h"
#include "string.h"
#include "driver/gpio.h"
#include "MCU_Core_Protocol.h"
#include "Protocol_Lib.h"
#include "app_Ble_User.h"
#include "app_BT_User.h"

#include <stdint.h>
#include <string.h>
#include <stdbool.h>
#include <stdio.h>
#include "http_server.h"



#define TAG "Prot_User"
Protocol_User_Ctrl_Struct Prot_User;



#define UART_TX_MAX_DEPTH 1024UL          //(2 * 1024UL)    // 4K
#define UART_RX_MAX_DEPTH (2 * 1024UL)    // 4K
#define UART_DATA_BUF_LEN (2 * 1024UL)    // 4K
//extern void OTA_IC_To_Master( uint8_t len);
typedef struct
{
    Protocol_uint32_t read_pos;
    Protocol_uint32_t write_pos;
    Protocol_uint8_t  Rx_Buffer [ UART_RX_MAX_DEPTH ];
} UARTRxBuf_t;

typedef struct
{
    Protocol_uint32_t read_pos;
    Protocol_uint32_t write_pos;
    Protocol_uint8_t  Tx_Buffer [ UART_TX_MAX_DEPTH ];
} UARTTxBuf_t;

static UARTRxBuf_t      UARTRxBuf;
static UARTTxBuf_t      UARTTxBuf;
static Protocol_uint8_t UsartDataBuf [ 256 ];
static Protocol_uint8_t mDataBufPtr [ UART_DATA_BUF_LEN ];

static Protocol_uint8_t  Protocol_OpenUart(void);
static Protocol_uint32_t Protocol_UartRead(Protocol_uint8_t *pData, Protocol_uint32_t u32Len);
static Protocol_uint32_t Protocol_UartSend(const Protocol_uint8_t *pData, Protocol_uint32_t u32Len);
static void              Protocol_UartHandle(const Protocol_Data_t *pData);

void Protocol_KL30_Wakeup_Init(void)
{
    Protocol_Func_t pFunc;

    pFunc.UARTOpen_Cbk        = Protocol_OpenUart;
    pFunc.UARTSend_Cbk        = Protocol_UartSend;
    pFunc.UARTRead_Cbk        = Protocol_UartRead;
    pFunc.UARTClose_Cbk       = Protocol_NULL;
    pFunc.ProcParseCbk        = Protocol_NULL;
    pFunc.ProtocolSetData_Cbk = Protocol_UartHandle;
    UARTTxBuf.read_pos        = 0;
    UARTTxBuf.write_pos       = 0;
    UARTRxBuf.read_pos        = 0;
    UARTRxBuf.write_pos       = 0;

    Protocol_Init(mDataBufPtr, UART_DATA_BUF_LEN, &pFunc);
}


void Protocol_Send_Service(void)
{
    Protocol_uint32_t i       = 0u;
    Protocol_uint32_t DataLen = 0u;
    Protocol_uint32_t SendLen = 0u;


    if ( UARTTxBuf.write_pos == UARTTxBuf.read_pos )
    {
        return;
    }

    if ( UARTTxBuf.write_pos > UARTTxBuf.read_pos )
    {
        DataLen = UARTTxBuf.write_pos - UARTTxBuf.read_pos;
    }
    else
    {
        DataLen = UART_TX_MAX_DEPTH - (UARTTxBuf.read_pos - UARTTxBuf.write_pos);
    }

    if ( DataLen > 255 )
    {
        SendLen = 255;
    }
    else
    {
        SendLen = DataLen;
    }

    for ( i = 0u; i < SendLen; i++ )
    {
        UsartDataBuf [ i ] = UARTTxBuf.Tx_Buffer [ UARTTxBuf.read_pos ];
        UARTTxBuf.read_pos = (UARTTxBuf.read_pos + 1) % UART_TX_MAX_DEPTH;
    }


    bsp_Uart_Send_Data(UsartDataBuf, SendLen);

}

static Protocol_uint8_t Protocol_OpenUart(void)
{
#if 0
    UART_Channel_Config_st_t loc_config;

    loc_config.u32UARTChEn            = 1;
    loc_config.u32UARTbps             = 115200;
    loc_config.pfnUARTConfirmCallBack = Protocol_NULL;
    loc_config.pfnUARTReadMsgCallBack = UART_Put;

    UART_Init(UART_RLIN31, &loc_config);
#endif
    return 1;
}

static Protocol_uint32_t Protocol_UartRead(Protocol_uint8_t *pData, Protocol_uint32_t len)
{
    Protocol_uint32_t i       = 0;
    Protocol_uint32_t DataLen = 0u;
    Protocol_uint32_t ReadLen = 0u;

    if ( UARTRxBuf.write_pos == UARTRxBuf.read_pos )
    {
        return 0;    //队列空
    }

    if ( UARTRxBuf.write_pos > UARTRxBuf.read_pos )
    {
        DataLen = UARTRxBuf.write_pos - UARTRxBuf.read_pos;
    }
    else
    {
        DataLen = UART_RX_MAX_DEPTH - (UARTRxBuf.read_pos - UARTRxBuf.write_pos);
    }

    if ( len > DataLen )
    {
        ReadLen = DataLen;
    }
    else
    {
        ReadLen = len;
    }

    for ( i = 0u; i < ReadLen; i++ )
    {
        pData [ i ]        = UARTRxBuf.Rx_Buffer [ UARTRxBuf.read_pos ];
        UARTRxBuf.read_pos = (UARTRxBuf.read_pos + 1) % UART_RX_MAX_DEPTH;
    }

    return ReadLen;
}

static Protocol_uint32_t Protocol_UartSend(const Protocol_uint8_t *pData, Protocol_uint32_t u32Len)
{
    Protocol_uint32_t i         = 0;
    Protocol_uint32_t RemainLen = 0u;

    if ( UARTTxBuf.write_pos >= UARTTxBuf.read_pos )
    {
        RemainLen = UART_TX_MAX_DEPTH - (UARTTxBuf.write_pos - UARTTxBuf.read_pos);
    }
    else
    {
        RemainLen = UARTTxBuf.read_pos - UARTTxBuf.write_pos;
    }

    if ( u32Len > RemainLen )
    {
        return 1;    //队列已满，无法插入队列
    }

    for ( i = 0; i < u32Len; i++ )
    {
        UARTTxBuf.Tx_Buffer [ UARTTxBuf.write_pos ] = pData [ i ];
        UARTTxBuf.write_pos                         = (UARTTxBuf.write_pos + 1) % UART_TX_MAX_DEPTH;
    }

    return 0;
}

extern void wifiServiceStart(void);
uint32_t SwitchMode=0;
static void Protocol_UartHandle(const Protocol_Data_t *pData)//esp接收底板数据
{
    if ( pData->CmdID == 0x20 )//收到底板发送的数据后,才会发送0x12,0x01,0x02的id
    {
        //printf("0x20 is get\r\n");
        if(Prot_User.State < Prot_Start)
        {
            Prot_User.State = Prot_Start;
            printf("Prot_Start \r\n");
        }
    }
    else if(pData->CmdID == 0x03 )//收到底板发送的电话状态,来控制esp32蓝牙电话
    {
        //printf("0x03 is get\r\n");
        if(Prot_User.State < Prot_Normal)
        {
            Prot_User.State = Prot_Normal;

            printf("Prot_Normal \r\n");
        }

        if(Prot_User.State >= Prot_Start)
        {
            // if(pData->DataLen == 33)
            {
                if(BT_User.HF_Ctrl != pData->Data[0])//和上次数据不同
                {
                    BT_User.HF_Ctrl = pData->Data[0];//esp32接收到的数据 
                }

                // if(strncmp((const char *) ble_uerid, (const char *)&(pData->Data[1]), 32) != 0)
                // {
                //     memcpy(( uint8_t * )ble_uerid, (uint8_t *)&(pData->Data[1]), 32);
                // }

                // // esp_log_buffer_hex(TAG, ble_uerid, 32);
                // // esp_log_buffer_hex(TAG, &(pData->Data[1]), 32);

                // if(Ble_User.UseridUpdate == 0)
                // {
                //     bsp_Ble_Init();

                //     printf("get uuid and init ble!!! \r\n");
                // }

                // Ble_User.UseridUpdate = 0xAA;
            }
        }
    }
    else if(pData->CmdID == 0x21 )//esp32收到底板发送的是1,则esp32需要升级
    {
        //printf("Wifi_OTA_Request is %d\r\n",Wifi_OTA_Request);
        if(pData->Data[0] == 1)
        {
            // if((pData->CmdID & 0xC0) == 0X40)
            // {
                if(Wifi_OTA_Request == 0)
                {
                    Wifi_OTA_Request = 1;
                    printf("收到进入OTA指令 \r\n");
                    SwitchMode=0x5AA57AA7;
                    wifiServiceStart();
                }
            // }
        }
    }
    else
    {
    }
}

void UART_Put(Protocol_uint16_t Data)
{
   Protocol_uint32_t nextPos = 0u;

   nextPos = (UARTRxBuf.write_pos + 1) % UART_RX_MAX_DEPTH;

   if ( nextPos == UARTRxBuf.read_pos )
   {
       //队列已满，无法插入队列
   }
   else
   {
       UARTRxBuf.Rx_Buffer [ UARTRxBuf.write_pos ] = Data;
       UARTRxBuf.write_pos                         = (UARTRxBuf.write_pos + 1) % UART_RX_MAX_DEPTH;
   }
    //printf("into UARTRxBuf!!!!\r\n");
    return;
}



/** 
 *   @brief    Protocol协议应用层数据赋值和发送
 */

void Protocol_User_Ctrl_Init(void )
{
    Prot_User.State = Prot_Idle;
    Prot_User.TimeDelay = 0;
}

void Uart_Send_Id10_Pro(void )//esp32发送启动完成给底板
{
    uint8_t wtemp[1] = {0};
    wtemp[0] = 1;
    Protocol_Send(0x10, wtemp, 1);
}

void Uart_Send_Id12_Pro(void )//收到底板回复的0x20后,发送蓝牙类型  ID12[0]是判断蓝牙是否连接 不等于0是连接
{
    uint8_t ID12[3] = {0};
    ID12[0] |= (uint8_t)(BT_User.BT_Sts << 4);//经典
    ID12[0] |=  Ble_User.Ble_Sts;//ble
    ID12[1] = 22; //小时
    ID12[2] = 22; //分钟
    Protocol_Send(0x12, ID12, 3);
}

void Uart_Send_Id01_Pro(void)
{
    uint8_t ID01[7] = {0x00,0x00,0x00,0x00,0x00,0x00};
    //if(Ble_User.Tpms_Updat)
    {   
        // ID01[0] = Ble_Tpms_Data.Tpms_Sts;
        // ID01[1] = Ble_Tpms_Data.Tpms_Turn;
        // ID01[2] = Ble_Tpms_Data.Tpms_Dte[0];
        // ID01[3] = Ble_Tpms_Data.Tpms_Dte[1];
        // ID01[4] = Ble_Tpms_Data.Tpms_Dte[2];
        // ID01[5] = Ble_Tpms_Data.Tpms_Dte[3];
        ID01[0] = 0xFF;//胎压状态 
        ID01[1] = 1;//前轮高字节气压值
        ID01[2] = 200;//前轮低字节气压值
        ID01[3] = 0x28;//前轮胎压温度
        ID01[4] = 1;//后轮高字节气压值
        ID01[5] = 45;//后轮低字节气压值
        ID01[6] = 0xAB;//后轮胎压温度

        //printf("转向编码：%d\r\n",Ble_Tpms_Data.Tpms_Turn);
    }
    Protocol_Send(0x01,ID01,7);
}


void Uart_Send_Id02_Pro(void)
{
    uint8_t ID02[1] = {0x00};
    ID02[0] =  BT_User.Call_Sts;
    Protocol_Send(0x02, ID02, 1);//给底板发送电话状态,用这个标志位显示电话号
}




void Prot_Send_Msg_Process(void )
{
    if(Prot_User.State < Prot_Start)
    {
        Uart_Send_Id10_Pro();

        // printf("send 0x10 \r\n");
    }

    //printf("Prot_User.State = %d\r\n",Prot_User.State);
    if(Prot_User.State >=  Prot_Start)//收到底板发送的0x20后,才执行
    {
        if(Prot_User.TimeDelay == 0)
        {
            Uart_Send_Id12_Pro();
            Prot_User.TimeDelay++;
            //printf("send 0x12 \r\n");
        }
        else
        {
            Uart_Send_Id01_Pro();
            Uart_Send_Id02_Pro();
            Prot_User.TimeDelay = 0;
            //printf("send 0x01 0x02 \r\n");
        }
    }
}

//BAT32A239

UpdateProtocolStructure Update_Frame;
//extern const unsigned char _acBAT32A239dat[88016];
Protocol_uint32_t UpgradeStep =0xFF;//初始状态
uint32_t Step_delayTime =0;
uint32_t Flash_Size =0;
uint32_t temp_Size =0;
uint32_t Write_Counter=0;
uint32_t StartAddr = 0;
uint32_t BackupStartAddr = 0;
uint32_t DataTotalLen = 0;
uint32_t BackupDataTotalLen = 0;
void SetUpgradeStart(void)
{ 
    // uint32_t fills;
    // G031toBoot();
    // vTaskDelay(pdMS_TO_TICKS(100));
    // G031tReset();
    // vTaskDelay(pdMS_TO_TICKS(200));
    // TaskSchOnUpdateNAT32G031();//关闭任务
    // fills=temp_Size%16;
    // if (fills!=0)
    // {
    //     memset(&_acBAT32A239dat[temp_Size],0xFF,16-fills);
    //     Flash_Size+=(16-fills);//下载数据需要对齐16字节
    // }
    
     UpgradeStep=4;
}

void SetUpgradeFlashSize(uint32_t size,uint32_t len)
{
    
     DataTotalLen = size - 16;
     BackupDataTotalLen = DataTotalLen;
     temp_Size=0;
     StartAddr = len;
     BackupStartAddr = StartAddr;
     Write_Counter = 0;

}

void Cache_data(unsigned char* p,uint32_t len)
{
   //  memcpy(&_acBAT32A239dat[temp_Size],p,len);
     temp_Size+=len;
}

void SendCmd_EraseBAT32A239_Chip(void)
{
    Update_Frame.CMDH   = CMD_FLASH_ERASE;
    Update_Frame.CMDL   = 0x00;
    Update_Frame.LEN    = 0x08;
    Update_Frame.DAT[0] = StartAddr >> 24;  
    Update_Frame.DAT[1] = StartAddr >> 16;  
    Update_Frame.DAT[2] = StartAddr >> 8;  
    Update_Frame.DAT[3] = StartAddr;
    Update_Frame.DAT[4] = BackupDataTotalLen >> 24;  
    Update_Frame.DAT[5] = BackupDataTotalLen >> 16;  
    Update_Frame.DAT[6] = BackupDataTotalLen >> 8;  
    Update_Frame.DAT[7] = BackupDataTotalLen;
    UpdateBAT32A239Protocol_Send(Update_Frame); 
}
uint32_t Write_Size=0;
uint32_t SendCmd_WriteBAT32A239_Flash(void)
{
    //uint32_t Offset=0;
    
    if (Flash_Size>Write_Counter)
    {
        Update_Frame.CMDH   = CMD_FLASH_DWNLD;
        Update_Frame.CMDL   = 0x00;
        Update_Frame.LEN    = 0;
        
        if ((Flash_Size-Write_Counter)>=128)
        {
           Update_Frame.LEN= 128+8;//0x94;
           Write_Size=128;
        }
        else
        {
           Update_Frame.LEN =   (Flash_Size - Write_Counter) + 8;//剩余数量
           Write_Size       =   Flash_Size - Write_Counter;
        }
        
        memcpy(&Update_Frame.DAT[4],&buf[Write_Counter],Write_Size); //拷贝需要写入的数据到发送结构
        
        //Write_Counter += StartAddr;//转换为下载 FLASH 的实际起始地址
        Update_Frame.DAT[0] = (Protocol_uint8_t)(StartAddr >> 24);
        Update_Frame.DAT[1] = (Protocol_uint8_t)(StartAddr >> 16);
        Update_Frame.DAT[2] = (Protocol_uint8_t)(StartAddr >> 8);
        Update_Frame.DAT[3] = (Protocol_uint8_t)(StartAddr >> 0);

        UpdateBAT32A239Protocol_Send(Update_Frame);//发送
    }
   return Write_Counter;
}
/*
下载成功后，长度的变化；
 //写入指针增加

*/

void SendCmd_CrcCheckBAT32A239_Flash(void)
{
    uint32_t crc=0;
    uint32_t start=0x08000000;
    uint32_t lenght=Flash_Size;
    //crc=CalcCrc32(&_acBAT32A239dat[0],lenght);//减掉CRC和前16字节DAT
    Update_Frame.CMDH   = CMD_DATA_CRC_CHECK;
    Update_Frame.CMDL   = 0x00;
    Update_Frame.LEN    = 0x00;
    UpdateBAT32A239Protocol_Send(Update_Frame); 
}

void SendCmd_ResetComond(void)
{
    Update_Frame.CMDH   = CMD_SYS_RESET;
    Update_Frame.CMDL   = 0x00;
    Update_Frame.LEN    = 0x00;
    UpdateBAT32A239Protocol_Send(Update_Frame); 
}

static uint32_t UpgradeBAT32A239_1ms_Cnt;
void Upgrade_BAT32A239_Task(void *arg)
{
    while(1)
    {
        Protocol_Service();
        if (UpgradeBAT32A239_1ms_Cnt < 1000)
        {
            UpgradeBAT32A239_1ms_Cnt++;
        }
        else
        {
            UpgradeBAT32A239_1ms_Cnt = 0;
        }
        if((UpgradeBAT32A239_1ms_Cnt + 2) % 10 == 0)
        {
            BAT32A239_MCU_Update();
        }
        Protocol_Send_Service();
        vTaskDelay(pdMS_TO_TICKS(1));
    }
}

void BAT32A239_MCU_Update(void)
{
    double percent = 0.0;
    const char *partition_label = "assert";
    const esp_partition_t *assert_update_partition = esp_partition_find_first(ESP_PARTITION_TYPE_DATA, ESP_PARTITION_SUBTYPE_ANY, partition_label);
    switch (UpgradeStep)
    {
        case 0 :
                SendCmd_EraseBAT32A239_Chip();//发送擦除指令    
                UpgradeStep=1;
                Step_delayTime=0;
                ESP_LOGI("MSI","UpgradeStep : %d Erase Chip \n",UpgradeStep);
                break;

        case 1 :
                //ESP_LOGI("MSI","Flash_Size : %ld \n",Flash_Size);
                Write_Counter = 0;
                if (BAT32A239_ACK.CMDH == CMD_FLASH_ERASE)
                {
                    if (BAT32A239_ACK.dat.Erase.CR1 == 0)//没判断长度，只判断了擦除状态
                    {
                        UpgradeStep = 2;
                        ESP_LOGI("MSI","UpgradeStep : %d Erase Chip finshed\n",UpgradeStep);
                        ESP_LOGI("MSI","downloading... \n");
                        
                        SendCmd_WriteBAT32A239_Flash();//下载shou'zhen
                    }
                    else
                    {
                        UpgradeStep = 0;
                        ESP_LOGI("MSI","UpgradeStep : %d Erase Chip finshed\n",UpgradeStep);
                        ESP_LOGI("MSI","Erasing failed, request erasing again\n");
                    }
                }
                else
                {
                    Step_delayTime++;
                    if (Step_delayTime>=5000)
                    {
                        ESP_LOGI("MSI","UpgradeStep : %d Erase Chip timeout\n",UpgradeStep);
                        Step_delayTime = 0;
                        UpgradeStep = 5; //超时停止
                    }
                }
                if(BAT32A239_ACK.CMDH==CMD_FLASH_DWNLD)
                {
                    SendCmd_WriteBAT32A239_Flash();//下载shou'zhen
                    UpgradeStep = 2;
                }
                break;
        case 2:
                //ESP_LOGI("MSI","BAT32A239_ACK.CMDH : %d\n",BAT32A239_ACK.CMDH);
                if (BAT32A239_ACK.CMDH==CMD_FLASH_DWNLD)
                {
                    //ESP_LOGI("MSI","xxxxxxx");
                    if (BAT32A239_ACK.dat.download.CR1==0x01)
                    {
                        ESP_LOGI("MSI","Download failed, request to re-download the package");
                        SendCmd_WriteBAT32A239_Flash();//下载进度
                    }
                    if (BAT32A239_ACK.dat.download.CR1==0x00)
                    {
                        BAT32A239_ACK.dat.download.CR1=0xFF;
                        Write_Counter += Write_Size;
                        StartAddr += Write_Size; 
                        //ESP_LOGI("MSI","Flash_Size : %ld verification OK !\n",Flash_Size);
                        //ESP_LOGI("MSI","Write_Counter : %ld verification OK !\n",Write_Counter);
                        if (Write_Counter == Flash_Size)//下载完成
                        {
                            UpgradeStep = 4;
                            Write_Counter = 0;
                            Write_Size = 0;
                          // ESP_LOGI("MSI", " %.2f%%", 100.00);
                            ESP_LOGI("MSI","\n UpgradeStep : %d  download finished \n",UpgradeStep);
                        }
                        else
                        { 
                           // percent = 100.0 - (double)(Write_Counter * 100) / (double)Flash_Size;
                          //  ESP_LOGI("MSI", " %.2f%%", percent);
                            
                            SendCmd_WriteBAT32A239_Flash();//下载进度
                        }
                    }
                    
                }
                break;
        case 3:
                if (BAT32A239_ACK.CMDH==CMD_DATA_CRC_CHECK)
                {
                    if (BAT32A239_ACK.dat.verification.CR1==0x01)
                    {
                        ESP_LOGI("MSI","Err : %2x \n",BAT32A239_ACK.dat.download.CR2);
                        Step_delayTime = 0;
                    }
                    if (BAT32A239_ACK.dat.verification.CR1==0x00)
                    {
                        UpgradeStep=5;
                        ESP_LOGI("MSI","UpgradeStep : %d verification OK !\n",UpgradeStep);
                    }
                }
                else
                {
                    if((Step_delayTime % 20) == 0)
                    {
                        SendCmd_CrcCheckBAT32A239_Flash();//校验flash
                    }
                    Step_delayTime++;
                }
                
                //UpgradeStep=9;
                break;   
        case 4:
                if(BackupDataTotalLen != 0)
                {
                    if(DataTotalLen == BackupDataTotalLen)
                    {
                        UpgradeStep = 0;
                    }
                    else 
                    {
                        UpgradeStep = 1;
                        
                    }
                    if(DataTotalLen > MAX_OTA_BUFF)
                    {
                        //ESP_LOGI("MSI","~~~~~~~~~~~~~~~~~~~~~~\n");
                        Flash_Size = MAX_OTA_BUFF;
                        esp_partition_read(assert_update_partition,StartAddr - BackupStartAddr + 16,buf,Flash_Size);
                        DataTotalLen -= Flash_Size;
                    }
                    else if(DataTotalLen != 0)
                    {
                        //ESP_LOGI("MSI","!!!!!!!!!!!!!!!!!!!!!!!!!!\n");
                        Flash_Size = DataTotalLen;
                        esp_partition_read(assert_update_partition,StartAddr - BackupStartAddr + 16,buf,Flash_Size);
                        DataTotalLen = 0;
                    }
                    else
                    {
                        UpgradeStep = 3;
                        Step_delayTime = 0;
                    }
                }

                break;
        default:
                UpgradeStep=5;
                /*Flash_Size =0;
                temp_Size =0;
                Write_Counter=0;
                StartAddr = 0;
                BackupStartAddr = 0;
                DataTotalLen = 0;
                BackupDataTotalLen = 0;*/
                break;
    }
    

}


Protocol_uint32_t CalcCrc32(Protocol_uint8_t buf[], int Len)
{
    int i,j;
    int n = 0;
    Protocol_uint8_t LE32buf[4];
    Protocol_uint32_t crc = 0xFFFFFFFF; // Initial value
    
    for (n = 0; n < Len; n+=4) 
    {
      LE32buf[0]=buf[n+3];//[n+0];//
      LE32buf[1]=buf[n+2];//[n+1];//
      LE32buf[2]=buf[n+1];//[n+2];//
      LE32buf[3]=buf[n+0];//[n+3];//
      for(j=0;j<4;j++)
      {
        crc ^= (Protocol_uint32_t)LE32buf[j] << 24; 
        for (i = 0; i < 8; ++i)
        {
            if (crc & 0x80000000) 
            {
              crc = (crc << 1) ^ 0x04C11DB7; // 0xEDB88320= reverse 0x04C11DB7
            } 
            else 
            {
              crc = (crc << 1);
            }
        }    
      }


    }
    
    return crc;
}

 Protocol_uint32_t UpdateBAT32A239Protocol_Parse(const Protocol_uint8_t *pData, Protocol_uint32_t len)
 {
Protocol_uint8_t remainLen = len;    // 剩余数据长度 Remaining data length
    Protocol_uint8_t dataLen;            // 数据包长度 Packet length
    Protocol_uint8_t frameLen=0;           // 帧长度 Frame length
    Protocol_uint8_t  checksumXor=0;

    int               i = 0;

    /**
     * 以下部分需要根据协议格式进行相应的修改，解析出每一帧的数据
     */
    while ( remainLen >= 7 )
    {
        // 找到一帧数据的数据头
        // Find the data header of a frame of data
        while ( (remainLen >= 2) && ((pData [ 0 ] != 0xAA) || (pData [ 1 ] != 0x55)) )
        {
            pData++;
            remainLen--;
            continue;
        }
        
        dataLen  = pData [ 4 ];//实际是[4][5]小端排序，但实际么有那么多直接取低字节
        // 0     1        2       3      4     5       6~n     6+n+1  6+n+2  6+n+3    
        //STA1 + STA2+{< CMD_H + CMD_L + LENL+LENH > + (DAT) + <CR1 + CR2> }+XOR
        frameLen = dataLen;//准确的一帧数据长度
        
//         if ( frameLen > remainLen )// 数据内容不全
//         {           
// #ifdef DEBUG_PRO_DATA
//             printf("Incomplete data packet!!!!!!\n");
// #endif
//             break;
//         }
        
        // checksumXor=pData[0];
        /*在 BOOT V1.0 的版本（获取版本信息命令见章节 2.3.2），异或运算不对 CR2
        运算，只对 CR2 前面的字节进行运算， 即（STA1 + STA2 + {< CMD_H + CMD_L 
        + LEN > + (DAT) + <CR1 >}）。
        */
       if(remainLen==frameLen)
       {
            for ( i = 0; i < remainLen-1; i++)
            {
                checksumXor^=pData[i];
            }
            // printf("Dataxor =%2x-- pData[remainLen-2] = %2x",checksumXor,pData[remainLen-2] );
       }
        if (checksumXor!=pData[remainLen-1])//抛弃坏帧
        {
        // 打印一帧数据，需要时在CommDef.h文件中打开DEBUG_PRO_DATA宏
#ifdef DEBUG_PRO_DATA
        for ( i = 0; i < frameLen; ++i )
        {
            printf("%x ", pData [ i ]);
        }printf("\n");
#endif
            break;
        }
        memcpy(&BAT32A239_ACK.CMDH,&pData[2],frameLen-1);

        pData += frameLen;
        remainLen -= frameLen;
    }

    return len - remainLen;
 }