#include "app_Ble_User.h"
#include "gatts_table_creat_demo.h"
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include "string.h"
#include "freertos/FreeRTOS.h"
#include "freertos/task.h"
#include "freertos/event_groups.h"
#include "freertos/semphr.h"
#include "MCU_Core_Protocol.h"
#include "Protocol_User.h"
#include "main_user.h"

#define TAG "APP_BLE_USER"



app_Ble_User_Data_Union BleRecData;
app_Ble_User_Data_Union BleTransData;
app_Ble_Rec_Data_Ctrl_Struct RecCtrl;

uint8_t Wifi_OTA_Request = 0;

uint8_t ble_key[32]   =  "1BJ7J8S";
uint8_t ble_uerid[32] =  {0};
uint8_t ble_pwd[32]   =  {0};
uint8_t flavor[4]   =  {0x33, 0, 0, 0};


SemaphoreHandle_t BleRecSuc_Semaphore;




Ble_User_Control_Struct Ble_User;
Ble_Tpms_Info_Struct Ble_Tpms_Data;


uint8_t tp_Ble_Crc(uint8_t *data, uint32_t len )
{
    uint8_t val = 0;

    for(uint32_t i = 0; i<len; i++)
    {
        val ^= data[i];
    }

    return val;
}

void Ble_Clear_Rx_Buffer(void )
{
    for(int i = 0; i< sizeof(BleRecData.Data); i++)
    {
        BleRecData.Data[i] = 0;
    }
}

void Ble_Clear_Tx_Buffer(void )
{
    for(int i = 0; i< sizeof(BleTransData.Data); i++)
    {
        BleTransData.Data[i] = 0;
    }
}



/**************************************************************************/

/**************************************************************************/

uint8_t Ble_Get_User_Info(void )
{
    uint8_t i = 0;
    uint8_t ret = 0;


    if(Ble_User.UseridUpdate)
    {
        ret = 1;
    }
    else
    {
        ret = 0;
    }

    return ret;
}

void Get_Ble_Raw_Data(uint8_t *data, uint32_t len)
{
    uint8_t err = 0;
    uint8_t crc = 0;

    if(len > 1024)
    {
        return;
    }
    

    if(data[0] == 0x24)
    {
        if(RecCtrl.Sts == BleRec_Idle)
        {
            // printf("receive data:");
            //     for(uint16_t i = 0; i< len; i++)
            //     {
            //         printf(" %x ", data[i]);
            //     }
            //     printf("\r\n");

            //     printf("\r\n");

            RecCtrl.RecLen = 0;
            memcpy(( uint8_t * )&BleRecData.Data[RecCtrl.RecLen], data, len);
            RecCtrl.TotalLen = BleRecData.Msg.Lenth +1 ;
            RecCtrl.RecLen += len;
            if(RecCtrl.RecLen >= RecCtrl.TotalLen)
            {
                crc = tp_Ble_Crc(BleRecData.Data, RecCtrl.TotalLen - 2);

                // printf("receive data:");
                // for(uint16_t i = 0; i< RecCtrl.TotalLen; i++)
                // {
                //     printf(" %x ", BleRecData.Data[i]);
                // }
                // printf("\r\n");

                // printf("rec crc = %d\r\n", crc);


                if((BleRecData.Data[RecCtrl.TotalLen - 1] != 0x0A) || (crc != BleRecData.Data[RecCtrl.TotalLen - 2]))
                {
                    Ble_Clear_Rx_Buffer();
                    RecCtrl.Sts = BleRec_Idle;
                }
                else
                {
                    RecCtrl.Sts = BleRec_Suc;

                    xSemaphoreGive(BleRecSuc_Semaphore);
                }
            }
            else
            {
                RecCtrl.Sts = BleRec_Start;

                // printf("BleRec_Start \r\n");
            }
        }
    }
    else
    {
        if(RecCtrl.Sts == BleRec_Start)
        {
            if((RecCtrl.RecLen+len) <= RecCtrl.TotalLen)
            {
                memcpy(( uint8_t * )&BleRecData.Data[RecCtrl.RecLen], data, len);
                RecCtrl.RecLen += len;

                if(RecCtrl.RecLen >= RecCtrl.TotalLen)
                {
                    crc = tp_Ble_Crc(BleRecData.Data, RecCtrl.TotalLen - 2);

                    // printf("receive data:");
                    // for(uint16_t i = 0; i< RecCtrl.TotalLen; i++)
                    // {
                    //     printf(" %x ", BleRecData.Data[i]);
                    // }
                    // printf("\r\n");

                    // printf("rec crc = %d\r\n", crc);

                    if((BleRecData.Data[RecCtrl.TotalLen - 1] != 0x0A) || (crc != BleRecData.Data[RecCtrl.TotalLen - 2]))
                    {
                        Ble_Clear_Rx_Buffer();
                        RecCtrl.Sts = BleRec_Idle;
                    }
                    else
                    {
                        RecCtrl.Sts = BleRec_Suc;

                        xSemaphoreGive(BleRecSuc_Semaphore);
                    }
                }
            }
            else
            {
                //len err
                Ble_Clear_Rx_Buffer();
                RecCtrl.Sts = BleRec_Idle;
            }
        }
    }

}



/**************************************************************************/

/**************************************************************************/

void Ble_Msg_Authr_RLY(void )
{
    uint8_t total_frame = 0;
    uint8_t trans_len = 0;
    int err;
    //Authr suc
    BleTransData.Msg.FrameHeader = 0x24;
    BleTransData.Msg.Cmd = 0x58;
    BleTransData.Msg.Lenth = 104;
    if((BleTransData.Msg.Lenth+1) % 20 == 0)
    {
        total_frame = (BleTransData.Msg.Lenth+1) / 20;
    }
    else
    {
        total_frame = (BleTransData.Msg.Lenth+1) / 20 + 1;
    }
    
    if(Ble_Get_User_Info())
    {
        memcpy(( uint8_t * )&BleTransData.Msg.Param[0], ble_key, 32);
        memcpy(( uint8_t * )&BleTransData.Msg.Param[32], ble_uerid, 32);
        memcpy(( uint8_t * )&BleTransData.Msg.Param[64], ble_pwd, 32);
        memcpy(( uint8_t * )&BleTransData.Msg.Param[96], flavor, 4);
    }
    BleTransData.Data[BleTransData.Msg.Lenth - 1] = tp_Ble_Crc(BleTransData.Data, BleTransData.Msg.Lenth - 1);
    BleTransData.Data[BleTransData.Msg.Lenth] = 0x0A;

    for(uint8_t i = 0; i < total_frame; i++)
    {
        if(((BleTransData.Msg.Lenth+1) - 20*i) >= 20)
        {
            trans_len = 20;
        }
        else
        {
            trans_len = (BleTransData.Msg.Lenth+1) - 20*i;
        }

        // printf("trans_len = %d\r\n", trans_len);

        // printf("trans data:");
        // for(uint16_t j = 0; j< trans_len; j++)
        // {
        //     printf(" %x ", BleTransData.Data[j + i*20]);
        // }
        // printf("\r\n");

        // printf("\r\n");

        err = bsp_Ble_Gatts_Send_Indicate( trans_len, &BleTransData.Data[i*20]);

        // vTaskDelay(1);
    }
}

void Ble_MsgRec_Authr_Result_Analysis(void )
{
    //Authr result
    if(BleRecData.Msg.Param[0] == 0)
    {
        Ble_User.Ble_Sts = Ble_Authr;
        Ble_User.Request_Tpms = 1;

        printf("Authr suc\n");
    }
}



void Ble_Msg_RequestTpms_RLY(void )
{
    uint8_t total_frame = 0;
    uint8_t trans_len = 0;

    if(Ble_User.Request_Tpms)
    {
        BleTransData.Msg.FrameHeader = 0x24;
        BleTransData.Msg.Cmd = 0x14;
        BleTransData.Msg.Lenth = 9;
        if((BleTransData.Msg.Lenth+1) % 20 == 0)
        {
            total_frame = (BleTransData.Msg.Lenth+1) / 20;
        }
        else
        {
            total_frame = (BleTransData.Msg.Lenth+1) / 20 + 1;
        }

        BleTransData.Msg.Param[0] = 1;
        BleTransData.Msg.Param[1] = 80;
        BleTransData.Msg.Param[2] = 0;
        BleTransData.Msg.Param[3] = 3;
        BleTransData.Msg.Param[4] = 0;
        
        BleTransData.Data[BleTransData.Msg.Lenth - 1] = tp_Ble_Crc(BleTransData.Data, BleTransData.Msg.Lenth - 1);
        BleTransData.Data[BleTransData.Msg.Lenth] = 0x0A;

        for(uint8_t i = 0; i < total_frame; i++)
        {
            if(((BleTransData.Msg.Lenth+1) - 20*i) >= 20)
            {
                trans_len = 20;
            }
            else
            {
                trans_len = (BleTransData.Msg.Lenth+1) - 20*i;
            }

            // printf("trans_len = %d\r\n", trans_len);

            // printf("trans data:");
            // for(uint16_t j = 0; j< trans_len; j++)
            // {
            //     printf(" %x ", BleTransData.Data[j + i*20]);
            // }
            // printf("\r\n");

            // printf("\r\n");

            bsp_Ble_Gatts_Send_Indicate( trans_len, &BleTransData.Data[i*20]);

            // vTaskDelay(1);
        }

        Ble_User.Request_Tpms = 0;
    }


    
}

void Ble_MsgRec_Tpms_Analysis(void )
{
    //Tpms data
    Ble_Tpms_Data.Tpms_Sts = BleRecData.Msg.Param[0];
    Ble_Tpms_Data.Tpms_Turn = BleRecData.Msg.Param[1];
    Ble_Tpms_Data.Tpms_Dte[0] = BleRecData.Msg.Param[2];
    Ble_Tpms_Data.Tpms_Dte[1] = BleRecData.Msg.Param[3];
    Ble_Tpms_Data.Tpms_Dte[2] = BleRecData.Msg.Param[4];
    Ble_Tpms_Data.Tpms_Dte[3] = BleRecData.Msg.Param[5];


    printf("Tpms sts %d    Tpms_Turn %x   Tpms_Dte0 %x   Tpms_Dte1 %x   Tpms_Dte2 %x   Tpms_Dte3 %x\r\n", \
    Ble_Tpms_Data.Tpms_Sts, Ble_Tpms_Data.Tpms_Turn, Ble_Tpms_Data.Tpms_Dte[0], Ble_Tpms_Data.Tpms_Dte[1], Ble_Tpms_Data.Tpms_Dte[2],Ble_Tpms_Data.Tpms_Dte[3]);

    Ble_User.Tpms_Updat = 1;
    Ble_User.Tpms_T = 0;
}

void Ble_MsgRec_Tpms_Timeout(void )
{
    if(Ble_User.Tpms_Updat)
    {
        Ble_User.Tpms_T++;
        if(Ble_User.Tpms_T >= 100)
        {
            Ble_User.Tpms_Updat = 0;
            Ble_User.Tpms_T = 0;
        }
    }
    else
    {
        Ble_User.Tpms_T = 0;
    }
}



void Ble_Rec_Msg_Analysis_Process(void )
{
    
    
}


void Ble_Connect_Event_Pro(void )
{
    Ble_User.Ble_Sts = Ble_Conn;
    Ble_User.Request_Tpms = 0;
    Ble_User.Tpms_Updat = 0;
    Ble_User.Tpms_T = 0;

    Ble_Clear_Tx_Buffer();
    Ble_Clear_Rx_Buffer();
}


void Ble_DisConnect_Event_Pro(void )
{
    Ble_User.Ble_Sts = Ble_Idle;
    Ble_User.Request_Tpms = 0;
    Ble_User.Tpms_Updat = 0;
    Ble_User.Tpms_T = 0;

    RecCtrl.RecLen = 0;
    RecCtrl.TotalLen = 0;
    RecCtrl.Sts = BleRec_Idle;

    Ble_Tpms_Data.Tpms_Sts = 0;
    Ble_Tpms_Data.Tpms_Turn = 0;
    for(uint8_t i=0; i<sizeof(Ble_Tpms_Data.Tpms_Dte); i++)
    {
        Ble_Tpms_Data.Tpms_Dte[i] = 0;
    }
    

    Ble_Clear_Tx_Buffer();
    Ble_Clear_Rx_Buffer();
}


void Ble_User_Task(void *pvParameter)
{

    while (1)
    {
        // Ble_Rec_Msg_Analysis_Process();
        if (pdTRUE == xSemaphoreTake(BleRecSuc_Semaphore, portMAX_DELAY)) 
        {
            if(RecCtrl.Sts == BleRec_Suc)
            {
                if(BleRecData.Msg.Cmd == EC_BTP_P2C_CLIENT_INFO)
                {
                    Ble_Msg_Authr_RLY();
                }
                else if(BleRecData.Msg.Cmd == EC_BTP_P2C_CHECK_AUTH_RESULT)
                {
                    Ble_MsgRec_Authr_Result_Analysis();
                    Ble_Msg_RequestTpms_RLY();
                }
                else if(BleRecData.Msg.Cmd == EC_BTP_P2C_HUD)
                {
                    Ble_MsgRec_Tpms_Analysis();
                }

                Ble_Clear_Tx_Buffer();
                Ble_Clear_Rx_Buffer();
                RecCtrl.Sts = BleRec_Idle;
            }
        }
    }
    vTaskDelete(NULL);
}

TaskHandle_t  Ble_User_Task_hdl=NULL;

void Ble_User_Init(void )
{
    BleRecSuc_Semaphore =     xSemaphoreCreateBinary();

    Ble_User.Ble_Sts = Ble_Idle;
    Ble_User.Request_Tpms = 0;
    Ble_User.Tpms_Updat = 0;
    Ble_User.Tpms_T = 0;
    Ble_User.UseridUpdate = 0;

    RecCtrl.RecLen = 0;
    RecCtrl.TotalLen = 0;
    RecCtrl.Sts = BleRec_Idle;

    Ble_Tpms_Data.Tpms_Sts = 0;
    Ble_Tpms_Data.Tpms_Turn = 0;
    for(uint8_t i=0; i<sizeof(Ble_Tpms_Data.Tpms_Dte); i++)
    {
        Ble_Tpms_Data.Tpms_Dte[i] = 0;
    }
    

    Ble_Clear_Tx_Buffer();
    Ble_Clear_Rx_Buffer();


    xTaskCreatePinnedToCore(Ble_User_Task, "Ble_User", 4096, NULL, 10, Ble_User_Task_hdl, 0);
}
