#include <stdio.h>
#include "freertos/FreeRTOS.h"
#include "freertos/task.h"
#include "esp_log.h"
#include "driver/uart.h"
#include "esp_wifi.h"
#include "wifi_service.h"
#include "main_user.h"
static const char *TAG = "wifi_service";
extern void delele_tasks(void);
/*****************************************************
 * 首次启动HTTP服务器后, 如果一直没有STA设备加入
 * 就不能触发STA disconnect事件，也就不会自动关闭HTTP服务器
 * 所以需要额外判断这种情况, 当30秒关闭的定时器触发2次后直接关闭
 ******************************************************/
static unsigned char http_server_stop_counter = 0;
static unsigned char softap_service_stop_flag = 0;
        static unsigned short wifi_service_stop_timer = 0;
wifi_service_t wifi_service_info;

void wifi_service_init(void)
{
    wifi_service_stop_timer = 0;
    softap_service_stop_flag = 0;
    http_server_stop_counter = 0;
    wifi_service_info.status = WIFI_SERVICE_STOP;
    wifi_service_info.softap_status = SOFTAP_STOP;
    wifi_service_info.http_server_status = HTTP_SERVER_STOP;
    wifi_service_info.ota_partition = 0;
}

void wifi_service_timer(void)
{

    if (wifi_service_info.status == WIFI_SERVICE_START)
    {
        if (wifi_service_stop_timer < 300)
        {
            ++wifi_service_stop_timer;
        }

        // 每30秒尝试关闭WiFi服务
        if (wifi_service_stop_timer == 300)
        {
            wifi_service_info.status = WIFI_SERVICE_DEINIT;
        }
    }
}

void wifi_service_stop_timer_clear(void)
{
    wifi_service_stop_timer = 0;
}

void wifi_service(void)
{
    if (wifi_service_info.status == WIFI_SERVICE_INIT) // 收到指令: WiFi服务初始化
    {
        wifi_service_info.status = WIFI_SERVICE_START;
        ESP_LOGI(TAG, "----  开启WiFi服务...\n");

        // Bsp_Can_Sleep_Init();
        // uart_driver_delete(UART_NUM_1);
        // delele_tasks();
        softap_service_start();
    }
    else
    {
        if (wifi_service_info.status == WIFI_SERVICE_DEINIT) // 收到指令: WiFi服务反初始化, 先读取当前连接的STA数量
        {
            esp_err_t ret = esp_wifi_ap_get_sta_list(&softap_sta_list);
            if (ret == ESP_OK)
            {
                if (softap_sta_list.num == 0) // 当前没有STA连接
                {
                    if (softap_sta_connect == STA_CONNECTED_NEVER) // 从未有STA接入过
                    {
                        if (http_server_stop_counter == 1)
                        {
                            softap_service_stop_flag = 1;
                        }
                        else
                        {
                            ESP_LOGI(TAG, "首次启动HTTP服务器, 1分钟内不会关闭WiFi");
                            ++http_server_stop_counter; // 服务器开启状态且没有设备接入过, 延后30秒再关闭
                        }
                    }
                    else
                    {
                        softap_service_stop_flag = 1; // 关闭WiFi服务
                    }
                }
                else
                {
                    ESP_LOGI(TAG, "---- 有STA设备在线, 拒绝关闭WiFi");
                }
            }
            else
            {
                ESP_LOGI(TAG, "---- 读取当前连接的STA数量失败, 打印错误信息");
                esp_err_to_name(ret);
            }

            if (softap_service_stop_flag == 1)
            {
                wifi_service_info.status = WIFI_SERVICE_STOP;
                ESP_LOGI(TAG, "---- 关闭WiFi服务, 开启CAN总线, 重装LIN driver...");
                softap_service_stop();
                // Bsp_Can_Wakeup_Init();
                // bsp_Uart1_Init();
            }
            else
            {
                wifi_service_info.status = WIFI_SERVICE_START;
                wifi_service_stop_timer = 0; // 重置HTTP服务器关闭的定时器
            }
        }
    }
}

void wifiServiceStart(void)
{
    if(wifi_service_info.status == WIFI_SERVICE_STOP)
    {
        // 开启WiFi服务
        wifi_service_info.status = WIFI_SERVICE_INIT;
    }
}