#ifndef PROTOCOL_USER_H
#define PROTOCOL_USER_H

#include "Protocol_Lib.h"


void Protocol_KL30_Wakeup_Init(void);
void Protocol_Send_Service(void);    // 10ms任务调用
void UART_Put(Protocol_uint16_t Data);

typedef enum
{
    Prot_Idle = 0, 
    Prot_Starting,
    Prot_Start,
    Prot_Normal,
}Prot_User_State_Enum;
typedef struct
{
    uint8_t State;
    uint16_t TimeDelay;

}Protocol_User_Ctrl_Struct;

extern Protocol_User_Ctrl_Struct Prot_User;
void Protocol_User_Ctrl_Init(void );
void BAT32A239_MCU_Update(void);
void Prot_Send_Msg_Process(void );
Protocol_uint32_t CalcCrc32(Protocol_uint8_t buf[], int Len);
extern Protocol_uint32_t UpdateBAT32A239Protocol_Parse(const Protocol_uint8_t *pData, Protocol_uint32_t len);

#ifdef UPGRADE_N32G031
#define CMD_SET_BR          0x01//设置串口波特率
#define CMD_GET_INF         0x10//读取芯片型号索引、BOOT 版本号、芯片 ID
#define CMD_FLASH_ERASE     0x30//擦除 FLASH
#define CMD_FLASH_DWNLD     0x31//下载用户程序到 FLASH
#define CMD_DATA_CRC_CHECK  0x32//CRC 校验下载用户程
#define CMD_OPT_RW          0x40//读取/配置选项字节（包含了读保护等级、FLASH 页写保护、Data0/1 配置等）
#define CMD_SYS_RESET       0x50//系统复位
#define CMD_APP_GO          0x51//跳转到用户区执行程序
typedef struct 
{
    Protocol_uint8_t CMDH;  //宏定义所包含的
    Protocol_uint8_t CMDL;  
    Protocol_uint16_t LEN;  //不关心发送的端格式
    Protocol_uint8_t PAR[4];//需要处理好段格式
    Protocol_uint8_t DAT[160];//补充的数据直接补充好再传到下层
}UpdateProtocolStructure;//上层协议数据结构

typedef struct 
{	
 Protocol_uint8_t CMDH ;
 Protocol_uint8_t CMDL ;	
 Protocol_uint8_t LEN[2];
 union
 {
    Protocol_uint8_t DAT[128];
    struct 
    {
        Protocol_uint8_t unused_0   :8;
        Protocol_uint8_t BootVer    :8;
        Protocol_uint8_t BootCmdVer :8;
        Protocol_uint8_t UCID       [16];
        Protocol_uint8_t ChipID_UID [12];
        Protocol_uint8_t DBGMCU_IDCODE[4];
        Protocol_uint8_t Other      [16];
        Protocol_uint8_t CR1        :8;
        Protocol_uint8_t CR2        :8;
    }Chipinf;
    struct 
    {
        Protocol_uint8_t CR1        :8;
        Protocol_uint8_t CR2        :8;
    }Erase;
    struct 
    {
        Protocol_uint8_t CR1        :8;
        Protocol_uint8_t CR2        :8;
    }download;
    
    struct 
    {
        Protocol_uint8_t CR1        :8;
        Protocol_uint8_t CR2        :8;
    }verification;
    struct 
    {
        Protocol_uint8_t CR1        :8;
        Protocol_uint8_t CR2        :8;
    }reset;

    struct 
    {
        Protocol_uint8_t CR1        :8;
        Protocol_uint8_t CR2        :8;
    }appgo;
    struct 
    {
        struct Protocol_Lib
        {
            Protocol_uint8_t RDP ;
            Protocol_uint8_t nRDP ;
            Protocol_uint8_t USER ;
            Protocol_uint8_t nUSER ;
            Protocol_uint8_t Data0;
            Protocol_uint8_t nData0;
            Protocol_uint8_t Data1;
            Protocol_uint8_t nData1;
            Protocol_uint8_t WRP0;
            Protocol_uint8_t nWRP0;
            Protocol_uint8_t WRP1;
            Protocol_uint8_t nWRP1;
            Protocol_uint8_t RDP2;
            Protocol_uint8_t nRDP2;
            Protocol_uint8_t Reserved;
            Protocol_uint8_t nReserved;
        }optionbyte;
        Protocol_uint8_t CR1        :8;
        Protocol_uint8_t CR2        :8;
    }flashOpt;
    	
 }dat;	
 
}N32G031_ACK_Structure;//下层应答协议
extern N32G031_ACK_Structure N32G031_ACK;

Protocol_uint32_t UpdateN32G031Protocol_Send(UpdateProtocolStructure SendPd);
Protocol_uint32_t UpdateN32G031Protocol_Parse(const Protocol_uint8_t *pData, Protocol_uint32_t len);
#endif
#endif
