
#include "app_BT_User.h"
#include <stdio.h> 
#include "bt_app_hf.h"
#include "freertos/FreeRTOS.h"
#include "freertos/task.h"
#include "bt_app_main.h"
extern esp_bd_addr_t peer_addr;

#define TAG "APP_BLE_USER"

BT_User_Control_Struct BT_User;

#define BT_ReConn_T 3000

void BT_User_Init(void )
{
    BT_User.BT_Sts = BT_Idle;
    BT_User.Call_Sts = Call_Idle;
    BT_User.ReconnTime = BT_ReConn_T - 500;
    BT_User.HF_Ctrl = HF_Idle;

}

void BT_Connect_Event_Pro(void )
{
    BT_User.BT_Sts = BT_Conn;
    BT_User.Call_Sts = Call_Idle;
    BT_User.ReconnTime = BT_ReConn_T - 500;
    BT_User.HF_Ctrl = HF_Idle;
    printf("TB CONN\r\n");
}


void BT_DisConnect_Event_Pro(void )
{
    BT_User.BT_Sts = BT_Idle;
    BT_User.Call_Sts = Call_Idle;
    BT_User.ReconnTime = BT_ReConn_T - 500;
    BT_User.HF_Ctrl = HF_Idle;
    printf("TB DISCONN\r\n");
}

void BT_User_Process(void )
{
    switch(BT_User.Call_Sts)//电话状态
    {
        case Call_OutCalling://打电话中
        {
            if(BT_User.HF_Ctrl == HF_Reject)
            {
                hf_reject_handler();//挂断
            }
            break;
        }
        case Call_IncomeCalling://响铃时
        {
            if(BT_User.HF_Ctrl == HF_Reject)
            {
                hf_reject_handler();//挂断
            }
            else if(BT_User.HF_Ctrl == HF_Answer)
            {
                hf_answer_handler();//接听
            }
            break;
        }
        case Call_InProcess://接电话中
        {
            if(BT_User.HF_Ctrl == HF_Reject)
            {
                hf_reject_handler();
            }

            break;
        }
        case Call_Idle:
        {
            break;
        }
    }

    BT_User.HF_Ctrl = HF_Idle;


    if(BT_User.BT_Sts == BT_Idle)
    {
        BT_User.ReconnTime++;
        if(BT_User.ReconnTime >= BT_ReConn_T)
        {
            printf("Connect Start.................\n");
            if(app_BT_Get_BondDev() == 1)
            {
                esp_hf_client_connect(peer_addr);
            }
            
            printf("Connect Over\n");

            BT_User.ReconnTime = 0;
        }
    }
    else
    {
    }
}








