/*
* bsp_TFT.c
*
*  Created on: Aug 8, 2014
*      Author: QTC
*/


#define  GLOBALS_BSP_TFT
#include "defines.h"
#include "g_includes.h"

/*------------------------------------------------------------ -------------
* Function Name  : bsp_TFT_Init
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void bsp_TFT_Init(void)
{
    bsp_PortEnable();
    bsp_ReStart();
    bsp_Delay(Delay2_5us);
    
    bsp_WriteComm(0x5e);  //-- SWreset
    bsp_WriteData(0xa5);
    
    bsp_WriteComm(0x49);//VCOM normalization
    bsp_WriteData(0x0e);
    bsp_WriteData(0x00);
    bsp_WriteData(0x00);
    bsp_WriteData(0xa5);
    
    bsp_WriteComm(0x61);  //-- all PWR on
    bsp_WriteData(0x8f);
    bsp_WriteData(0x44);
    bsp_WriteData(0x02);
    bsp_WriteData(0xa5);
    
    bsp_WriteComm(0x5a); //-- TEST
    bsp_WriteData(0x20);
    bsp_WriteData(0x71);
    bsp_WriteData(0xa5);
    bsp_WriteData(0xa5);
    
    bsp_WriteComm(0x71); //-- VCOM/VGH/VGL setting
    bsp_WriteData(0x3d);
    bsp_WriteData(0x0b); //updata this parameter by tianma 2015.3.31
    bsp_WriteData(0x0b);
    bsp_WriteData(0xA5);
    
    bsp_WriteComm(0x72); //-- GVDD/GVCL
    bsp_WriteData(0x19);
    bsp_WriteData(0x19);
    bsp_WriteData(0xa5);
    bsp_WriteData(0xa5);
    
    bsp_WriteComm(0x91);  //
    bsp_WriteData(0x01);
    bsp_WriteData(0x3F);
    bsp_WriteData(0x00);
    bsp_WriteData(0xEF);
    
    bsp_WriteComm(0x92);  //
    bsp_WriteData(0x32);  //32
    bsp_WriteData(0x02);
    bsp_WriteData(0x00);
    bsp_WriteData(0x01);
    
    bsp_WriteComm(0x93);  //
    bsp_WriteData(0x0A);
    bsp_WriteData(0x28);
    bsp_WriteData(0x0C);
    bsp_WriteData(0x26);
    
    bsp_WriteComm(0x21); //--
    bsp_WriteData(0x00); //--MV = 0; MX=1; MY=1
    bsp_WriteData(0xa5);
    bsp_WriteData(0xa5);
    bsp_WriteData(0xa5);
    
    bsp_WriteComm(0x24); //
    bsp_WriteData(0x00);
    bsp_WriteData(0xa5);
    bsp_WriteData(0xa5);
    bsp_WriteData(0xa5);
    
    bsp_WriteComm(0x25); //-- BPP Select
    bsp_WriteData(0x00);
    bsp_WriteData(0xa5);
    bsp_WriteData(0xa5);
    bsp_WriteData(0xa5);
    
    bsp_WriteComm(0x26); //-- MDCTL
    bsp_WriteData(0x00);
    bsp_WriteData(0x00);
    bsp_WriteData(0x00);
    bsp_WriteData(0xa5);
    
    bsp_WriteComm(0xA2); //-- Gate Set VGPP = Inside; ScanDir = Normal; scan mode = scan mode 1
    bsp_WriteData(0x10); //180ȷת
    bsp_WriteData(0xa5);
    bsp_WriteData(0xa5);
    bsp_WriteData(0xa5);
    
    bsp_WriteComm(0x69); //-- ACSET
    bsp_WriteData(0x00); //
    bsp_WriteData(0xa5);
    bsp_WriteData(0xa5);
    bsp_WriteData(0xa5);
    
    bsp_WriteComm(0x86); //-- GAMMA setting original//for KGP reference//Gamma Set 1bpp
    bsp_WriteData(0x00);
    bsp_WriteData(0x3f);
    bsp_WriteData(0x00);
    bsp_WriteData(0x3f);
    
    bsp_Delay(Delay2_5us);
    
    bsp_WriteComm(0x13); //-- sleep out
    bsp_WriteData(0xa5);
    
    bsp_Delay(20000);
    
    bsp_WriteComm(0x12); //-- display on
    bsp_WriteData(0xa5);
    
    CSB = HIGH;
    
    bsp_ClearFullWindow(null);
    
}
/*-------------------------------------------------------------------------
* Function Name  : bsp_ClearFullWindow
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void bsp_ClearFullWindow(INT8U full)
{
    INT8U i,j;
    bsp_SetWindow(0,0,239,39);
    bsp_WriteComm(WriteCmd); //-- write data command
    bsp_WriteData(0xa5);
    for(i = 0 ;i < 40;i++)
    {
        bsp_WDOG_Feed();
        for(j = 0;j < 240;j++)
        {
            bsp_WriteData(full);
        }
    }
}

/*-------------------------------------------------------------------------
* Function Name  : bsp_ReStart
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void bsp_ReStart(void)
{
    RSTB = LOW;
    bsp_Delay(Delay2_5us);
    RSTB = HIGH;
}

/*-------------------------------------------------------------------------
* Function Name  : bsp_WriteComm
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void bsp_WriteComm(INT8U COMMAND)
{
    CSB = LOW;
    A0 = LOW;
    XRD = HIGH;
    XWR = LOW;
    DATADIR = FULLOUT;
    NOP();
    DATA = COMMAND;
    NOP();
    NOP();
    NOP();
    NOP();
    XWR = HIGH;
    NOP();
    NOP();
    NOP();
    NOP();
    DATA = 0;
    CSB = HIGH;
}
/*-------------------------------------------------------------------------
* Function Name  : bsp_WriteData
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void bsp_WriteData(INT8U D)
{
    CSB = LOW;
    A0 = HIGH;
    XRD = HIGH;
    XWR = LOW;
    DATADIR = FULLOUT;
    NOP();
    DATA = D;
    NOP();
    NOP();
    NOP();
    NOP();
    XWR = HIGH;
    NOP();
    NOP();
    NOP();
    NOP();
    DATA = 0;
    CSB = HIGH;
}

/*-------------------------------------------------------------------------
* Function Name  : bsp_ReadData
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
INT8U bsp_ModifyReadData(void)
{
    INT8U D;
    CSB = LOW;
    A0 = HIGH;
    XWR = HIGH;
    NOP();
    DATADIR = FULLIN;
    NOP();
    XRD = LOW;
    NOP();
    NOP();
    NOP();
    NOP();
    NOP();
    NOP();
    NOP();
    NOP();
    D = DATA;
    XRD = HIGH;
    NOP();
    NOP();
    NOP();
    NOP();
    NOP();
    NOP();
    NOP();
    NOP();
    NOP();
    CSB = HIGH;
    return D;
}
/*-------------------------------------------------------------------------
* Function Name  : bsp_SetWindow
* Description    :
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void bsp_SetWindow(INT16U x,INT16U y,INT16U x1,INT16U y1)
{
    bsp_WriteComm(0x22);
    bsp_WriteData((INT8U)y);  //-- start page
    bsp_WriteData((INT8U)y1);  //-- end page
    bsp_WriteData(0x00);   //-- start Frame Address
    bsp_WriteData(0xa5);
    
    bsp_WriteComm(0x23);
    bsp_WriteData((INT8U)(x >> 8));  //-- start col
    bsp_WriteData((INT8U)x);
    bsp_WriteData((INT8U)(x1 >> 8)); //-- end col
    bsp_WriteData((INT8U)x1);
}

/*-------------------------------------------------------------------------
* Function Name  : bsp_PortEnable
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void bsp_PortEnable(void)
{
    CSB = LOW;
    bsp_Delay(Delay2_5us); //tCSS6
}
/*-------------------------------------------------------------------------
* Function Name  : bsp_PortDisable
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void bsp_PortDisable(void)
{
    CSB = HIGH;
    bsp_Delay(Delay2_5us);
}
/*-------------------------------------------------------------------------
* Function Name  : bsp_PowerSave
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void bsp_PowerSave(void)
{
    bsp_WriteComm(0x11);       //display off
    bsp_WriteData(0xa5);
    bsp_WriteComm(0x14);
    bsp_WriteData(0xa5);
    NOP();
    NOP();
    NOP();
    NOP();
    bsp_ReStart();
    bsp_PortDisable();
    DATA = null;
}
/*-------------------------------------------------------------------------
* Function Name  : bsp_Delay
* Description    : 
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void bsp_Delay(INT32U time)
{
    INT32U i;

    for(i = 0;i<= time;i++)
    {
        asm NOP;
    	  bsp_WDOG_Feed();
    } 
}
/*-------------------------------------------------------------------------
* Function Name  : bsp_WDOG_Feed
* Description    :
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void bsp_WDOG_Feed(void)
{
    _FEED_COP();
}