/*
 * api_PWM.c
 *
 *  Created on: Aug 6, 2014
 *      Author: QTC
 */


#define  GLOBALS_API_PWM
#include "defines.h"
#include "g_includes.h"

/*--------------------------------------------------------------------------
* Function Name  : Api_PWM_Init            clock A =   Bus clock / 8
* Description    :
* Input          : None                   clock SA =   Clock A / (2 * PWMSCLA)
* Output         : None
* Return         : None                            = 250khz
* onther         : qitiancun
--------------------------------------------------------------------------*/
void Api_PWM_Init(void)
{
    PWME   =   0;
    PWMCLK =   (Channel_0|Channel_4);         //ͨ 1 2 ʱѡ
    PWMPOL =   (Channel_0|Channel_4);
                                             //       32M
    PWMPRCLK = 0x66;                         //ʱ = busclk / 8        = CLODK A/B
    PWMCAE   = ~(Channel_0|Channel_4);       //ͨ  Գ
    PWMCTL   = 4;

    PWMDTY0  = null;
    PWMDTY1  = null;

    PWMSCLA =  8;
    PWMSCLB =  8;

    PWMPER0  = 50;         //PWM 
    PWMPER1  = 50;         //PWM      
}
/*-------------------------------------------------------------------------
* Function Name  : Api_LcdLightCtl                                  Lcd
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Api_LcdLightCtl(INT8U duty, INT8U Cycle)
{
    if(PWME_PWME1 == 0)
    {
        PWME_PWME1 = 1;
    }
    PWMDTY1  = duty;
    PWMPER1  = Cycle;       //PWM 
}
/*-------------------------------------------------------------------------
* Function Name  : Api_LcdLightOFFCtl                            Lcd 
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Api_LcdLightOFFCtl(void)
{
    PWME_PWME1 = Disable;
    LED_BL_PWM = LightOff;
}
/*-------------------------------------------------------------------------
* Function Name  : Api_MeterLightCtl                               Ǳ
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Api_MeterLightCtl(INT8U duty, INT8U Cycle)
{
    if(PWME_PWME0 == 0)
    {
        PWME_PWME0 = 1;
    }
    PWMDTY0  = duty;
    PWMPER0  = Cycle;       //PWM 
}
/*-------------------------------------------------------------------------
* Function Name  : Api_MeterLightOFFCtl                         Ǳ 
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Api_MeterLightOFFCtl(void)
{
    PWME_PWME0 = Disable;
    LCD_BL_PWM = LightOff;
}
/*-------------------------------------------------------------------------
* Function Name  : Api_BeepCtl
* Description    : 
* Input          :
* Output         : None
* Return         : None
* onther         :
Clock SA = Clock A / (2 * PWMSCLA)
Clock A = Bus/div1
--------------------------------------------------------------------------*/
void Api_BeepCtl(INT8U duty1, INT8U duty2, INT8U Cycle)
{
    PWME_PWME4 = Enable;
    PWME_PWME5 = Enable;

    PWMPER4  = Cycle;       //PWM2 
    PWMPER5  = Cycle;       //PWM3 
    PWMDTY4  = duty1;
    PWMDTY5  = duty2; 
}

