#include "NM_includes.h"
#include "defines.h"
/*-------------------------------------------------------------------------
* Function Name  : NM_Time_2ms_Count                             NM_2ms
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void NM_Time_2ms_Count(void)
{
    unsigned char i;
    if (NmPara.NmTime.TmaxEnable) {
        if (NmPara.NmTime.TmaxTime < NmPara.NmTime.OverTmaxTime) {
            NmPara.NmTime.TmaxTime += 2;
        }
    }
    
    if (NmPara.NmTime.TtypEnable) {
        if (NmPara.NmTime.TtypTime < NmPara.NmTime.OverTtypTime) {
            NmPara.NmTime.TtypTime += 2; //ΪʼɵλmsԼ2
        }
    }
    
    if (NmPara.NmTime.TwbsEnable) {
        if (NmPara.NmTime.TwbsTime < NmPara.NmTime.OverTwbsTime) {
            NmPara.NmTime.TwbsTime += 2;
        }
    }
    
    if (NmPara.NmTime.SleepEnable) {
        if (NmPara.NmTime.SleepTime < NmPara.NmTime.OverSleepTime) {
            NmPara.NmTime.SleepTime += 2;
        }
    }

    if(NmPara.NmTime.NM_CheckTime < 10) {
        NmPara.NmTime.NM_CheckTime++;
    }
    
    NM_tSleepRequTimeCount_Fun();
    
    if(NmPara.AppMsgSendRequest) {
      for (i = 0; i < 20; i++) {
        if(NmPara.AppMsg[i].AppCycleTime) {
    			NmPara.AppMsg[i].AppCycleTime--;   //ⷢ0
        
    		}  
      }
  		
    }
}

/*-------------------------------------------------------------------------
* Function Name  : NM_TranMsgSuccessDetect
* Description    : palace in interrupt
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void NM_TranMsgSuccessDetect(void)
{
//    unsigned int tmp;
    NmPara.NmTxState = 1;
    NmPara.NmErrState = 0;
    NM_D_Online();
}

/*-------------------------------------------------------------------------
* Function Name  : NM_CheckSleep_Fun
* Description    : check self sleep condition
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void NM_CheckSleep_Fun(void)
{
    NM_LocalWakeup_Fun();
}

/*-------------------------------------------------------------------------
* Function Name  : NM_LocalWakeup_Fun
* Description    : KL15 voltage wakeup event handle
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void NM_LocalWakeup_Fun(void)
{
	if (NmPara.NmIGNState == NM_IGN_ON) {
		if(NmPara.NmNetWorkStatus.WakeupEvent != NM_LocalWakeup) {
			NmPara.NmNetWorkStatus.WakeupEvent = NM_LocalWakeup;
			TalkNM();
		}
		NmPara.NmSleepRequestMin = 0;
		NmPara.NmSendPdu.bits.Opcode &= 0xCF;
		NmPara.NmNetWorkStatus.bussleep = NM_NO;
	} else {
		if(NmPara.NM_Main_Program != NMBusSleep_main) {
			NmPara.NmNetWorkStatus.WakeupEvent = NM_WaitWakeup;
		}

		if (NmPara.NmLastSendPDUType == LIMP_HOME_MSG) {
			if (NmPara.NmLimpHomeTxCnt >= NmPara.NmTimeRequestLimpSleepInd) {
				NmPara.NmLimpHomeTxCnt = 0;
				NmPara.NmNetWorkStatus.bussleep = NM_YES;
			}
		} else if((NmPara.NmLastSendPDUType == ALIVE_MSG) || (NmPara.NmLastSendPDUType == RING_MSG)) {
			if(NmPara.NmSleepRequestMin >= NmPara.NmTimeRequestSleepInd) {
				NmPara.NmNetWorkStatus.bussleep = NM_YES;
			}
		}
	}
}

void NM_SetIgnState(INT8U n) 
{
  NmPara.NmIGNState = n;  
}

void NM_SetBusOffRecoverEvent(void) 
{
  NmPara.NmNetWorkStatus.BusOffEvent = ENABLE;  
}

/*-------------------------------------------------------------------------
* Function Name  : NM_CheckBusOff_Fun
* Description    : handle Busoff interface function
* Input          : after busoff into limphome state
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void NM_CheckBusOff_Fun(void)
{
    if (NmPara.NmNetWorkStatus.BusOffEvent) {
        NmPara.NmNetWorkStatus.BusOffEvent = DISABLE0;
        AbortAllCanTx();
  	    NmPara.AppMsgSendRequest = 0;
        CancelAlarm(NmPara.NmTimeType);
        CancelAlarm(NmPara.NmTimeMax);
        NM_SetTSendTimer(NmPara.NmTimeError, (_NM_TimeInfo*)&NmPara.NmTime);
        NM_State_Transformation(NMLimpHome_main);
    }
}

/*-------------------------------------------------------------------------
* Function Name  : NM_RemoteWakeup_Fun
* Description    : Remote data or PDU Frame wakeup event handle
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void NM_RemoteWakeup_Fun(void)
{
    TalkNM();
    NmPara.NmNetWorkStatus.WakeupEvent = NM_RemoteWakeup;
    NmPara.NmNetWorkStatus.bussleep = NM_NO;
    NmPara.NmSleepRequestMin = 0;
}

/*-------------------------------------------------------------------------
* Function Name  : NM_tSleepRequTimeCount_Fun
* Description    : tSleepRequestN / tSleepRequestL count
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void NM_tSleepRequTimeCount_Fun(void)
{ 
    if ((NmPara.NmSendPdu.bits.Opcode & 0x10) == 0) {
        if(NmPara.NmSleepRequestMin <= NmPara.NmTimeRequestSleepInd) {
            NmPara.NmSleepRequestMin += 2;
        }
    }
}

/*-------------------------------------------------------------------------
* Function Name  : NM_Receive_isr_Fun
* Description    : handle receive PDU;
* Input          :
* Output         : None
* Return         : None
* onther         : propose : in interrupt function
--------------------------------------------------------------------------*/
void NM_Receive_isr_Fun(unsigned long id, unsigned char *pBuf)
{
    if ((id >= NmPara.NmIdBase) && (id <= NmPara.NmIdBottom)) {
        if (NmPara.NmPduBuf.bits.ProceF == BUF_EMPTY) {
            NmPara.NmIdBuf = id - NmPara.NmIdBase;
            NmPara.NmPduBuf.msg[ 0 ] = *(pBuf + 0);
            NmPara.NmPduBuf.msg[ 1 ] = *(pBuf + 1);
            NmPara.NmPduBuf.msg[ 2 ] = *(pBuf + 2);
            NmPara.NmPduBuf.msg[ 3 ] = *(pBuf + 3);
            NmPara.NmPduBuf.msg[ 4 ] = *(pBuf + 4);
            NmPara.NmPduBuf.msg[ 5 ] = *(pBuf + 5);
            NmPara.NmPduBuf.msg[ 6 ] = *(pBuf + 6);
            NmPara.NmPduBuf.msg[ 7 ] = *(pBuf + 7);
            NmPara.NmPduBuf.bits.ProceF = BUF_FULL;
        }
    }
}

/*-------------------------------------------------------------------------
* Function Name  : NM_Send_PDU_Fun                               ID18FFF017
* Description    : Send PDU Message interface function
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void NM_Send_PDU_Fun(void)
{   
    INT32U tmp;
    tmp = NmPara.NmIdBase + NmPara.NmIdOwn;
    NmPara.NmSendPdu.msg[0] = NmPara.NmDestination;
    
    NmPara.NmSendPdu.msg[2] = 0;   //2021/03/18, 00վհFFλ
    NmPara.NmSendPdu.msg[3] = 0;
    NmPara.NmSendPdu.msg[4] = 0;
    NmPara.NmSendPdu.msg[5] = 0;    
    NmPara.NmSendPdu.msg[6] = 0;
    NmPara.NmSendPdu.msg[7] = 0; 
        
    MSCAN_SendFrame(tmp,(INT8U*)&NmPara.NmSendPdu.msg[0],8);
}

/*-------------------------------------------------------------------------
* Function Name  : NM_Send_App_Fun                         
* Description    : Send Application Message interface function
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void NM_Send_App_Fun(void)
{
  unsigned char i;
	if (NmPara.NmNetWorkStatus.BusOffEvent) { //at busoff disable send app msg
	  AbortAllCanTx();
	  NmPara.AppMsgSendRequest = 0;
		return;
	}

	if(NmPara.AppMsgSendRequest) {
	  for (i = 0; i < 20; i++) {
	     if ((NmPara.AppMsg[i].Valid) && (NmPara.AppMsg[i].AppCycleTime == 0)) {
    			NmPara.AppMsg[i].AppCycleTime = NmPara.AppMsg[i].AppCycleTimeMax;
    			 MSCAN_SendFrame(NmPara.AppMsg[i].AppId,NmPara.AppMsg[i].AppData,NmPara.AppMsg[i].AppLen); //Ӧñⷢ
    		}
	  }
  		
	}
}

void NM_Init_App_Fun(unsigned char n, _AppMsgTime *msg) 
{
  if (n < 20) {
    (void)memcpy((INT8U *)&NmPara.AppMsg[n], msg, sizeof (NmPara.AppMsg[n]));  
  }
}
   
void NM_Set_App_Fun(unsigned char n, unsigned char *data, unsigned char len) 
{
  if (n < 20) {
    (void)memcpy((INT8U *)&NmPara.AppMsg[n].AppData, data, len);  
  }
}

