#ifdef        GLOBALS_NM_PROT
#define   EXTERN_NM_PROT
#else
#define   EXTERN_NM_PROT     extern
#endif

#ifndef _NM_PROTOCOL_H_
#define _NM_PROTOCOL_H_


#define NM_CAN_ID_BASE             0X18FFF000   //0x00
#define NM_CAN_ID_BOTTON           0X18FFF0FF   // 0xff
#define OWN_NODE                   0x17

#define NM_CAN_ID                   NM_CAN_ID_BASE + OWN_NODE

EXTERN_NM_PROT  volatile    _NMPDU     NM_RPDU;  //receive PDU buf
EXTERN_NM_PROT  volatile    _NMPDU     NM_SPDU;  //send PDU buf

#define ENABLE 1
#define DISABLE0 0

#define NM_LOCK 0
#define NM_UNLOCK 1

#define ALIVE_MSG 0x01
#define RING_MSG 0x02
#define LIMP_HOME_MSG 0x04 //

#define NMBusSleep 253
#define NMAwake 254

#define BusInit 1
#define BusSleep 0

#define NM_YES 1
#define NM_NO 0

#define NM_Stabilize 1
#define NM_Unstabitily 0

#define NM_IGN_ON 1
#define NM_IGN_OFF 0

#define NM_Passive 0
#define NM_Active 1

#define NM_NODE_SKIP 1
#define NM_NODE_NOT_SKIP 0

#define NM_LocalWakeup 1
#define NM_RemoteWakeup 2
#define NM_WaitWakeup 0

#define SilentNM() NmPara.NmNetWorkStatus.NMactive = NM_Passive
#define TalkNM() NmPara.NmNetWorkStatus.NMactive = NM_Active

#define SilentAPP() NmPara.NmNetWorkStatus.APPactive = NM_Passive
#define TalkAPP() NmPara.NmNetWorkStatus.APPactive = NM_Active


extern void NM_ReceiveMsg_handle(void);
extern unsigned char NM_CheckSkip(unsigned char Source, unsigned char Destination, unsigned char Own_Node);
extern void NM_ConfigLogicalFun(unsigned char SourceID);
       
extern void OsekNM_Manage_Main(void);
extern void GotoMode(unsigned char Mode);
extern void StartNM(void);
extern void NM_Do_Nothing(void);
            
extern void NMInitReset(void);
extern void NMReset(void);
            
extern void NMReset_main(void);
extern void NMReset_tx(void);
extern void NMReset_rx(void);
extern void NMReset_error(void);
            
extern void NMNormal_main(void);
extern void NMNormal_rx(void);
extern void NMNormal_tx(void);
extern void NMNormal_error(void);
            
extern void NMNormalPrepSleep_main(void);
extern void NMNormalPrep_rx(void);
extern void NMNormalPrep_tx(void);
extern void NMNormalPrep_error(void);
            
extern void NMLimpHome_main(void);
extern void NMLimpHome_rx(void);
extern void NMLimpHome_tx(void);
extern void NMLimpHome_error(void);
            
extern void NMLimpHomePrepSleep_main(void);
extern void NMLimpHomePrepSleep_rx(void);
            
extern void NMTwbsNormal_main(void);
extern void NMTwbsNormal_rx(void);
            
extern void NMTwbsLimpHome_main(void);
extern void NMTwbsLimpHome_rx(void);
            
extern void NMBusSleep_main(void);
            
extern void NM_State_Transformation(void (*pProgram)(void));
            
extern void Transmit_NMPDU(unsigned char PDU_Type);

//follows NM2.53 standard require

       
extern void CancelAlarm(unsigned int timetype); //Cansel Ttyp /Tmax /Terror count
       
extern void NM_SetTmaxTimer(unsigned int Second, _NM_TimeInfo *T);
extern unsigned char NM_TmaxTimerOver(_NM_TimeInfo *T);
       
extern void NM_SetTSendTimer(unsigned int Second, _NM_TimeInfo *T);
extern unsigned char NM_TSendTimerOver(_NM_TimeInfo *T);
       
extern void NM_SetTwbsTimer(unsigned int Second, _NM_TimeInfo *T);
extern unsigned char NM_TwbsTimerOver(_NM_TimeInfo *T);
       
extern void NM_SetSleepTimer(unsigned int Second, _NM_TimeInfo *T);
extern unsigned char NM_SleepTimerOver(_NM_TimeInfo *T);

#endif
