#include "defines.h"

AppLayerParameter AppLayer;
INT16U RANDOM_TIME;
INT32U RAND_D32;
INT8U CurApp = 0;	//0:bootloader  1:application

//#############################################################################
//    诊断协议的会话层(ISO15765-3)     相关程序
//#############################################################################

//========================================================
//++++++++++++20MS++++++++++++++++
//
//s3_server定时程序
//========================================================
void SessionTimeoutCnt_PRG(void)
{
    if (AppLayer.SessionStatus && AppLayer.SessionTimeoutSw)  	//服务器处于扩展诊断会话模式,同时定时器开?,YES
    {
        AppLayer.SessionTimeoutCnt++;
        if (AppLayer.SessionTimeoutCnt >= 250)   	//5s?,yes
        {
            AppLayer.SessionTimeoutCnt = 0;
            AppLayer.SessionStatus = SESSION_DEFAULT;			//置为默认会话状态
            AppLayer.SessionTimeoutSw = 0;        //关闭S3定时器
            AppLayer.SecurityStatus = 0;		//置为普通模式
            AppLayer.CalKey_Status = 0;
            //--------------------
            //仪表与诊断仪断开连接后,恢复仪表对指示灯,电机,LCD等的控制权
        }
    }
}

//====================================
//服务 0x10 的肯定应答       2014-12-16
//====================================
void SERVER_10H_Presponse(void)
{
    NetLayer.RxTx_Len = 6;
    NetLayer.RxTx_Buff[0] = 0x50;
    NetLayer.RxTx_Buff[2] = 0x00;  //P2CAN_Server_max High byte
    NetLayer.RxTx_Buff[3] = 50;    //P2CAN_Server_max Low byte         //50*1MS=50MS
    NetLayer.RxTx_Buff[4] = 0x00;  //P2*CAN_Server_max High byte
    NetLayer.RxTx_Buff[5] = 200;   //P2*CAN_Server_max Low byte        //200*10MS=2000MS
    NetLayer_Tx_Prg();		//网络层发送程序
}

//====================================
//通用的服务否定应答           2014-12-16
//====================================
void SERVER_ALL_Nresponse(INT8U code)
{
    NetLayer.RxTx_Len = 3;
    NetLayer.RxTx_Buff[1] = NetLayer.RxTx_Buff[0];
    NetLayer.RxTx_Buff[0] = 0x7F;
    NetLayer.RxTx_Buff[2] = code;
    NetLayer_Tx_Prg();		//网络层发送程序
}

//====================================
//2EH命令的肯定应答
//====================================
void Comm2EH_Prespons_PRG(void)
{
    NetLayer.RxTx_Len = 3;
    NetLayer.RxTx_Buff[0] = 0x6E;
    NetLayer_Tx_Prg();		//网络层发送程序
}

INT16U calcKey(INT16U seed)
{
#define 	TOPBIT 				0x8000
#define 	POLYNOM_1 			0x8408
#define 	POLYNOM_2 			0x8025
#define 	BITMASK 			0x0080
#define 	INITIAL_REMINDER 	0xFFFE
#define 	MSG_LEN 			2 		/* seed length in bytes */
    INT8U 	bSeed[2];
    INT16U 	remainder;
    INT8U 	n;
    INT8U 	i;

    bSeed[0] = (INT8U)(seed >> 8); 	/* MSB */
    bSeed[1] = (INT8U)seed; 			/* LSB */
    remainder = INITIAL_REMINDER;
    for (n = 0; n < MSG_LEN; n++)
    {
        /* Bring the next byte into the remainder. */
        remainder ^= ((bSeed[n]) << 8);
        /* Perform modulo-2 division, a bit at a time. */
        for (i = 0; i < 8; i++)
        {
            /* Try to divide the current data bit. */
            if (remainder & TOPBIT)
            {
                if(remainder & BITMASK)
                {
                    remainder = (remainder << 1) ^ POLYNOM_1;
                }
                else
                {
                    remainder = (remainder << 1) ^ POLYNOM_2;
                }
            }
            else
            {
                remainder = (remainder << 1);
            }
        }
    }
    /* The final remainder is the key */
    return remainder;
}
//============================================
//根据种子生成KEY       奇瑞         2016-4-25
//============================================
void GJ_SEED_MODE_QR_KEY(INT8U *pSEED)
{
    INT16U seed;

    seed = (((INT16U)pSEED[0]) << 8) | ((INT16U)pSEED[1]);
    AppLayer.Security16_KEY = calcKey(seed);
    AppLayer.CalKey_Status = 1;
}

//=========================================================
//应用层接收服务程序
//=========================================================
void AppLayer_Rx_PRG(void)
{
    INT8U i;
    INT8U m8;
    INT8U *p8;
    INT16U m16;
    INT32U m32;

    if (NetLayer.RecvMulFrame_First == VALID)  			//=1网络层通知应用层它收到了多帧数据中的首帧
    {
        NetLayer.RecvMulFrame_First = 0;
        AppLayer.SessionTimeoutSw = 0;        //关闭S3定时器
        return;
    }

    if (NetLayer.SendDataStatus == VALID)  		//=1网络层通知应用层它发出了完整的一帧数据(单帧或多帧)
    {
        NetLayer.SendDataStatus = 0;
        AppLayer.SessionTimeoutSw = 1;        //开S3定时器
        AppLayer.SessionTimeoutCnt = 0;
        return;
    }

    if (NetLayer.RecvDataStatus != VALID)  		//=1网络层通知应用层它收到了一帧错误数据
    {
        NetLayer.RecvDataStatus = 0;
        AppLayer.SessionTimeoutSw = 1;        //开S3定时器
        return;
    }

    //NetLayer.RecvDataStatus == INVALID 表示一帧或多帧数据接收完成
    NetLayer.RecvDataStatus = 0;
    AppLayer.SessionTimeoutSw = 0;        //关闭S3定时器
    //处理客户机请求
    switch (NetLayer.RxTx_Buff[0])
    {
    case GetStatus:
        NetLayer.RxTx_Len = 5;
        NetLayer.RxTx_Buff[0] = 0x62;
        for (i = 0; i < 16; i++)
            NetLayer.RxTx_Buff[3 + i] = 0x20;
        switch (NetLayer.RxTx_Buff[1])
        {
        case GetStatus_SessionStatus:
            NetLayer.RxTx_Buff[2] = NetLayer.RxTx_Buff[1];
            NetLayer.RxTx_Buff[1] = 0xaa;
            NetLayer.RxTx_Buff[3] = AppLayer.SessionStatus;
            break;
        case GetStatus_SecurityStatus:
            NetLayer.RxTx_Buff[2] = NetLayer.RxTx_Buff[1];
            NetLayer.RxTx_Buff[1] = 0xaa;
            NetLayer.RxTx_Buff[3] = AppLayer.SecurityStatus;
            break;
        case GetStatus_KeyStatus:
            NetLayer.RxTx_Buff[2] = NetLayer.RxTx_Buff[1];
            NetLayer.RxTx_Buff[1] = 0xaa;
            NetLayer.RxTx_Buff[3] = AppLayer.CalKey_Status;
            break;
        case GetResetAddr:
        {
            INT16U addr;
            addr = GetResetAddr_Word();
            NetLayer.RxTx_Buff[2] = NetLayer.RxTx_Buff[1];
            NetLayer.RxTx_Buff[1] = 0xaa;
            NetLayer.RxTx_Buff[3] = CurApp;
        }
        break;
        }
        NetLayer_Tx_Prg();		//网络层发送程序
        break;
    case DiagnosticSessionControl:
        if (NetLayer.RxTx_Len != 2)
        {
            SERVER_ALL_Nresponse(0x13);		//通用的服务否定应答
            break;
        }

        if ((NetLayer.RxTx_Buff[1] == 0x01) || (NetLayer.RxTx_Buff[1] == 0x81))
        {
            AppLayer.SessionStatus = SESSION_DEFAULT;			//置为默认会话状态
            AppLayer.SecurityStatus = SECURITY_LOCK;		//置为普通模式
            AppLayer.CalKey_Status = CAL_KEY_INVALID;
            if (NetLayer.RxTx_Buff[1] == 0x01)
                SERVER_10H_Presponse();		//服务 0x10 的肯定应答
            break;
        }

        if ((NetLayer.RxTx_Buff[1] == 0x02) || (NetLayer.RxTx_Buff[1] == 0x82))      //编程模式
        {
            AppLayer.SessionStatus = SESSION_PROGRAMMING;		    //=2为编程会话状态
            if (NetLayer.RxTx_Buff[1] == 0x02)
                SERVER_10H_Presponse();		//服务 0x10 的肯定应答
            break;
        }

        if ((NetLayer.RxTx_Buff[1] == 0x03) || (NetLayer.RxTx_Buff[1] == 0x83))
        {
            AppLayer.SessionStatus = SESSION_EXTENDED_DIAGNOSTIC;				//=1为非默认会话状态(扩展诊断会话)
            if (NetLayer.RxTx_Buff[1] == 0x03)
                SERVER_10H_Presponse();		//服务 0x10 的肯定应答
            break;
        }
        SERVER_ALL_Nresponse(0x12);		//通用的服务否定应答
        break;
    case ECU_Reset:
        if (AppLayer.SessionStatus == SESSION_DEFAULT)            //默认会话?,YES
        {
            SERVER_ALL_Nresponse(0x7F);		//通用的服务否定应答
            break;
        }

        if (NetLayer.RxTx_Len != 2)
        {
            SERVER_ALL_Nresponse(0x13);		//通用的服务否定应答
            break;
        }

        if ((NetLayer.RxTx_Buff[1] == 0x01) || (NetLayer.RxTx_Buff[1] == 0x03) || (NetLayer.RxTx_Buff[1] == 0x81) || (NetLayer.RxTx_Buff[1] == 0x83))
        {
            if ((NetLayer.RxTx_Buff[1] == 0x81) || (NetLayer.RxTx_Buff[1] == 0x83))
            {
                //WRITE_BZ_inDFLAH2Sector(0xA77A);
                while (1);     				//看门狗复位
                break;
            }

            //WRITE_BZ_inDFLAH2Sector(0xA77A);
            NetLayer.RxTx_Len = 2;
            NetLayer.RxTx_Buff[0] = 0x51;
            NetLayer_Tx_Prg();		//网络层发送程序
            while (1);   				//看门狗复位
        }
        SERVER_ALL_Nresponse(0x12);		//通用的服务否定应答
        break;
    case Control_DTC_Setting:
        if (NetLayer.RxTx_Len != 2)
        {
            SERVER_ALL_Nresponse(0x13);		//通用的服务否定应答
            break;
        }

        if ((NetLayer.RxTx_Buff[1] == 0x01) || (NetLayer.RxTx_Buff[1] == 0x02))
        {
            NetLayer.RxTx_Len = 2;
            NetLayer.RxTx_Buff[0] = 0xC5;
            NetLayer_Tx_Prg();		//网络层发送程序
            break;
        }
        SERVER_ALL_Nresponse(0x12);		//通用的服务否定应答
        break;
    case CommunicationControl:
        if (NetLayer.RxTx_Len != 3)
        {
            //IncorrectMessageLength
            SERVER_ALL_Nresponse(0x13);		//通用的服务否定应答
            break;
        }

        if ((NetLayer.RxTx_Buff[1] == 0x00) || (NetLayer.RxTx_Buff[1] == 0x03))
        {
            NetLayer.RxTx_Len = 2;
            NetLayer.RxTx_Buff[0] = 0x68;
            NetLayer_Tx_Prg();		//网络层发送程序
            break;
        }
        //给否定的应答
        SERVER_ALL_Nresponse(0x12);		//通用的服务否定应答
        break;
    case RoutineControl:
        if (AppLayer.SessionStatus == SESSION_DEFAULT)
        {
            SERVER_ALL_Nresponse(0x33);		//通用的服务否定应答
            break;
        }

        m16 = (((INT16U)NetLayer.RxTx_Buff[2]) << 8) | ((INT16U)NetLayer.RxTx_Buff[3]);
        switch (m16)
        {
        case 0xFF00:
            NetLayer.RxTx_Len = 5;
            NetLayer.RxTx_Buff[0] = 0x71;
            NetLayer.RxTx_Buff[4] = 0x04;
            NetLayer_Tx_Prg();		//网络层发送程序
            break;
        case 0xFF01:	//Check Programming Dependencies
            NetLayer.RxTx_Len = 5;
            NetLayer.RxTx_Buff[0] = 0x71;
            NetLayer.RxTx_Buff[4] = 0x04;
            NetLayer_Tx_Prg();		//网络层发送程序
            WRITE_BZ_inDFLAH2Sector(0xA77A);                //应用程序有效
            break;
        case 0xFF02:	//Check Programming Dependencies
            NetLayer.RxTx_Len = 5;
            NetLayer.RxTx_Buff[0] = 0x71;
            NetLayer.RxTx_Buff[4] = 0x04;
            NetLayer_Tx_Prg();		//网络层发送程序
            WRITE_BZ_inDFLAH2Sector(0xFFFF);                //应用程序失效
            break;
        case 0x0202:	//CheckMemory
            AppLayer.RoutineStatus++;
            if(AppLayer.RoutineStatus == 1)  //校验flashdriver 程序
            {
                ;
            }

            if(AppLayer.RoutineStatus == 2)  //校验APP程序
            {
                ;
            }

            NetLayer.RxTx_Len = 5;
            NetLayer.RxTx_Buff[0] = 0x71;
            NetLayer.RxTx_Buff[4] = 0x04;
            NetLayer_Tx_Prg();		//网络层发送程序
            break;
        default:		//其它DID
            SERVER_ALL_Nresponse(0x31);		//通用的服务否定应答
        }
        break;
    case RequestDownload:
        if (AppLayer.SessionStatus != SESSION_PROGRAMMING)                     //=2为编程会话状态
        {
            //Service not supported in active session
            SERVER_ALL_Nresponse(0x7F);		//通用的服务否定应答
            break;
        }

        if (AppLayer.SecurityStatus == SECURITY_LOCK)
        {
            //securityAccessDenied
            SERVER_ALL_Nresponse(0x33);		//通用的服务否定应答
            break;
        }

        if (NetLayer.RxTx_Buff[1] || (NetLayer.RxTx_Buff[2] != 0x44) || (NetLayer.RxTx_Len != 11))
        {
            //Incorrect message length or invalid format
            SERVER_ALL_Nresponse(0x13);		//通用的服务否定应答
            break;
        }

        if (AppLayer.RoutineStatus == ROUTINE_DOWNLOAD_FLASH)
        {
            //=0表示 Download FlashDriver
            AppLayer.RecvDataCnt = 1;
        }
        else
        {
            //表示 Download program data
            AppLayer.RecvDataCnt = 1;
            AppLayer.RecvDataLen = 0;
            p8 = (INT8U *)&m32;
            p8[0] = NetLayer.RxTx_Buff[3];
            p8[1] = NetLayer.RxTx_Buff[4];
            p8[2] = NetLayer.RxTx_Buff[5];
            p8[3] = NetLayer.RxTx_Buff[6];
            srcd.Gaddr = Local2Global(m32);

            p8[0] = NetLayer.RxTx_Buff[7];
            p8[1] = NetLayer.RxTx_Buff[8];
            p8[2] = NetLayer.RxTx_Buff[9];
            p8[3] = NetLayer.RxTx_Buff[10];
            srcd.dtlen = m32;
        }

        NetLayer.RxTx_Len = 4;
        NetLayer.RxTx_Buff[0] = 0x74;
        NetLayer.RxTx_Buff[1] = 0x20;
        NetLayer.RxTx_Buff[2] = 0x00;        //
        NetLayer.RxTx_Buff[3] = 224 + 2;       //224个字节    64个字节       2015-7-17
        NetLayer_Tx_Prg();		//网络层发送程序
        break;
    case TransferData:
        if (AppLayer.SessionStatus != SESSION_PROGRAMMING)                    //=2为编程会话状态
        {
            //Service not supported in active session
            SERVER_ALL_Nresponse(0x7F);		//通用的服务否定应答
            break;
        }

        if (AppLayer.SecurityStatus == SECURITY_LOCK)
        {
            //securityAccessDenied
            SERVER_ALL_Nresponse(0x33);		//通用的服务否定应答
            break;
        }

        /*if (NetLayer.RxTx_Buff[1] != AppLayer.RecvDataCnt) {
        	//requestSequenceError
        	SERVER_ALL_Nresponse(0x24);		//通用的服务否定应答
        	break;
        }

        m81 = AppLayer.RecvDataCnt;
        AppLayer.RecvDataCnt++;  */
        if (AppLayer.RoutineStatus == ROUTINE_DOWNLOAD_FLASH)
        {
            //=0表示 Download FlashDriver
            NetLayer.RxTx_Len = 2;
            NetLayer.RxTx_Buff[0] = 0x76;
            NetLayer_Tx_Prg();		//网络层发送程序
        }
        else
        {
            //表示 program data
            //Download
            if ((NetLayer.RxTx_Len - 2) > 224)     //srcd.dtlen
            {
                //requestOutOfRange
                SERVER_ALL_Nresponse(0x31);		//通用的服务否定应答
                T2MS_FF = 1;
                break;
            }

            memcpy(&srcd.data[8], &NetLayer.RxTx_Buff[1], (NetLayer.RxTx_Len - 1));
            AppLayer.RecvDataLen = (NetLayer.RxTx_Len - 1);      //收到的数据长度
            //--------------------------------------------------
            //开始擦除
            //用于重新延长应答时间到5S

            //用于地址对齐，写flash的地址需要对齐4字节
            m8 = srcd.Gaddr & 0x7;
            if (m8)
            {
                p8 = &srcd.data[8 - m8];
                AppLayer.RecvDataLen += m8;
                srcd.Gaddr = srcd.Gaddr - m8;
                memset(p8, 0xff, m8);
            }
            else
            {
                p8 = &srcd.data[8];
            }

            //-----------------------------------
            if ((srcd.Gaddr + AppLayer.RecvDataLen - 1) >= Local2Global(0xFC00) && (srcd.Gaddr + AppLayer.RecvDataLen - 1) <= Local2Global(0xFFFF))
            {
                //要擦除的区域为BOOTLOAD区
                SERVER_ALL_Nresponse(0x72);		//通用的服务否定应答
                T2MS_FF = 1;
                break;
            }

            if (!((srcd.Gaddr > Local2Global(0xFCBFFF)) || ((srcd.Gaddr + AppLayer.RecvDataLen - 1) < Local2Global(0xFCA000))))
            {
                //要擦除的区域为BOOTLOAD区
                SERVER_ALL_Nresponse(0x72);		//通用的服务否定应答
                T2MS_FF = 1;
                break;
            }

            //------------------------------------------
            //MAKER_TEST
            m8 = GET_Global_sector_PRG(srcd.Gaddr);   //判断全局地址在哪个SECTOr
            if (EraseMemoryFF[m8] == 0)       //本sector已经被擦除?,NO
            {
                ////SERVER_ALL_Nresponse(0x78);		//通用的服务否定应答
                NetLayer.RxTx_Buff[0] = 0x36;
                if (D_P_FLASH_Erase_Sector(1, srcd.Gaddr) == OK)
                {
                    EraseMemoryFF[m8] = 1;
                }
                else
                {
                    //擦除失败
                    //generalProgrammingFailure
                    SERVER_ALL_Nresponse(0x72);		//通用的服务否定应答
                    nop();
                    break;
                }
            }

            m8 = GET_Global_sector_PRG(srcd.Gaddr + AppLayer.RecvDataLen - 1);  //判断全局地址在哪个SECTOR
            if (EraseMemoryFF[m8] == 0)        //本sector已经被擦除?,NO
            {
                ////SERVER_ALL_Nresponse(0x78);		//通用的服务否定应答
                NetLayer.RxTx_Buff[0] = 0x36;
                if (D_P_FLASH_Erase_Sector(1, srcd.Gaddr + AppLayer.RecvDataLen - 1) == OK)
                {
                    EraseMemoryFF[m8] = 1;
                }
                else
                {
                    //擦除失败
                    //generalProgrammingFailure
                    SERVER_ALL_Nresponse(0x72);		//通用的服务否定应答
                    nop();
                    break;
                }
            }

            //---------------------------
            //开始编程
            ////SERVER_ALL_Nresponse(0x78);		//通用的服务否定应答
            NetLayer.RxTx_Buff[0] = 0x36;

            //if( PP_FLASH_N_Program(srcd.Gaddr,&srcd.data[0],REC_DLlen)!=OK  )
            if (PP_FLASH_N_Program(srcd.Gaddr, p8, AppLayer.RecvDataLen) != OK)
            {
                //编程失败
                //generalProgrammingFailure
                SERVER_ALL_Nresponse(0x72);		//通用的服务否定应答
                nop();
                break;
            }
            //编程成功
            //srcd.Gaddr = srcd.Gaddr + AppLayer.RecvDataLen;
            //--------------------------------------------------
            NetLayer.RxTx_Len = 2;
            NetLayer.RxTx_Buff[0] = 0x76;
            NetLayer.RxTx_Buff[1] = m8;         //保持不变
            NetLayer_Tx_Prg();		//网络层发送程序
        }
        break;
    case TransferExit:
        if (AppLayer.SessionStatus != SESSION_PROGRAMMING)                    //=2为编程会话状态
        {
            //Service not supported in active session
            SERVER_ALL_Nresponse(0x7F);		//通用的服务否定应答
            break;
        }

        if (AppLayer.SecurityStatus == SECURITY_LOCK)
        {
            //securityAccessDenied
            SERVER_ALL_Nresponse(0x33);		//通用的服务否定应答
            break;
        }

        //NetLayer.RxTx_Len=3;
        NetLayer.RxTx_Buff[0] = 0x77;
        NetLayer_Tx_Prg();		//网络层发送程序
        break;
    case ReadDataByIdentifier:  //ReadDataByIdentifier
        m16 = (((INT16U)NetLayer.RxTx_Buff[1]) << 8) | ((INT16U)NetLayer.RxTx_Buff[2]);
        switch (m16)
        {
        case 0xF18B:	//读生产日期
            NetLayer.RxTx_Len = 3 + 4;
            NetLayer.RxTx_Buff[0] = 0x62;
            NetLayer.RxTx_Buff[3] = 0x20;
            NetLayer.RxTx_Buff[4] = 0x15;
            NetLayer.RxTx_Buff[5] = 0x04;
            NetLayer.RxTx_Buff[6] = 0x10;
            NetLayer_Tx_Prg();		//网络层发送程序
            break;
        case 0xF192:	//读 Supplier EUC HW NUMBER
            NetLayer.RxTx_Len = 3 + 16;
            NetLayer.RxTx_Buff[0] = 0x62;
            for (i = 0; i < 16; i++)
                NetLayer.RxTx_Buff[3 + i] = 0x20;
            //12XHY128
            NetLayer.RxTx_Buff[3] = 0x31;
            NetLayer.RxTx_Buff[4] = 0x32;
            NetLayer.RxTx_Buff[5] = 0x58;
            NetLayer.RxTx_Buff[6] = 0x48;
            NetLayer.RxTx_Buff[7] = 0x59;
            NetLayer.RxTx_Buff[8] = 0x31;
            NetLayer.RxTx_Buff[9] = 0x32;
            NetLayer.RxTx_Buff[10] = 0x38;
            NetLayer_Tx_Prg();		//网络层发送程序
            break;
        case 0xF193:	//读硬件版本
            NetLayer.RxTx_Len = 3 + 16;
            NetLayer.RxTx_Buff[0] = 0x62;
            for (i = 0; i < 16; i++)
                NetLayer.RxTx_Buff[3 + i] = 0x20;
            NetLayer.RxTx_Buff[3] = 0x31;
            NetLayer.RxTx_Buff[4] = 0x35;
            NetLayer.RxTx_Buff[5] = 0x30;
            NetLayer.RxTx_Buff[6] = 0x33;
            NetLayer.RxTx_Buff[7] = 0x33;
            NetLayer.RxTx_Buff[8] = 0x30;
            NetLayer_Tx_Prg();		//网络层发送程序
            break;
        case 0xF180:	//bootSoftware Identification DataIdentifier
            NetLayer.RxTx_Len = 3 + 16;
            NetLayer.RxTx_Buff[0] = 0x62;
            for (i = 0; i < 16; i++)
                NetLayer.RxTx_Buff[3 + i] = 0x20;
            NetLayer.RxTx_Buff[3] = 0x35;
            NetLayer.RxTx_Buff[4] = 0x37;
            NetLayer.RxTx_Buff[5] = 0x38;
            NetLayer.RxTx_Buff[6] = 0x39;
            NetLayer_Tx_Prg();		//网络层发送程序
            break;
        default:		//其它DID
            SERVER_ALL_Nresponse(0x31);		//通用的服务否定应答
        }
        break;
    case TesterPresent:  //TesterPresent
        if (NetLayer.RxTx_Len != 2)
        {
            //IncorrectMessageLength
            SERVER_ALL_Nresponse(0x13);		//通用的服务否定应答
            break;
        }

        if (NetLayer.RxTx_Buff[1] == 0x00)
        {
            NetLayer.RxTx_Len = 2;
            NetLayer.RxTx_Buff[0] = 0x7E;
            NetLayer.RxTx_Buff[1] = 0x00;
            NetLayer_Tx_Prg();		//网络层发送程序
            break;
        }

        if (NetLayer.RxTx_Buff[1] == 0x80)
        {
            break;
        }
        SERVER_ALL_Nresponse(0x12);		//通用的服务否定应答
        break;
    case SecurityAccess:
        if (AppLayer.SessionStatus != SESSION_PROGRAMMING)                    //=2为编程会话状态
        {
            //Service not supported in active session
            SERVER_ALL_Nresponse(0x7F);		//通用的服务否定应答
            break;
        }

        if (NetLayer.RxTx_Buff[1] == 0x01)
        {
            if (AppLayer.SessionStatus != SESSION_DEFAULT)  			//=1为非默认会话状态(扩展诊断会话)
            {
                //随机生成32位数
                RANDOM_TIME = (INT16U)RAND_D32;
                i = (INT8U)(RANDOM_TIME >> 8);
                m8 = (INT8U)(RANDOM_TIME & 0x00FF);
                //发送种子回应
                NetLayer.RxTx_Len = 4;
                NetLayer.RxTx_Buff[0] = 0x67;
                //NetLayer.RxTx_Buff[1] = 0x11;          //01
                NetLayer.RxTx_Buff[2] = 0x78 + ~i; 		//S1
                NetLayer.RxTx_Buff[3] = 0x56 + ~m8;		//S2
                //NetLayer.RxTx_Buff[4]=0x23+i;      	//S3
                //NetLayer.RxTx_Buff[5]=0x14+m8;      	//S4
                GJ_SEED_MODE_QR_KEY(&NetLayer.RxTx_Buff[2]);
                NetLayer_Tx_Prg();		//网络层发送程序
            }
            else
            {
                //当前不在扩展模式
                SERVER_ALL_Nresponse(0x7F);		//通用的服务否定应答
            }
            break;
        }
        if (NetLayer.RxTx_Buff[1] == 0x02)
        {
            m16 = (((INT16U)NetLayer.RxTx_Buff[2]) << 8) | ((INT16U)NetLayer.RxTx_Buff[3]);
            if (AppLayer.CalKey_Status && (m16 == AppLayer.Security16_KEY))
            {
                //密码正确
                NetLayer.RxTx_Len = 2;
                NetLayer.RxTx_Buff[0] = 0x67;
                //NetLayer.RxTx_Buff[1] = 0x12;
                NetLayer_Tx_Prg();		//网络层发送程序
                AppLayer.SecurityStatus = SECURITY_UNLOCK;			//=1为安全模式
                memset(EraseMemoryFF, 0, sizeof(EraseMemoryFF));
                AppLayer.RoutineStatus = 0;
            }
            else
            {
                SERVER_ALL_Nresponse(0x35);
            }
            break;
        }
        SERVER_ALL_Nresponse(0x13);		//通用的服务否定应答
        break;
    case WriteDataByIdentifier:	//WriteDataByIdentifier
        if (AppLayer.SecurityStatus == SECURITY_LOCK)
        {
            SERVER_ALL_Nresponse(0x33);		//通用的服务否定应答
            break;
        }

        m16 = (((INT16U)NetLayer.RxTx_Buff[1]) << 8) | ((INT16U)NetLayer.RxTx_Buff[2]);
        switch (m16)
        {
        case 0xF198:	//
            Comm2EH_Prespons_PRG();	//2EH命令的肯定应答
            break;
        case 0xF199:	//
            Comm2EH_Prespons_PRG();	//2EH命令的肯定应答
            break;
        default:		//其它DID
            SERVER_ALL_Nresponse(0x31);		//通用的服务否定应答
        }
        break;
    case InputOutPutControlByIdentifier:  //InputOutputControlByIdentifier
        if (AppLayer.SecurityStatus == SECURITY_LOCK)
        {
            SERVER_ALL_Nresponse(0x33);		//通用的服务否定应答
            break;
        }

        SERVER_ALL_Nresponse(0x31);		//通用的服务否定应答
        break;
    }
}