/*
* api_ADC.c
*
*  Created on: Aug 8, 2014
*      Author: QTC
*/

#define GLOBALS_API_ADC
#include "defines.h"
#include "g_includes.h"

//-- Դ --//
//ĹѹΧΪ16Vѹ36V
//
//3)10Vѹ16Vʱ,͵ѹģʽ----18v˳
//4)ѹ10VʱǱرա
//
// ѹ36VС40Vʱ----34v˳
// ѹ40VʱǱرա
//

//-- ѹ--AD --//
// 10V--255  ر
// 16V--410  ͵ѹģʽ
// 18V--459  ˳
// 34V--867  ˳
// 36V--919  ߵѹģʽ
// 40V--1003 ر
/*-------------------------------------------------------------------------
* Function Name  : Api_GetAdcResult                                     24v
* Description    : GetAdcRe                                        33k-4.7k
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/

void Api_GetAdcResult(void)
{
    INT8U AD_STATUS;
    INT32U wTemp = 0;
    INT8U i = 0;

    AD_STATUS = ATDSTAT0;

    if ((AD_STATUS & 0x80) == 0x80)
    {
        switch (ATDCTL5_Cx)
        {
        //-- KL15 --//
        case CHNAL9:
            if (g_adcResult.pBat > ADEveLen - 1)
            {
                g_adcResult.pBat = null;
            }
            g_adcResult.AdcValue = ATDDR0;
            g_adcResult.BatLevel[g_adcResult.pBat] = g_adcResult.AdcValue;
            g_adcResult.pBat++;
            App_SortNByte((INT16U *)g_adcResult.BatLevel, ADEveLen);

            // 7v--16v
            if ((g_adcResult.AdcValue >= V_7v) && (g_adcResult.AdcValue <= V_16v)) //2020-10-08 ѹ8V7V(Ĺ)
            {
                Api_SetFilterTimer(T1_300ms, (_Clock *)&g_Clock);
                //˳ѹģʽ 8v
                if (g_curkeyinput == KeyLow)
                {
                    if (g_adcResult.AdcValue >= V_8v) //2020-10-08ĵѹ(Ĺ)
                    {
                        g_curkeyinput = KeyON;
                        T20MS_FF = 0;
                        g_Init.InitBeepTime = 0;
                        Enable_signal(g_sysFlag.Bits.SysOffEn);
                    }
                }
                //˳ѹģʽ 15.5v
                else if (g_curkeyinput == KeyHi)
                {
                    if (g_adcResult.AdcValue <= V_15_5v)
                    {
                        g_curkeyinput = KeyON;
                        T20MS_FF = 0;
                        g_Init.InitBeepTime = 0;
                        Enable_signal(g_sysFlag.Bits.SysOffEn);
                    }
                }
                else if (g_curkeyinput == KeyOFF)
                {

                    g_curkeyinput = KeyON;
                    T20MS_FF = 0;
                    g_Init.InitBeepTime = 0;
                    Enable_signal(g_sysFlag.Bits.SysOffEn);
                }
            }
            //ѹģʽ 6v--7v
            else if (g_Clock.KeyLowFilterTime >= T_2_0s)
            {
                Api_SetFilterTimer(T1_300ms, (_Clock *)&g_Clock);
                g_curkeyinput = KeyLow;
                g_Lastkeyinput = KeyLow;
            }
            //ѹģʽ 16v--18v
            else if (g_Clock.KeyHiFilterTime >= T_0_5s)
            {
                Api_SetFilterTimer(T1_300ms, (_Clock *)&g_Clock);
                g_curkeyinput = KeyHi;
                g_Lastkeyinput = KeyHi;
            }
            //
            else if ((g_adcResult.AdcValue <= V_6v) || (g_adcResult.AdcValue >= V_18v))
            {
                if (Api_FilterTimerOver((_Clock *)&g_Clock))
                {
                    g_curkeyinput = KeyOFF;
                }
            }

            //-- no use --//
            if (g_sysFlag.Bits.CanState == CanOFF)
            {
                if (g_adcResult.AdcValue >= V_7v) //2020-10-08 ѹ8V7V(Ĺ)
                {
                    if (g_adcResult.CanOnCn < 10)
                    {
                        g_adcResult.CanOnCn++;
                    }
                    if (g_adcResult.CanOnCn >= 1)
                    {
                        g_sysFlag.Bits.CanState = CanON;
                    }
                }
            }

            if (g_sysFlag.Bits.CanState == CanON)
            {
                if (g_adcResult.AdcValue < V_6v)
                {
                    if (g_adcResult.CanOnCn)
                    {
                        g_adcResult.CanOnCn--;
                    }
                    if (g_adcResult.CanOnCn == 0)
                    {
                        g_sysFlag.Bits.CanState = CanOFF;
                    }
                }
            }
            ATDCTL5_Cx = CHNAL10;
            break;

        //-- KL30 --//
        case CHNAL10:
            if (g_curkeyinput == KeyON)
            {
                g_adcResult.K30Value[g_adcResult.pK30] = ATDDR0;
                if (g_adcResult.pK30 >= ADEveLen - 1)
                {
                    g_adcResult.pK30 = null;
                }
                else
                {
                    g_adcResult.pK30++;
                }
                if (g_adcResult.pK30 % 2 == null)
                {
                    ATDCTL5_Cx = CHNAL7;
                }
                else
                {
                    ATDCTL5_Cx = CHNAL7;
                }
                App_SortNByte((INT16U *)g_adcResult.K30Value, ADEveLen);
            }
            else
            {
                w2 = ATDDR0;
                ATDCTL5_Cx = CHNAL7;
            }
            break;

            //-- ȴҺ --//
            /*
            case CHNAL6:
                if(g_curkeyinput == KeyON)
                {
                    g_adcResult.CoolLiquidEven[g_adcResult.pCoolLiquid] = ATDDR0;
                    if(g_adcResult.pCoolLiquid >= ADEveLen - 1)
                    {
                        g_adcResult.pCoolLiquid = null;
                    }
                    else
                    {
                        g_adcResult.pCoolLiquid++;
                    }
                    if(g_adcResult.pCoolLiquid % 2 == null)
                    {
                        ATDCTL5_Cx = CHNAL11;
                    }
                    else
                    {
                        ATDCTL5_Cx = CHNAL6;
                    }
                    App_SortNByte((INT16U *)g_adcResult.CoolLiquidEven, ADEveLen);
                }
                else
                {
                    w2 = ATDDR0;
                    ATDCTL5_Cx = CHNAL9;
                }
                break;
            */
        //----FUEL Դɼ----
        case CHNAL7:
            if (g_curkeyinput == KeyON)
            {
                g_adcResult.FuelKLValue[g_adcResult.pFuelAKLAd] = ATDDR0;
                if (g_adcResult.pFuelAKLAd >= ADEveLen - 1)
                {
                    g_adcResult.pFuelAKLAd = null;
                }
                else
                {
                    g_adcResult.pFuelAKLAd++;
                }
                if (g_adcResult.pFuelAKLAd % 2 == null)
                {
                    ATDCTL5_Cx = CHNAL6;
                }
                else
                {
                    ATDCTL5_Cx = CHNAL6;
                }
                App_SortNByte((INT16U *)g_adcResult.FuelKLValue, ADEveLen);
            }
            else
            {
                w2 = ATDDR0;
                ATDCTL5_Cx = CHNAL6;
            }
            break;
        //-- Fuel --//
        case CHNAL6:
            if (g_curkeyinput == KeyON)
            {
                g_adcResult.FuelEven[g_adcResult.pFuelAd] = ATDDR0;
                if (g_adcResult.pFuelAd >= ADEveLen - 1)
                {
                    g_adcResult.pFuelAd = null;
                }
                else
                {
                    g_adcResult.pFuelAd++;
                }
                if (g_adcResult.pFuelAd % 2 == null)
                {
                    ATDCTL5_Cx = CHNAL2;
                }
                else
                {
                    ATDCTL5_Cx = CHNAL1;
                }
                App_SortNByte((INT16U *)g_adcResult.FuelEven, ADEveLen);
            }
            else
            {
                w2 = ATDDR0;
                ATDCTL5_Cx = CHNAL9;
            }
            break;

        //-- Gas1 --//
        case CHNAL2:
            if (g_curkeyinput == KeyON)
            {
                g_adcResult.Gas1Even[g_adcResult.pGas1] = ATDDR0;
                if (g_adcResult.pGas1 >= ADEveLen - 1)
                {
                    g_adcResult.pGas1 = null;
                }
                else
                {
                    g_adcResult.pGas1++;
                }
                if (g_adcResult.pGas1 % 2 == null)
                {
                    ATDCTL5_Cx = CHNAL9;
                }
                else
                {
                    ATDCTL5_Cx = CHNAL9;
                }
                App_SortNByte((INT16U *)g_adcResult.Gas1Even, ADEveLen);
            }
            else
            {
                w2 = ATDDR0;
                ATDCTL5_Cx = CHNAL9;
            }
            break;

        //-- Gas2 --//
        case CHNAL1:
            if (g_curkeyinput == KeyON)
            {
                g_adcResult.Gas2Even[g_adcResult.pGas2] = ATDDR0;
                if (g_adcResult.pGas2 >= ADEveLen - 1)
                {
                    g_adcResult.pGas2 = null;
                }
                else
                {
                    g_adcResult.pGas2++;
                }
                if (g_adcResult.pGas2 % 2 == null)
                {
                    ATDCTL5_Cx = CHNAL9;
                }
                else
                {
                    ATDCTL5_Cx = CHNAL9;
                }
                App_SortNByte((INT16U *)g_adcResult.Gas2Even, ADEveLen);
            }
            else
            {
                w2 = ATDDR0;
                ATDCTL5_Cx = CHNAL9;
            }
            break;
        default:
            ATDCTL5_Cx = CHNAL9;
        }
        ATDSTAT0_SCF = ClearFlag;
    }
}
/*-------------------------------------------------------------------------
* Function Name  : Api_SetFilterTimer
* Description    : öʱ
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Api_SetFilterTimer(INT16U Second, _Clock *T)
{
    T->TFEnable = Enable;
    T->OverFTime = Second;
    T->FilterTime = null;
}
/*-------------------------------------------------------------------------
* Function Name  : Api_FilterTimerOver
* Description    : ʱ
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
INT8U Api_FilterTimerOver(_Clock *T)
{
    if ((T->FilterTime >= T->OverFTime) && (T->TFEnable))
    {
        T->TFEnable = Disable;
        return 1;
    }
    else
    {
        return 0;
    }
}
/*-------------------------------------------------------------------------
* Function Name  : PowerManage
* Description    : 
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void PowerManage(void)
{
    INT8U i = 0;

    if ((g_curkeyinput == KeyLow) || (g_curkeyinput == KeyHi))
    {
        if (g_sysFlag.Bits.LowModeInit)
        {
            Disable_signal(g_sysFlag.Bits.LowModeInit);
            bsp_Sys_ON();
            DB8379_Init();
        }

        //-- Lcd --//
        bsp_ClearFullWindow(null);
        g_runStep = SYS_INIT_TASK;        //лon
        g_sysFlag.Bits.SysOffEn = Enable; //лoff
        g_CanSwith.ClrScreenDoor = 1;

        //-- Beep --//
        for (i = 0; i < 21; i++)
        {
            g_Beep[i].Prio = DisAlr;
            g_Beep[i].OnTime = null;
            g_Beep[i].OffTime = null;
            g_Beep[i].BeepTime = null;
            g_Beep[i].BeepCn = null;
            g_Beep[i].BeepOK = null;
            g_Beep[i].BeepInit = null;
            g_Beep[i].CurBeepCn = null;
        }
        g_pBeep->BeepTime = null;
        Enable_signal(g_sysFlag.Bits.BeepProcEn);
        g_nopBeep.Prio = DisAlr;
        g_nopBeep.OnTime = null;
        g_nopBeep.OffTime = null;
        g_nopBeep.BeepTime = null;
        g_nopBeep.OnceFlag = null;
        g_nopBeep.BeepOK = null;
        g_nopBeep.BeepCn = null;
        g_nopBeep.CurBeepCn = null;
        g_pBeep = &g_nopBeep;

        //-- Power --//
        //pVehOut = OFF;
        //pGas5vOut = LOW;//
        //pMcu5vOut = HIGH;//
    }
}