#include "NM_includes.h"
#include "../api_Headers/api_GpioMap.h"
#include "defines.h"


void AbortAllCanTx(void)
{
  CAN0TARQ = 0x07;              //ֹбķ.
}


void SetCanSTBLevel(unsigned char n) 
{
  if (n == LOW) {
    pSTBOut = LOW;                 
  } else if (n == HIGH) {
   pSTBOut = HIGH;
  }
}

/*-------------------------------------------------------------------------
* Function Name  : NM_D_Init
* Description    : CAN Init and handle data link layer
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void NM_D_Init(unsigned char state)
{
    switch (state) {
        case BusInit:
            SetCanSTBLevel(LOW);
            bsp_CAN_Init();
            break;
        case BusSleep:
            AbortAllCanTx();
            bsp_tx_msgbuf_abort();
            bsp_CAN_Sleep();
            SilentNM();        
            SetCanSTBLevel(HIGH);
            break;
        default:
            ;
    }
}

/*-------------------------------------------------------------------------
* Function Name  : NM_D_Online
* Description    : Enable app msg send and set app msg send delay timer
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void NM_D_Online(void)
{
    NmPara.AppMsgSendRequest = 1;
}
/*-------------------------------------------------------------------------
* Function Name  : NM_D_Offline
* Description    : Disable app msg send
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void NM_D_Offline(void)
{
    NmPara.AppMsgSendRequest = 0;
}
