#define  GLOBALS_SERPROC_DIAGNO
#include "defines.h"
#include "protocol_class.h"
#include "app_Service.h"
#include "User_def.h"
#include "TP_Layer.h"
#include "UDS_def.h"
#include "g_includes.h"
#include "app_ServiceProc.h"
#include "UDS_CFG.h"
/*-------------------------------------------------------------------------
* Function Name  : App_19_6Load
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void App_19_6Load(_19_6RetRecord *D19_6RetR, _DTC *DTC, _19_6ReqRecord *D19_6Req)
{
    D19_6RetR->NumAndStatus = DTC->DtcNum.Num;
    D19_6RetR->NumAndStatus = D19_6RetR->NumAndStatus << 8;
    D19_6RetR->NumAndStatus |= DTC->Status.Flag;
    switch(D19_6Req->DTCExtDataRecordNum)
    {
        case 1:
            D19_6RetR->Data[0] = D19_6Req->DTCExtDataRecordNum;
            D19_6RetR->Data[1] = DTC->FaultOccurCount;
            D19_6RetR->dlc = 2;
            break;
        case 2:
            D19_6RetR->Data[0] = D19_6Req->DTCExtDataRecordNum;
            D19_6RetR->Data[1] = DTC->FaultPendCount;
            D19_6RetR->dlc = 2;
            break;
        case 3:
            D19_6RetR->Data[0] = D19_6Req->DTCExtDataRecordNum;
            D19_6RetR->Data[1] = DTC->DTCAgingCount;
            D19_6RetR->dlc = 2;
            break;
        case 4:
            D19_6RetR->Data[0] = D19_6Req->DTCExtDataRecordNum;
            D19_6RetR->Data[1] = DTC->DTCAgedCount;
            D19_6RetR->dlc = 2;
            break;
        case 0xFF:
            D19_6RetR->Data[0] = 1;
            D19_6RetR->Data[1] = DTC->FaultOccurCount;
            D19_6RetR->Data[2] = 2;
            D19_6RetR->Data[3] = DTC->FaultPendCount;
            D19_6RetR->Data[4] = 3;
            D19_6RetR->Data[5] = DTC->DTCAgingCount;
            D19_6RetR->Data[6] = 4;
            D19_6RetR->Data[7] = DTC->DTCAgedCount;
            D19_6RetR->dlc = 8;
            break;
        default:
            Error.FrameErr = RequestOutOfRange;
    }
    
}
/*-------------------------------------------------------------------------
* Function Name  : App_CreateCRCCheckSum
* Description    :
* Input          : INT8U *p ,INT8U Nub
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
INT8U App_CreateCRCCheckSum(INT8U *p , INT8U Nub)
{
    INT8U bCheckSun;
    INT8U i;
    bCheckSun = null;
    while(Nub--)
    {
        bCheckSun ^= *p++;
        for(i = 0; i < 8; i++)
        {
            if(bCheckSun & 0x01)
            {
                bCheckSun = (bCheckSun >> 1) ^ 0x8C;
            }
            else
            bCheckSun >>= 1;
        }
    }
    return(bCheckSun);
}
/*-------------------------------------------------------------------------
* Function Name  : App_CopyRam
* Description    : ran copy
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void App_CopyRam(INT8U *Dp, INT8U *Sp, INT16U Nub)
{
    INT16U b;
    
    for(b = 0; b < Nub; b++)
    {
        *Dp  = *Sp;
        //*Dp++;
        Dp++;
        //*Sp++;
        Sp++;
    }
}
/*-------------------------------------------------------------------------
* Function Name  : App_Load_DID
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void App_Load_DID(INT16U *DID, INT8U *data)
{
    (*DID) = data[0];
    (*DID) = (*DID) << 8;
    (*DID) |= data[1];
}
/*-------------------------------------------------------------------------
* Function Name  : App_ErrorInfoInit
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void App_ErrorInfoInit(_N_USData *AppUSData)
{
    Error.RespSerId = AppUSData->ind.MsgData[0];
    Error.N_TAtype = AppUSData->ind.N_TAtype;
    
    Error.FrameErr = Disable;
}
/*-------------------------------------------------------------------------
* Function Name  : App_EraseRoutine_handle
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
INT8U App_EraseRoutine_handle(void)
{
    int i = 0;
    if(eraseRoutine)
    {
        if(DownInfo.memoryAddress < 0x4000)
        {
            DownInfo.memoryAddress = 0x4000;
        }
        
        
        for (i = 0; i < 16; i++)
        {
            if (D_P_FLASH_Erase_Sector(1, Local2Global(0x4000 + i * 0x400)) != Ok)
                return 1;
        }
        _FEED_COP();
        for (i = 0; i < 15; i++)
        {
            if (D_P_FLASH_Erase_Sector(1, Local2Global(0xc000 + i * 0x400)) != Ok)
                return 1;
        }
        _FEED_COP();
        for (i = 0; i < 16; i++)
        {
            if (D_P_FLASH_Erase_Sector(1, Local2Global(0xFA8000 + i * 0x400)) != Ok)
                return 1;
        }
        _FEED_COP();
        for (i = 0; i < 16; i++)
        {
            if (D_P_FLASH_Erase_Sector(1, Local2Global(0xFB8000 + i * 0x400)) != Ok)
                return 1;
        }
        _FEED_COP();
        for (i = 0; i < 16; i++)
        {
            if (D_P_FLASH_Erase_Sector(1, Local2Global(0xFC8000 + i * 0x400)) != Ok)
                return 1;
        }
        _FEED_COP();
        for (i = 0; i < 16; i++)
        {
            if (D_P_FLASH_Erase_Sector(1, Local2Global(0xFE8000 + i * 0x400)) != Ok)
                return 1;
        }
        _FEED_COP();
        eraseRoutine = 0;
        DownInfo.memoryAddress = 0x4000;
    }
    return 0;
}
 static void AppExecute(void)
{
  COPCTL = 0x01;        //enable watchdog
  ARMCOP = 0x00;
  //value written to ARMCOP register different from 0xAA or 0x55 will reset
  //the MCU immediately. 
}
/*-------------------------------------------------------------------------
* Function Name  : App_11_Reset_handle
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void App_11_Reset_handle(void)
{
 INT32U RestWaitTimes;
    if(N_RSPData.ind.N_Result == STATE0)
    {
        switch(DiagnoCtl.SubFunction)
        {
            case SubHardReset:
                if(WriteleFlag2E == Enable)
                {
                    App_2E_Write_handle();
                    Init2EData();
                    App_CalFuelInit();
                    WriteleFlag2E = Disable;
                }            
            
                //while (1);
                for(;;)              
      
                break;
            case SubSoftReset:
                g_curkeyinput = KeyOFF;
                // bsp_Channel_Sel(CHNAL8);  //lifeng
                    // ADIF = 0;
                // ADCS = 1;
                break;
            case SubKeyOffOnReset:
                g_curkeyinput = KeyOFF;
                // bsp_Channel_Sel(CHNAL8);   //lifeng
                    //  ADIF = 0;
                // ADCS = 1;
                break;
             case ProgramReset:
             RestWaitTimes=8000;
             while (RestWaitTimes--);
                AppExecute() ;
                break;    
                
            default:
                ;
        }
        DiagnoCtl.SubFunction = Disable;
    }
}
/*-------------------------------------------------------------------------
* Function Name  : App_2F_IOCtl_handle
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void App_2F_IOCtl_handle(void)
{
  //--  --//
}