#ifndef __API_CAN_H
#define __API_CAN_H

//#define ID65520 65520//NM-OSEK

#define ID61444 61444
#define ID65266 65266
#define ID65269 65269
#define ID65279 65279
#define ID65252 65252
#define ID64892 64892
#define ID64775 64775
#define ID61440 61440
#define ID65249 65249
#define ID65248 65248
#define ID65110 65110
#define ID61442 61442
#define ID61445 61445
#define ID64923 64923
#define ID61454 61454
#define ID65215 65215
#define ID61441 61441
#define ID60439 60439
#define ID65262 65262
#define ID04119 4096
#define ID65265 65265
#define ID65088 65088
#define ID65226 65226
#define ID65254 65254
#define ID65263 65263
#define ID64972 64972
#define ID65291 65291
#define ID60416 60416
#define ID60160 60160
#define ID65310 65310
#define ID65042 65042
#define ID64964 64964
#define ID65103 65103
#define ID65115 65115
#define ID61447 61447
#define ID65268 65268
//#define ID65266 65266
#define ID65442 65442
#define ID65271 65271

//
#define SJW_1Tq 0
#define SJW_2Tq 1
#define SJW_3Tq 2
#define SAMP_1 0
#define Seg1_10Tq 9
#define Seg1_11Tq 10
#define Seg1_12Tq 11
#define Seg1_13Tq 12
#define Seg1_14Tq 13
#define Seg1_8Tq 7
#define Seg2_7Tq 6
#define Seg2_8Tq 7
#define Seg1_3Tq 2
#define Seg1_4Tq 3
#define Seg1_5Tq 4
#define Seg1_6Tq 5
#define Seg2_1Tq 0
#define Seg2_2Tq 1
#define Seg2_3Tq 2
#define Seg2_4Tq 3
#define Seg2_5Tq 4
#define IDAM_2_32Bit 0
#define IDAM_4_16Bit 1
#define IDHIT0 0
#define CanWakeUpEn 1
#define CanWakeUpDis 0

void bsp_CAN_Init(void);

typedef struct
{
	volatile INT8U REVF;
	INT8U BUSY;
	INT8U BUFF[8];
	INT8U LOST;
	INT8U TT;
} CAN_REV_TYPE;

typedef struct
{
	INT32U sendID;	///ID
	INT8U IDE;		//ǷΪչIDʽ (=0Ϊ׼11λID,=1Ϊչ29λID)
	INT8U RTR;		//ǷΪԶ֡  (=0֡,=1Զ̷)
	INT8U data[8];	//֡
	INT8U dataLen;	//֡ݳ
	INT8U priority; //ȼ (ԽСȼԽ,ѡ0,1,2)

} CANMsg;
typedef struct
{
	INT8U msg[8];
	INT8U dlc;
	INT8U prio;
	INT32U Identifier;
} SendCanMsg;

extern volatile CAN_REV_TYPE CanFrame;

#define success 1
#define failt 0
#define EN_STB 1
#define DIS_STB 0
#define WaitOverTime 6000

#define EMPOTY 0
#define MSG_FULL 1
#define GET_EXTPGN(id) (((((((INT32U)id & 0xFF0000) >> 16) >= 0xF0) ? ((INT32U)id & 0x00FF00) : 0) | ((INT32U)id & 0x2FF0000)) >> 8)

void MSCAN_SendFrame(INT32U id, INT8U *sendMsgBuf, INT8U len);
void bsp_CAN_BusOff(void);
void bsp_CAN_SleepRelease(void);
void bsp_CAN_Sleep(void);
void bsp_tx_msgbuf_abort(void);
extern INT32U bsp_GET_EXTEND_ID(INT8U *IDR0_Add);
INT8U bsp_CANSendExtFrame(INT32U id, INT8U priority, INT8U *txdata, INT8U length);

#endif
