#define GLOBALS_BSP_TIME
#include "defines.h"
#include "g_includes.h"
#include "app_Service.h"
#include "dtc_handle.h"
/*-------------------------------------------------------------------------
* Function Name  : bsp_TIMER0_Init
* Description    : Timer module init
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void bsp_TIMER0_Init(INT8U clkdiv)
{
    TIM0_TSCR1_TSWAI = 1;      //timer 0
    TIM0_TSCR1_TSFRZ = Enable; //timer 0
    TIM0_TSCR1_TFFCA = Disable;
    TIM0_TSCR1_PRNT = Disable; //
    TIM0_TSCR2_PR = clkdiv;    //Bus Clock / clkdiv
    TIM0_TSCR2_TCRE = Disable;
    TIM0_TTOV = Disable;

    TIM0_TCTL1 = Disable;
    TIM0_TCTL2 = Disable;

    TIM0_TFLG2_TOF = Enable;
    TIM0_TSCR1_TEN = Enable;
    TIM0_TSCR2_TOI = Enable;

    TIM0_PACTL_PAEN = Disable;
    
    TIM0_PACTL = Disable;
}
/*-------------------------------------------------------------------------
* Function Name  : bsp_TIMER1_Init
* Description    : Timer module init
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void bsp_TIMER1_Init(INT8U clkdiv)
{
    TIM1_TSCR1_TSWAI = 1;       //timer 0 MCUȴģʽ²
    TIM1_TSCR1_TSFRZ = Enable;  //timer 0 ڶģʽ½ֹ
    TIM1_TSCR1_TFFCA = Disable; //־λ
    TIM1_TSCR1_PRNT = Disable;  //
    TIM1_TSCR2_PR = clkdiv;     //Bus Clock / 4
    TIM1_TSCR2_TCRE = Disable;
    TIM1_TTOV = Disable;

    TIM1_TCTL1 = Disable; //ֹȽϹ
    TIM1_TCTL2 = Disable;

    TIM1_TFLG2_TOF = Enable;
    TIM1_TSCR1_TEN = Enable; //ʹtimer 0 
    TIM1_TSCR2_TOI = Enable; //жʹ

    TIM1_PACTL_PAEN = Disable;
    
    //ӦͨΪ벶׽Ƚ   0:벶׽
    TIM1_TIOS_IOS7 = 0;
    TIM1_TIOS_IOS4 = 0;

    //ò׽Ϊ
    TIM1_TCTL3_EDG7A = 1;
    TIM1_TCTL3_EDG7B = 0;

    TIM1_TCTL3_EDG4A = 1;
    TIM1_TCTL3_EDG4B = 0;

    TIM1_OCPD = 0xFF; //ֹȽ
    TIM1_TC7 = null;
    TIM1_TC4 = null;

    //жϱ־
    TIM1_TFLG1_C7F = 1;
    TIM1_TFLG1_C4F = 1;

    //ʹ벶׽ж
    TIM1_TIE_C7I = 1;
    TIM1_TIE_C4I = 1;

    TIM1_PACTL = Disable;
}
#pragma CODE_SEG NON_BANKED
#pragma TRAP_PROC
/*-------------------------------------------------------------------------
* Function Name  : Api_Timer0_isr
* Description    :
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
interrupt void Api_Timer0_isr(void)
{
    T2MS_FF = 1; //2MS־(ʱ־)
    T20MS_FF++;

    if (g_vehMeter.CurBoardVal)
    {
        if (g_baseTime <= T1_100ms)
        {
            g_baseTime++;
        }
        if (g_baseTime >= T1_100ms)
        {
            g_baseTime = 0;
            if (g_accTime < 5)
            {
                g_accTime++;
            }
        }
    }

    //ת
    if (LINE_IN_LIFT == HIGH)
    {
        if (g_LED.pTrunLTime < T_100ms)
        {
            g_LED.pTrunLTime++;
        }
    }
    else
    {
        g_LED.pTrunLTime = null;
    }

    //ת
    if (LINE_IN_RIGHT == HIGH)
    {
        if (g_LED.pTrunRTime < T_100ms)
        {
            g_LED.pTrunRTime++;
        }
    }
    else
    {
        g_LED.pTrunRTime = null;
    }

    //CAN 
    if (g_CanTimeOut20ms <= T1_100ms)
    {
        g_CanTimeOut20ms++;
    }

    //LOGOʱ
    if (g_Init.InitLogoTime < T_5s)
    {
        g_Init.InitLogoTime++;
    }
    DiagClock.E2_WriteTime++;

    //
    if (g_pBeep->Prio != DisAlr)
    {
        if (g_pBeep->BeepTime < T_2_5s)
        {
            g_pBeep->BeepTime++;
        }
    }
    //-- Flash --//
    OutFlashTimes++;
    OutFlash2P5hzTimes++;
    OutFlash4hzTimes++;

    //4hz
    if (OutFlash4hzTimes > T_125ms)
    {
        OutFlash4hzTimes = 0;
        g_CanSwith.OutFlash4HzFlag = ~g_CanSwith.OutFlash4HzFlag;
    }
    //2.5hz
    if (OutFlash2P5hzTimes > T_200ms)
    {
        OutFlash2P5hzTimes = 0;
        g_CanSwith.OutFlash2P5HzFlag = ~g_CanSwith.OutFlash2P5HzFlag;
    }
    //2hz
    if ((OutFlashTimes == T_250ms) || (OutFlashTimes == T_500ms))
    {
        g_CanSwith.OutFlash2HzFlag = ~g_CanSwith.OutFlash2HzFlag;
    }
    //1hz
    if (OutFlashTimes > T_500ms)
    {
        OutFlashTimes = 0;
        g_CanSwith.OutFlashFlag = ~g_CanSwith.OutFlashFlag;
    }
    //
    CurVehCnt.dw.d16H++;
    Gui_TurnBeep();

    if (Gas_Timer < T_2s)
    {
        Gas_Timer++;
    }
    ///
    TIM0_TFLG2_TOF = ClearFlag;
}
/*-------------------------------------------------------------------------
* Function Name  : Api_Timer1_isr
* Description    :
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
interrupt void Api_Timer1_isr(void)
{
    (void)CheckBusoffDTC();
    if (g_tempMeter.Time <= T_5s)
    {
        g_tempMeter.Time++;
    }
    if (g_gas1Meter.Time <= T_5s)
    {
        g_gas1Meter.Time++;
    }
    if (g_gas2Meter.Time <= T_5s)
    {
        g_gas2Meter.Time++;
    }
    if (g_adblueMeter.Time <= T_5s)
    {
        g_adblueMeter.Time++;
    }
    if ((g_curkeyinput == KeyON))
    {
        g_FuelTimes++;
        if (g_FuelTimes >= 5)
        {
            g_FuelTimes = 0;
            AFCTimerCall();
        }
    }
    else
    {
        g_FuelTimes = 0;
    }
    //OK
    if (Key_type == 1)
    {
        if (G_Button.OK_PushTime <= 10 * T_4s)
        {
            G_Button.OK_PushTime++;
        }
    }
    //UP
    if (Key_type1 == 2)
    {
        if (G_Button.UP_PushTime <= T_4s)
        {
            G_Button.UP_PushTime++;
        }
    }
    //DOWN
    if (Key_type2 == 4)
    {
        if (G_Button.DOWN_PushTime <= T_4s)
        {
            G_Button.DOWN_PushTime++;
        }
    }
    //
    if (DiagClock.TT_STminEnable)
    {
        if (DiagClock.STminTime < DiagClock.OverSTminTime)
        {
            DiagClock.STminTime += 2;
        }
    }
    if (DiagClock.TT_BsEnable)
    {
        if (DiagClock.BsTime < DiagClock.OverBsTime)
        {
            DiagClock.BsTime += 2;
        }
    }
    if (DiagClock.TT_CrEnable)
    {
        if (DiagClock.CrTime < DiagClock.OverCrTime)
        {
            DiagClock.CrTime += 2;
        }
    }

    if (DiagClock.TT_SequenceEnable)
    {
        if (DiagClock.SequenceTime < DiagClock.OverSequenceTime)
        {
            DiagClock.SequenceTime += 2;
        }
    }

    if (DiagClock.TT_SessionEnable)
    {
        if (DiagClock.SessionTime < DiagClock.OverSessionTime)
        {
            DiagClock.SessionTime += 2;
        }
    }

    if (DiagClock.TT_UnlockEnable)
    {
        if (DiagClock.UnlockTime < DiagClock.OverUnlockTime)
        {
            DiagClock.UnlockTime += 2;
        }
    }

    if (g_canClock.CanSendTime < T_5s)
    {
        g_canClock.CanSendTime++;
    }

    ///
    TIM1_TFLG2_TOF = ClearFlag;
}
/*-------------------------------------------------------------------------
* Function Name  : Api_VehCap_isr
* Description    :
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
interrupt void Api_VehCap_isr(void)
{
    CurVehCnt.dw.d16L = TIM1_TC7;

    if (CurVehCnt.dw32 > OldVehCnt.dw32)
    {
        VehFre.Cycl = CurVehCnt.dw32 - OldVehCnt.dw32;
    }
    if (VehFre.Cycl > VehFreLimit)
    {
        AccPulse++;
    }

    OldVehCnt.dw32 = CurVehCnt.dw32;

    ///
    TIM1_TFLG1_C7F = ClearFlag;
}
/*-------------------------------------------------------------------------
* Function Name  : Api_RadioCap_isr
* Description    :
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
interrupt void Api_RadioCap_isr(void)
{
#if 0
    CurRadioCnt.dw.d16L = TIM0_TC3;

    bRadioTypeCn = 35;
    RadarBuzzerFre1 = 1;
    if ((TIM0_TCTL4_EDG3B == 0) && (TIM0_TCTL4_EDG3A == 1))
    {
        RadarBuzzerFre = 1;
        TIM0_TCTL4_EDG3B = 1;
        TIM0_TCTL4_EDG3A = 0;
    }
    else if ((TIM0_TCTL4_EDG3B == 1) && (TIM0_TCTL4_EDG3A == 0))
    {
        RadarBuzzerFre = 0;
        TIM0_TCTL4_EDG3B = 0;
        TIM0_TCTL4_EDG3A = 1;
    }

    ///
    TIM0_TFLG1_C3F = ClearFlag;
#endif    
}

#pragma CODE_SEG DEFAULT
